/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.core;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.pojo.ServiceInfo;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.naming.core.Instance;
import com.alibaba.nacos.naming.core.InstanceOperator;
import com.alibaba.nacos.naming.core.InstancePatchObject;
import com.alibaba.nacos.naming.core.Service;
import com.alibaba.nacos.naming.core.ServiceManager;
import com.alibaba.nacos.naming.core.v2.upgrade.doublewrite.execute.InstanceUpgradeHelper;
import com.alibaba.nacos.naming.healthcheck.RsInfo;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.naming.misc.SwitchDomain;
import com.alibaba.nacos.naming.pojo.InstanceOperationContext;
import com.alibaba.nacos.naming.pojo.InstanceOperationInfo;
import com.alibaba.nacos.naming.pojo.Subscriber;
import com.alibaba.nacos.naming.pojo.instance.BeatInfoInstanceBuilder;
import com.alibaba.nacos.naming.push.UdpPushService;
import com.alibaba.nacos.naming.push.v1.ClientInfo;
import com.alibaba.nacos.naming.push.v1.DataSource;
import com.alibaba.nacos.naming.push.v1.NamingSubscriberServiceV1Impl;
import com.alibaba.nacos.naming.push.v1.PushClient;
import com.alibaba.nacos.naming.utils.InstanceUtil;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Component;

@Component
public class InstanceOperatorServiceImpl
implements InstanceOperator {
    private final ServiceManager serviceManager;
    private final SwitchDomain switchDomain;
    private final UdpPushService pushService;
    private final NamingSubscriberServiceV1Impl subscriberServiceV1;
    private final InstanceUpgradeHelper instanceUpgradeHelper;
    private DataSource pushDataSource = new DataSource(){

        @Override
        public String getData(PushClient client) {
            ServiceInfo result = new ServiceInfo(client.getServiceName(), client.getClusters());
            try {
                Subscriber subscriber = new Subscriber(client.getAddrStr(), client.getAgent(), client.getApp(), client.getIp(), client.getNamespaceId(), client.getServiceName(), client.getPort(), client.getClusters());
                result = InstanceOperatorServiceImpl.this.listInstance(client.getNamespaceId(), client.getServiceName(), subscriber, client.getClusters(), false);
            }
            catch (Exception e) {
                Loggers.SRV_LOG.warn("PUSH-SERVICE: service is not modified", (Throwable)e);
            }
            result.setCacheMillis(InstanceOperatorServiceImpl.this.switchDomain.getPushCacheMillis(client.getServiceName()));
            return JacksonUtils.toJson((Object)result);
        }
    };

    public InstanceOperatorServiceImpl(ServiceManager serviceManager, SwitchDomain switchDomain, UdpPushService pushService, NamingSubscriberServiceV1Impl subscriberServiceV1, InstanceUpgradeHelper instanceUpgradeHelper) {
        this.serviceManager = serviceManager;
        this.switchDomain = switchDomain;
        this.pushService = pushService;
        this.subscriberServiceV1 = subscriberServiceV1;
        this.instanceUpgradeHelper = instanceUpgradeHelper;
    }

    @Override
    public void registerInstance(String namespaceId, String serviceName, com.alibaba.nacos.api.naming.pojo.Instance instance) throws NacosException {
        Instance coreInstance = this.parseInstance(instance);
        this.serviceManager.registerInstance(namespaceId, serviceName, coreInstance);
    }

    @Override
    public void removeInstance(String namespaceId, String serviceName, com.alibaba.nacos.api.naming.pojo.Instance instance) throws NacosException {
        Instance coreInstance = this.parseInstance(instance);
        Service service = this.serviceManager.getService(namespaceId, serviceName);
        if (service == null) {
            Loggers.SRV_LOG.warn("remove instance from non-exist service: {}", (Object)serviceName);
            return;
        }
        this.serviceManager.removeInstance(namespaceId, serviceName, instance.isEphemeral(), coreInstance);
    }

    @Override
    public void updateInstance(String namespaceId, String serviceName, com.alibaba.nacos.api.naming.pojo.Instance instance) throws NacosException {
        Instance coreInstance = this.parseInstance(instance);
        this.serviceManager.updateInstance(namespaceId, serviceName, coreInstance);
    }

    @Override
    public void patchInstance(String namespaceId, String serviceName, InstancePatchObject patchObject) throws NacosException {
        Instance instance = this.serviceManager.getInstance(namespaceId, serviceName, patchObject.getCluster(), patchObject.getIp(), patchObject.getPort());
        if (instance == null) {
            throw new NacosException(400, "instance not found");
        }
        if (null != patchObject.getMetadata()) {
            instance.setMetadata(patchObject.getMetadata());
        }
        if (null != patchObject.getApp()) {
            instance.setApp(patchObject.getApp());
        }
        if (null != patchObject.getEnabled()) {
            instance.setEnabled(patchObject.getEnabled());
        }
        if (null != patchObject.getHealthy()) {
            instance.setHealthy(patchObject.getHealthy());
        }
        instance.setLastBeat(System.currentTimeMillis());
        instance.validate();
        this.serviceManager.updateInstance(namespaceId, serviceName, instance);
    }

    @Override
    public ServiceInfo listInstance(String namespaceId, String serviceName, Subscriber subscriber, String cluster, boolean healthOnly) throws Exception {
        List hosts;
        ClientInfo clientInfo = new ClientInfo(subscriber.getAgent());
        String clientIP = subscriber.getIp();
        ServiceInfo result = new ServiceInfo(serviceName, cluster);
        Service service = this.serviceManager.getService(namespaceId, serviceName);
        long cacheMillis = this.switchDomain.getDefaultCacheMillis();
        try {
            if (subscriber.getPort() > 0 && this.pushService.canEnablePush(subscriber.getAgent())) {
                this.subscriberServiceV1.addClient(namespaceId, serviceName, cluster, subscriber.getAgent(), new InetSocketAddress(clientIP, subscriber.getPort()), this.pushDataSource, "", "");
                cacheMillis = this.switchDomain.getPushCacheMillis(serviceName);
            }
        }
        catch (Exception e) {
            Loggers.SRV_LOG.error("[NACOS-API] failed to added push client {}, {}:{}", new Object[]{clientInfo, clientIP, subscriber.getPort(), e});
            cacheMillis = this.switchDomain.getDefaultCacheMillis();
        }
        if (service == null) {
            if (Loggers.SRV_LOG.isDebugEnabled()) {
                Loggers.SRV_LOG.debug("no instance to serve for service: {}", (Object)serviceName);
            }
            result.setCacheMillis(cacheMillis);
            return result;
        }
        this.checkIfDisabled(service);
        List<Instance> srvedIps = service.srvIPs(Arrays.asList(StringUtils.split((String)cluster, (String)",")));
        if (service.getSelector() != null && StringUtils.isNotBlank((String)clientIP)) {
            srvedIps = service.getSelector().select(clientIP, srvedIps);
        }
        if (CollectionUtils.isEmpty(srvedIps)) {
            if (Loggers.SRV_LOG.isDebugEnabled()) {
                Loggers.SRV_LOG.debug("no instance to serve for service: {}", (Object)serviceName);
            }
            result.setCacheMillis(cacheMillis);
            result.setLastRefTime(System.currentTimeMillis());
            result.setChecksum(service.getChecksum());
            return result;
        }
        long total = 0L;
        HashMap ipMap = new HashMap(2);
        ipMap.put(Boolean.TRUE, new ArrayList());
        ipMap.put(Boolean.FALSE, new ArrayList());
        for (Instance ip : srvedIps) {
            if (!ip.isEnabled()) continue;
            ((List)ipMap.get(ip.isHealthy())).add(ip);
            ++total;
        }
        double threshold = service.getProtectThreshold();
        if ((double)((float)((List)ipMap.get(Boolean.TRUE)).size() / (float)total) <= threshold) {
            Loggers.SRV_LOG.warn("protect threshold reached, return all ips, service: {}", (Object)result.getName());
            result.setReachProtectionThreshold(true);
            hosts = Stream.of(Boolean.TRUE, Boolean.FALSE).map(ipMap::get).flatMap(Collection::stream).map(InstanceUtil::deepCopy).peek(instance -> instance.setHealthy(true)).collect(Collectors.toCollection(LinkedList::new));
        } else {
            result.setReachProtectionThreshold(false);
            hosts = new LinkedList((Collection)ipMap.get(Boolean.TRUE));
            if (!healthOnly) {
                hosts.addAll((Collection)ipMap.get(Boolean.FALSE));
            }
        }
        result.setHosts(hosts);
        result.setCacheMillis(cacheMillis);
        result.setLastRefTime(System.currentTimeMillis());
        result.setChecksum(service.getChecksum());
        return result;
    }

    @Override
    public com.alibaba.nacos.api.naming.pojo.Instance getInstance(String namespaceId, String serviceName, String cluster, String ip, int port) throws NacosException {
        Service service = this.serviceManager.getService(namespaceId, serviceName);
        this.serviceManager.checkServiceIsNull(service, namespaceId, serviceName);
        ArrayList<String> clusters = new ArrayList<String>();
        clusters.add(cluster);
        List<Instance> ips = service.allIPs(clusters);
        if (ips == null || ips.isEmpty()) {
            throw new NacosException(404, "no ips found for cluster " + cluster + " in service " + serviceName);
        }
        for (Instance each : ips) {
            if (!each.getIp().equals(ip) || each.getPort() != port) continue;
            return each;
        }
        throw new NacosException(404, "no matched ip found!");
    }

    private void checkIfDisabled(Service service) throws Exception {
        if (!service.getEnabled().booleanValue()) {
            throw new Exception("service is disabled now.");
        }
    }

    @Override
    public int handleBeat(String namespaceId, String serviceName, String ip, int port, String cluster, RsInfo clientBeat, BeatInfoInstanceBuilder builder) throws NacosException {
        Instance instance = this.serviceManager.getInstance(namespaceId, serviceName, cluster, ip, port);
        if (instance == null) {
            if (clientBeat == null) {
                return 20404;
            }
            Loggers.SRV_LOG.warn("[CLIENT-BEAT] The instance has been removed for health mechanism, perform data compensation operations, beat: {}, serviceName: {}", (Object)clientBeat, (Object)serviceName);
            instance = this.parseInstance(builder.setBeatInfo(clientBeat).setServiceName(serviceName).build());
            this.serviceManager.registerInstance(namespaceId, serviceName, instance);
        }
        Service service = this.serviceManager.getService(namespaceId, serviceName);
        this.serviceManager.checkServiceIsNull(service, namespaceId, serviceName);
        if (clientBeat == null) {
            clientBeat = new RsInfo();
            clientBeat.setIp(ip);
            clientBeat.setPort(port);
            clientBeat.setCluster(cluster);
        }
        service.processClientBeat(clientBeat);
        return 10200;
    }

    @Override
    public long getHeartBeatInterval(String namespaceId, String serviceName, String ip, int port, String cluster) {
        Instance instance = this.serviceManager.getInstance(namespaceId, serviceName, cluster, ip, port);
        if (null != instance && instance.containsMetadata("preserved.heart.beat.interval")) {
            return instance.getInstanceHeartBeatInterval();
        }
        return this.switchDomain.getClientBeatInterval();
    }

    @Override
    public List<? extends com.alibaba.nacos.api.naming.pojo.Instance> listAllInstances(String namespaceId, String serviceName) throws NacosException {
        Service service = this.serviceManager.getService(namespaceId, serviceName);
        this.serviceManager.checkServiceIsNull(service, namespaceId, serviceName);
        return service.allIPs();
    }

    @Override
    public List<String> batchUpdateMetadata(String namespaceId, InstanceOperationInfo instanceOperationInfo, Map<String, String> metadata) {
        return this.batchOperate(namespaceId, instanceOperationInfo, metadata, "update");
    }

    @Override
    public List<String> batchDeleteMetadata(String namespaceId, InstanceOperationInfo instanceOperationInfo, Map<String, String> metadata) throws NacosException {
        return this.batchOperate(namespaceId, instanceOperationInfo, metadata, "remove");
    }

    private List<String> batchOperate(String namespaceId, InstanceOperationInfo instanceOperationInfo, Map<String, String> metadata, String updateInstanceMetadataAction) {
        LinkedList<String> result = new LinkedList<String>();
        for (Instance each : this.batchOperateMetadata(namespaceId, instanceOperationInfo, metadata, updateInstanceMetadataAction)) {
            result.add(each.getDatumKey() + ":" + (each.isEphemeral() ? "ephemeral" : "persist"));
        }
        return result;
    }

    private List<Instance> batchOperateMetadata(String namespace, InstanceOperationInfo instanceOperationInfo, Map<String, String> metadata, String action) {
        Function<InstanceOperationContext, List<Instance>> operateFunction = instanceOperationContext -> {
            try {
                return this.serviceManager.updateMetadata(instanceOperationContext.getNamespace(), instanceOperationContext.getServiceName(), instanceOperationContext.getEphemeral(), action, instanceOperationContext.getAll(), instanceOperationContext.getInstances(), metadata);
            }
            catch (NacosException e) {
                Loggers.SRV_LOG.warn("UPDATE-METADATA: updateMetadata failed", (Throwable)e);
                return new ArrayList();
            }
        };
        return this.serviceManager.batchOperate(namespace, instanceOperationInfo, operateFunction);
    }

    private Instance parseInstance(com.alibaba.nacos.api.naming.pojo.Instance apiInstance) throws NacosException {
        Instance result = this.instanceUpgradeHelper.toV1(apiInstance);
        result.setApp(apiInstance.getMetadata().getOrDefault("app", "DEFAULT"));
        result.validate();
        return result;
    }
}

