/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.log;

import java.util.HashMap;
import org.eclipse.equinox.log.ExtendedLogService;
import org.eclipse.equinox.log.Logger;
import org.eclipse.osgi.internal.log.ExtendedLogServiceFactory;
import org.eclipse.osgi.internal.log.LoggerImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;

public class ExtendedLogServiceImpl
implements ExtendedLogService,
LogService {
    private final ExtendedLogServiceFactory factory;
    private volatile Bundle bundle;
    private final HashMap<String, Logger> loggerCache = new HashMap();

    public ExtendedLogServiceImpl(ExtendedLogServiceFactory factory, Bundle bundle) {
        this.factory = factory;
        this.bundle = bundle;
    }

    @Override
    public void log(int level, String message) {
        this.log((ServiceReference)null, level, message, (Throwable)null);
    }

    @Override
    public void log(int level, String message, Throwable exception) {
        this.log((ServiceReference)null, level, message, exception);
    }

    @Override
    public void log(ServiceReference sr, int level, String message) {
        this.log(sr, level, message, (Throwable)null);
    }

    @Override
    public void log(ServiceReference sr, int level, String message, Throwable exception) {
        this.getLogger(null).log(sr, level, message, exception);
    }

    @Override
    public void log(Object context, int level, String message) {
        this.log(context, level, message, null);
    }

    @Override
    public void log(Object context, int level, String message, Throwable exception) {
        this.getLogger(null).log(context, level, message, exception);
    }

    @Override
    public synchronized Logger getLogger(String name2) {
        Logger logger = this.loggerCache.get(name2);
        if (logger == null) {
            logger = new LoggerImpl(this, name2);
            this.loggerCache.put(name2, logger);
        }
        return logger;
    }

    @Override
    public Logger getLogger(Bundle logBundle, String name2) {
        if (logBundle == null || logBundle == this.bundle) {
            return this.getLogger(name2);
        }
        this.factory.checkLogPermission();
        ExtendedLogServiceImpl bundleLogService = this.factory.getLogService(logBundle);
        return bundleLogService.getLogger(name2);
    }

    @Override
    public String getName() {
        return this.getLogger(null).getName();
    }

    @Override
    public boolean isLoggable(int level) {
        return this.getLogger(null).isLoggable(level);
    }

    boolean isLoggable(String name2, int level) {
        return this.factory.isLoggable(this.bundle, name2, level);
    }

    void log(String name2, Object context, int level, String message, Throwable exception) {
        this.factory.log(this.bundle, name2, context, level, message, exception);
    }

    void setBundle(Bundle bundle) {
        this.bundle = bundle;
    }
}

