/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.utilities;

import java.util.TreeMap;

public class ServerXmlFormatter {
    private static final String INDENT = "    ";
    private static final String NL = System.getProperty("line.separator");
    private static final String NAME_PREFIX = "name=\"";
    private static final String DEFAULT_VALUE_PREFIX = "defaultValue=\"";
    private static final String VARIABLE_TAG = "<variable";

    public static String formatServerXml(String input) {
        StringBuilder result = new StringBuilder();
        String[] stringArray = input.split(System.getProperty("line.separator"));
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (!line.trim().isEmpty()) {
                if (ServerXmlFormatter.needsBlankAppended(line)) {
                    result.append(line).append(NL).append(NL);
                } else if (line.trim().startsWith(VARIABLE_TAG)) {
                    result.append(ServerXmlFormatter.reorderVariable(line)).append(NL);
                } else {
                    result.append(line).append(NL);
                }
            }
            ++n2;
        }
        String resultString = result.toString();
        int startOfVariables = resultString.indexOf("\n    <variable") + 1;
        if (startOfVariables > 0) {
            int sensitiveVarsComment = resultString.indexOf(String.valueOf(NL) + INDENT + "<!--", startOfVariables);
            if (sensitiveVarsComment > 0) {
                String variables = resultString.substring(startOfVariables, sensitiveVarsComment);
                int startOfSensitiveVariables = (resultString = String.valueOf(resultString.substring(0, startOfVariables)) + ServerXmlFormatter.variablesSortedByName(variables) + NL + resultString.substring(sensitiveVarsComment)).indexOf("\n    <variable", sensitiveVarsComment) + 1;
                if (startOfSensitiveVariables > 0) {
                    int endOfVariables = resultString.lastIndexOf(VARIABLE_TAG) + resultString.substring(resultString.lastIndexOf(VARIABLE_TAG)).indexOf(NL);
                    String sensitiveVariables = resultString.substring(startOfSensitiveVariables, endOfVariables);
                    resultString = String.valueOf(resultString.substring(0, startOfSensitiveVariables)) + ServerXmlFormatter.variablesSortedByName(sensitiveVariables) + resultString.substring(endOfVariables);
                }
            } else {
                int endOfVariables = resultString.lastIndexOf(VARIABLE_TAG) + resultString.substring(resultString.lastIndexOf(VARIABLE_TAG)).indexOf(NL);
                String variables = resultString.substring(startOfVariables, endOfVariables);
                resultString = String.valueOf(resultString.substring(0, startOfVariables)) + ServerXmlFormatter.variablesSortedByName(variables) + resultString.substring(endOfVariables);
            }
        }
        return resultString.toString();
    }

    private static boolean needsBlankAppended(String line) {
        if (line.startsWith("    </")) {
            return true;
        }
        return line.startsWith("    <") && !line.trim().startsWith(VARIABLE_TAG) && line.trim().endsWith("/>");
    }

    private static String reorderVariable(String variableLine) {
        int nameStart = variableLine.indexOf(NAME_PREFIX);
        int nameEnd = variableLine.indexOf("\"", nameStart + NAME_PREFIX.length());
        int defaultValueStart = variableLine.indexOf(DEFAULT_VALUE_PREFIX);
        int defaultValueEnd = variableLine.indexOf("\"", defaultValueStart + DEFAULT_VALUE_PREFIX.length());
        if (nameStart < defaultValueStart || nameStart == -1 || nameEnd == -1 || defaultValueStart == -1 || defaultValueEnd == -1) {
            return variableLine;
        }
        return String.valueOf(variableLine.substring(0, defaultValueStart)) + variableLine.substring(nameStart, nameEnd + 1) + " " + variableLine.substring(defaultValueStart, defaultValueEnd + 1) + variableLine.substring(nameEnd + 1);
    }

    private static String variablesSortedByName(String variables) {
        String[] variableEntries = variables.split(NL);
        TreeMap<String, String> variablesByName = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        String[] stringArray = variableEntries;
        int n = variableEntries.length;
        int n2 = 0;
        while (n2 < n) {
            String var = stringArray[n2];
            int nameStart = var.indexOf(NAME_PREFIX) + NAME_PREFIX.length();
            int nameEnd = var.length() - 1;
            int i = nameStart;
            while (i < var.length()) {
                if (var.charAt(i) == '\"') {
                    nameEnd = i;
                    break;
                }
                ++i;
            }
            variablesByName.put(var.substring(nameStart, nameEnd), var);
            ++n2;
        }
        StringBuilder orderedResult = new StringBuilder();
        boolean first = true;
        for (String variable : variablesByName.values()) {
            if (!first) {
                orderedResult.append(NL);
            }
            orderedResult.append(variable);
            first = false;
        }
        return orderedResult.toString();
    }
}

