/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.technology;

import com.ibm.ws.report.Messages;
import com.ibm.ws.report.technology.AbstractTechnology;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class TechSummary {
    private boolean isEclipseReport = false;
    public static final String DETECT_JAXRPC_PREVALIDATED = "TechName_JAXRPCPrevalidated";
    public static final String DETECT_JAXRPC_PREVALIDATED_APPPROVIDED = "TechName_JAXRPCPrevalidatedAppProvided";
    private final List<String> projectNames = new ArrayList<String>();
    private final boolean[] supportedPlatforms = new boolean[]{true, true, true, true, true, true, true, true};
    private final SortedSet<String> footnoteEntries = new TreeSet<String>();
    private OrderedTech loadedLineBreak = null;
    private TreeMap<OrderedTech, TreeSet<OrderedTech>> mapOfRowHeaderToTechnologies = null;

    public TechSummary(boolean isEclipseReport) {
        this.isEclipseReport = isEclipseReport;
        this.mapOfRowHeaderToTechnologies = new TreeMap(new MyTechComp());
    }

    public void addTechnology(int index, AbstractTechnology tech) {
        OrderedTech orderedTech = new OrderedTech(index, tech);
        if (tech.getName().startsWith("line-break")) {
            this.loadedLineBreak = orderedTech;
        } else if (this.loadedLineBreak != null) {
            if (!this.mapOfRowHeaderToTechnologies.containsKey(this.loadedLineBreak)) {
                TreeSet<OrderedTech> setOfTech = new TreeSet<OrderedTech>(new MyTechComp());
                setOfTech.add(orderedTech);
                this.mapOfRowHeaderToTechnologies.put(this.loadedLineBreak, setOfTech);
            } else {
                TreeSet<OrderedTech> setOfTech = this.mapOfRowHeaderToTechnologies.get(this.loadedLineBreak);
                setOfTech.add(orderedTech);
            }
            this.updateFootNotes(tech.getName(), tech.getReferredToAs(), tech.getId());
            this.updateSupportedPlatforms(tech.getSupport());
        }
    }

    public void addProjectName(String name2) {
        this.projectNames.add(name2);
    }

    private void updateSupportedPlatforms(int[] rowXs) {
        int i = 0;
        while (i < rowXs.length) {
            boolean isChecked;
            boolean bl = isChecked = rowXs[i] != -1;
            if (!isChecked) {
                this.supportedPlatforms[i] = false;
            }
            ++i;
        }
    }

    private void updateFootNotes(String label, String referredToAs, String id) {
        if (referredToAs != null) {
            if (id.equals(DETECT_JAXRPC_PREVALIDATED) || id.equals(DETECT_JAXRPC_PREVALIDATED_APPPROVIDED)) {
                this.footnoteEntries.add(referredToAs);
            } else {
                String footnoteContent = Messages.getFormattedMessage(Messages.getString("ReportWriter_Technology_Also_Known_As"), label, referredToAs);
                this.footnoteEntries.add(footnoteContent);
            }
        }
    }

    public TreeMap<OrderedTech, TreeSet<OrderedTech>> getMapOfRowHeaderToTechnologies() {
        return this.mapOfRowHeaderToTechnologies;
    }

    public SortedSet<String> getFootNotes() {
        return this.footnoteEntries;
    }

    public boolean[] getSupportedPlatforms() {
        return this.supportedPlatforms;
    }

    public List<String> getProjectNames() {
        return this.projectNames;
    }

    public String getProjectName() {
        return this.projectNames.get(0);
    }

    private class MyTechComp
    implements Comparator<OrderedTech> {
        private MyTechComp() {
        }

        @Override
        public int compare(OrderedTech e1, OrderedTech e2) {
            return e1.getIndex().compareTo(e2.getIndex());
        }
    }

    public class OrderedTech {
        private final Integer index;
        private final AbstractTechnology tech;

        public OrderedTech(int index, AbstractTechnology tech) {
            this.index = index;
            this.tech = tech;
        }

        public Integer getIndex() {
            return this.index;
        }

        public AbstractTechnology getTech() {
            return this.tech;
        }
    }
}

