/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.utilities.eetechnologies;

import com.ibm.ws.report.binary.ReportInputData;
import com.ibm.ws.report.binary.featurelist.FeatureUtil;
import com.ibm.ws.report.binary.utilities.ConfigFeatureVersionInfo;
import com.ibm.ws.report.binary.utilities.JakartaJavaEEFeatureVersions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class Technology {
    protected final ReportInputData.AppServer sourceAppServer;
    protected final ReportInputData.AppServer targetAppServer;
    protected final ReportInputData.JavaEEVersion sourceJavaEEVersion;
    protected final ReportInputData.JavaEEVersion targetJavaEEVersion;
    protected Map<String, Set<String>> reportToRuleIds = new HashMap<String, Set<String>>();

    public Technology(ReportInputData.AppServer sourceAppServer, ReportInputData.AppServer targetAppServer, ReportInputData.JavaEEVersion sourceJavaEEVersion, ReportInputData.JavaEEVersion targetJavaEEVersion) {
        this.sourceAppServer = sourceAppServer;
        this.targetAppServer = targetAppServer;
        this.sourceJavaEEVersion = sourceJavaEEVersion;
        this.targetJavaEEVersion = targetJavaEEVersion != null ? targetJavaEEVersion : (this.sourceAppServer != null && this.sourceAppServer == ReportInputData.AppServer.WAS90 ? ReportInputData.JavaEEVersion.EE7 : ReportInputData.JavaEEVersion.EE6);
    }

    public abstract List<String> getRules();

    public abstract List<String> getAllRules();

    public abstract List<String> getRules(Set<String> var1, ConfigFeatureVersionInfo var2, Map<ReportInputData.JavaEEVersion, Set<String>> var3);

    public boolean includeEE7() {
        if (this.targetJavaEEVersion != null) {
            int targetEENumber = this.targetJavaEEVersion.getVersionNumber();
            if (this.sourceJavaEEVersion != null) {
                int sourceEENumber;
                int n = sourceEENumber = this.sourceJavaEEVersion == null ? ReportInputData.JavaEEVersion.EE6.getVersionNumber() : this.sourceJavaEEVersion.getVersionNumber();
                return sourceEENumber < 7 && targetEENumber >= 7;
            }
            return targetEENumber >= 7;
        }
        return false;
    }

    public boolean includeEE8() {
        if (this.targetJavaEEVersion != null) {
            int targetEENumber = this.targetJavaEEVersion.getVersionNumber();
            if (this.sourceJavaEEVersion != null) {
                int sourceEENumber;
                int n = sourceEENumber = this.sourceJavaEEVersion == null ? ReportInputData.JavaEEVersion.EE6.getVersionNumber() : this.sourceJavaEEVersion.getVersionNumber();
                return sourceEENumber < 8 && targetEENumber >= 8;
            }
            return targetEENumber >= 8;
        }
        return false;
    }

    public boolean includeEE9() {
        if (this.targetJavaEEVersion != null) {
            int targetEENumber = this.targetJavaEEVersion.getVersionNumber();
            if (this.sourceJavaEEVersion != null) {
                int sourceEENumber;
                int n = sourceEENumber = this.sourceJavaEEVersion == null ? ReportInputData.JavaEEVersion.EE6.getVersionNumber() : this.sourceJavaEEVersion.getVersionNumber();
                return sourceEENumber < 9 && targetEENumber >= 9;
            }
            return targetEENumber >= 9;
        }
        return false;
    }

    public boolean includeEE10() {
        if (this.targetJavaEEVersion != null) {
            int targetEENumber = this.targetJavaEEVersion.getVersionNumber();
            if (this.sourceJavaEEVersion != null) {
                int sourceEENumber;
                int n = sourceEENumber = this.sourceJavaEEVersion == null ? ReportInputData.JavaEEVersion.EE6.getVersionNumber() : this.sourceJavaEEVersion.getVersionNumber();
                return sourceEENumber < 10 && targetEENumber >= 10;
            }
            return targetEENumber >= 10;
        }
        return false;
    }

    public boolean includeEE11() {
        if (this.targetJavaEEVersion != null) {
            int sourceEENumber;
            int targetEENumber = this.targetJavaEEVersion.getVersionNumber();
            int n = sourceEENumber = this.sourceJavaEEVersion != null ? this.sourceJavaEEVersion.getVersionNumber() : ReportInputData.JavaEEVersion.EE6.getVersionNumber();
            return sourceEENumber < 11 && targetEENumber >= 11;
        }
        return false;
    }

    public boolean isSourceBefore(ReportInputData.JavaEEVersion version) {
        int sourceEENumber;
        if (version == null) {
            return false;
        }
        int n = sourceEENumber = this.sourceJavaEEVersion == null ? ReportInputData.JavaEEVersion.EE6.getVersionNumber() : this.sourceJavaEEVersion.getVersionNumber();
        return sourceEENumber < version.getVersionNumber();
    }

    public List<String> getDefaultRuleIds() {
        ArrayList<String> defaultRuleIds = new ArrayList<String>();
        List<String> reports = this.getRules();
        for (String report : reports) {
            Set<String> ruleIds = this.reportToRuleIds.get(report);
            if (ruleIds == null) continue;
            defaultRuleIds.addAll(ruleIds);
        }
        return defaultRuleIds;
    }

    protected boolean containsFeatureAtEELevelOrLater(Set<String> features, ReportInputData.JavaEEVersion eeLevel, Map<ReportInputData.JavaEEVersion, Set<String>> libertyJavaEEJakartaFeatures) {
        if (libertyJavaEEJakartaFeatures == null || eeLevel == null) {
            return false;
        }
        HashSet<String> featuresAtLevelAndAbove = new HashSet<String>();
        Set<String> featuresAtLevel = libertyJavaEEJakartaFeatures.get((Object)eeLevel);
        if (featuresAtLevel != null) {
            featuresAtLevelAndAbove.addAll(featuresAtLevel);
        }
        ReportInputData.JavaEEVersion[] eeLevels = ReportInputData.JavaEEVersion.values();
        int i = 0;
        while (i < eeLevels.length) {
            ReportInputData.JavaEEVersion possibleHigherVersion = eeLevels[i];
            if (possibleHigherVersion.getVersionNumber() > eeLevel.getVersionNumber() && (featuresAtLevel = libertyJavaEEJakartaFeatures.get((Object)possibleHigherVersion)) != null) {
                featuresAtLevelAndAbove.addAll(featuresAtLevel);
            }
            ++i;
        }
        for (String feature : features) {
            if (feature.startsWith("jndi") || feature.startsWith("jdbc") || !featuresAtLevelAndAbove.contains(feature)) continue;
            return true;
        }
        return false;
    }

    protected boolean containsFeatureOrLater(Set<String> features, String feature) {
        String prefix = feature.substring(0, feature.indexOf(45));
        String jakartaPrefix = JakartaJavaEEFeatureVersions.JAVAEE_PREFIXES_TO_JAKARTA_PREFIXES.get(prefix);
        String featureFound = null;
        for (String currentFeature : features) {
            String currentPrefix = currentFeature.substring(0, currentFeature.indexOf(45));
            if (currentPrefix.equals(prefix)) {
                featureFound = currentFeature;
                break;
            }
            if (jakartaPrefix == null || !currentPrefix.contentEquals(jakartaPrefix)) continue;
            featureFound = currentFeature;
            break;
        }
        if (featureFound != null) {
            return FeatureUtil.compareFeatureVersions(featureFound, feature) >= 0;
        }
        return false;
    }

    public boolean isWasToLiberty() {
        return !(this.sourceAppServer != null && !this.sourceAppServer.isWAS_Traditional() || this.targetAppServer != null && this.targetAppServer.isWAS_Traditional());
    }

    public void setReportToRuleIds(Map<String, Set<String>> reportToRuleIds) {
        this.reportToRuleIds = reportToRuleIds;
    }

    public Map<String, Set<String>> getReportToRuleIds() {
        return this.reportToRuleIds;
    }
}

