/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.utilities;

import com.ibm.ws.report.binary.Messages;
import com.ibm.ws.report.binary.rules.Rule;
import com.ibm.ws.report.binary.rules.RuleType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RuleCategory {
    private String categoryKey = null;
    private String categoryDescription = null;
    private final Map<String, RuleCategory> subCategories = new HashMap<String, RuleCategory>();
    private final Map<String, List<String>> ruleDescriptionsByType = new HashMap<String, List<String>>();
    private final Set<String> allRulesUnderThisCategory = new HashSet<String>();

    public RuleCategory(String descriptionKey) {
        this(descriptionKey, null);
    }

    public RuleCategory(String categoryKey, String subCategoryKey) {
        this.categoryKey = categoryKey;
        this.categoryDescription = Messages.getCategoryDescription(categoryKey);
        if (subCategoryKey != null) {
            this.subCategories.put(subCategoryKey, new RuleCategory(subCategoryKey));
        }
    }

    public RuleCategory addSubCategory(String categoryKey) {
        RuleCategory category = new RuleCategory(categoryKey);
        this.subCategories.put(categoryKey, category);
        return category;
    }

    private void addRuleByType(String ruleDesc, String ruleType) {
        List<String> listForRuleType = this.ruleDescriptionsByType.get(ruleType);
        if (listForRuleType == null) {
            listForRuleType = new ArrayList<String>();
            this.ruleDescriptionsByType.put(ruleType, listForRuleType);
        }
        if (!listForRuleType.contains(ruleDesc)) {
            listForRuleType.add(ruleDesc);
        }
    }

    public void addRule(String categoryKey, Rule ruleToAdd) {
        this.allRulesUnderThisCategory.add(ruleToAdd.getRuleDescription());
        if (categoryKey.equals(this.categoryKey)) {
            EnumSet<RuleType> ruleType = ruleToAdd.getRuleTypes();
            String desc = ruleToAdd.getRuleDescription();
            String id = ruleToAdd.getRuleName();
            String ruleIdentifier = String.valueOf(desc) + "=" + id;
            if (ruleType.contains((Object)RuleType.FileRule)) {
                this.addRuleByType(ruleIdentifier, "file");
            }
            if (ruleType.contains((Object)RuleType.JavaRule)) {
                this.addRuleByType(ruleIdentifier, "java");
            }
            if (ruleType.contains((Object)RuleType.JspRule)) {
                this.addRuleByType(ruleIdentifier, "jsp");
            }
            if (ruleType.contains((Object)RuleType.ManifestRule)) {
                this.addRuleByType(ruleIdentifier, "mf");
            }
            if (ruleType.contains((Object)RuleType.PropertyRule)) {
                this.addRuleByType(ruleIdentifier, "property");
            }
            if (ruleType.contains((Object)RuleType.XmlRule)) {
                this.addRuleByType(ruleIdentifier, "xml");
            }
        } else {
            RuleCategory subCategory = this.subCategories.get(categoryKey);
            if (subCategory == null) {
                subCategory = this.addSubCategory(categoryKey);
            }
            subCategory.addRule(categoryKey, ruleToAdd);
        }
    }

    public Set<String> getAllRulesUnderThisCategory() {
        return this.allRulesUnderThisCategory;
    }

    public String getCategoryDescription() {
        return this.categoryDescription;
    }

    public boolean containsSubCategories() {
        return !this.subCategories.isEmpty();
    }

    public Set<String> getSubCategoryKeys() {
        return this.subCategories.keySet();
    }

    public RuleCategory getSubCategory(String key) {
        return this.subCategories.get(key);
    }

    public List<String> getSortedRulesByType(String ruleType) {
        List<String> listForRuleType = this.ruleDescriptionsByType.get(ruleType);
        if (listForRuleType != null) {
            Collections.sort(listForRuleType);
        }
        return listForRuleType;
    }

    public Map<String, List<String>> getSortedRulesByType() {
        HashMap<String, List<String>> sortedRules = new HashMap<String, List<String>>();
        this.addSortedRulesForType("file", sortedRules);
        this.addSortedRulesForType("java", sortedRules);
        this.addSortedRulesForType("jsp", sortedRules);
        this.addSortedRulesForType("mf", sortedRules);
        this.addSortedRulesForType("property", sortedRules);
        this.addSortedRulesForType("xml", sortedRules);
        return sortedRules;
    }

    private void addSortedRulesForType(String ruleType, Map<String, List<String>> sortedRules) {
        List<String> rulesForType = this.getSortedRulesByType(ruleType);
        if (rulesForType != null && !rulesForType.isEmpty()) {
            sortedRules.put(ruleType, rulesForType);
        }
    }
}

