/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.utilities;

import com.ibm.ws.report.binary.Messages;
import com.ibm.ws.report.binary.ReportInputData;
import com.ibm.ws.report.utilities.FileHelper;
import com.ibm.ws.report.utilities.ReportUtility;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DataCollectionHelper {
    private static final List<String> TWAS_SYSTEM_APP = new ArrayList<String>();
    private static final String APP_INSTALL_ROOT = "$(APP_INSTALL_ROOT)";
    public static final String WAS_SYSTEM_APP_INSTALL_PATH = "(WAS_INSTALL_ROOT)/systemApps";
    public static final String WAS_SYSTEM_APP_INSTALL_PATH2 = "{WAS_INSTALL_ROOT}/systemApps";

    static {
        TWAS_SYSTEM_APP.add("commsvc.ear");
        TWAS_SYSTEM_APP.add("isclite.ear");
        TWAS_SYSTEM_APP.add("adminconsole.ear");
        TWAS_SYSTEM_APP.add("IBMUTC.ear");
        TWAS_SYSTEM_APP.add("filetransfer.ear");
        TWAS_SYSTEM_APP.add("WebSphereWSDM.ear");
        TWAS_SYSTEM_APP.add("ibmasyncrsp.ear");
        TWAS_SYSTEM_APP.add("LongRunningScheduler.ear");
        TWAS_SYSTEM_APP.add("PGCController.ear");
        TWAS_SYSTEM_APP.add("PGCProxyController.ear");
        TWAS_SYSTEM_APP.add("OTiS.ear");
        TWAS_SYSTEM_APP.add("SwaggerUI.ear");
    }

    private DataCollectionHelper() {
    }

    public static ReportInputData.AppServer getTWASTarget(ReportInputData.AppServer sourceAppServer, ReportInputData.AppServer targetAppServer) {
        if (targetAppServer == null) {
            int wasMajorVersion;
            String sourceServerVersion = sourceAppServer.toString().toLowerCase();
            targetAppServer = ReportInputData.AppServer.WAS90;
            if (sourceServerVersion != null && sourceServerVersion.startsWith("was") && (wasMajorVersion = Integer.parseInt(String.valueOf(sourceServerVersion.charAt(3)))) < 9) {
                targetAppServer = ReportInputData.AppServer.WAS855;
            }
        }
        return targetAppServer;
    }

    public static ReportInputData.JavaEEVersion getTargetJavaEE(ReportInputData.AppServer sourceAppServer, ReportInputData.AppServer targetAppServer) {
        Object targetJavaEE = targetAppServer.isWAS_Traditional() ? targetAppServer.getDefaultSourceJavaEE() : (targetAppServer == ReportInputData.AppServer.LIBERTY ? null : (targetAppServer == ReportInputData.AppServer.MANAGED_LIBERTY ? ReportInputData.JavaEEVersion.EE10 : ReportInputData.JavaEEVersion.EE7));
        return targetJavaEE;
    }

    public static ReportInputData.JavaVersion getTargetJava(ReportInputData.AppServer sourceAppServer, ReportInputData.AppServer targetAppServer, ReportInputData.JavaVersion sourceJava, ReportInputData.JavaVersion specifiedTargetJava) {
        ReportInputData.JavaVersion targetJava = targetAppServer == ReportInputData.AppServer.MANAGED_LIBERTY ? ReportInputData.JavaVersion.JAVA17 : (targetAppServer.isWAS_Traditional() && sourceJava.getTargetOption() != null && sourceJava.getVersionNumber() >= 8 ? sourceJava : specifiedTargetJava);
        return targetJava;
    }

    public static boolean isSystemApp(String appName) {
        return TWAS_SYSTEM_APP.contains(appName);
    }

    public static File getDeploymentXML(File appDir) {
        File deploymentsFolder = new File(appDir, "deployments");
        if (deploymentsFolder.exists()) {
            File[] deploymentFiles;
            File[] fileArray = deploymentFiles = deploymentsFolder.listFiles();
            int n = deploymentFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                File deploymentFile = new File(file, "deployment.xml");
                if (deploymentFile.exists()) {
                    return deploymentFile;
                }
                ++n2;
            }
        }
        return null;
    }

    public static String resolveInstallRoot(File applicationDirectory, String userInstallPath, String binaryUrl) {
        File binaryUrlFile = new File(binaryUrl);
        String cellName = applicationDirectory.getParentFile().getParentFile().getName();
        String resolvedPath = String.valueOf(userInstallPath) + "/installedApps/" + cellName + "/" + binaryUrlFile.getName();
        return resolvedPath;
    }

    public static int convertDirectoryToEar(File applicationDirectory, List<File> container, String profilePath, boolean stopOnMissingBinary, boolean runFromTaDc) {
        String tempAppPath;
        int returnCode;
        block25: {
            returnCode = 0;
            String binaryURL = null;
            tempAppPath = null;
            File deploymentFile = DataCollectionHelper.getDeploymentXML(applicationDirectory);
            if (deploymentFile != null) {
                Document doc = null;
                try {
                    FileInputStream xmlFile = new FileInputStream(deploymentFile);
                    doc = FileHelper.getParsedDocument(xmlFile);
                    if (doc != null) {
                        doc.getDocumentElement().normalize();
                        NodeList doList = doc.getElementsByTagName("deployedObject");
                        int i = 0;
                        while (i < doList.getLength()) {
                            Node doNode = doList.item(i);
                            if (1 == doNode.getNodeType() && ((binaryURL = ((Element)doNode).getAttribute("binariesURL")).indexOf(WAS_SYSTEM_APP_INSTALL_PATH) > 0 || binaryURL.indexOf(WAS_SYSTEM_APP_INSTALL_PATH2) > 0)) {
                                binaryURL = null;
                                return returnCode;
                            }
                            ++i;
                        }
                        if (binaryURL != null) {
                            String tmpDir;
                            String appName = applicationDirectory.getName();
                            if (binaryURL.indexOf(APP_INSTALL_ROOT) >= 0) {
                                binaryURL = DataCollectionHelper.resolveInstallRoot(applicationDirectory, profilePath, binaryURL);
                            }
                            if (!(tmpDir = System.getProperty("java.io.tmpdir")).endsWith(File.separator)) {
                                tmpDir = String.valueOf(tmpDir) + File.separator;
                            }
                            tempAppPath = String.valueOf(tmpDir) + appName;
                            String[] arguments = System.getProperty("os.name").contains("windows") || System.getProperty("os.name").contains("Windows") ? new String[]{String.valueOf(profilePath) + "\\bin\\EARExpander.bat", "-ear", tempAppPath, "-operation", "collapse", "-operationDir", binaryURL, "-verbose"} : new String[]{String.valueOf(profilePath) + "/bin/EARExpander.sh", "-ear", tempAppPath, "-operation", "collapse", "-operationDir", binaryURL, "-verbose"};
                            Runtime rt = Runtime.getRuntime();
                            Process proc = rt.exec(arguments);
                            BufferedReader stdInput = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                            BufferedReader stdError = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                            StringBuilder outputSB = new StringBuilder();
                            String s = null;
                            while ((s = stdInput.readLine()) != null) {
                                outputSB.append(s);
                            }
                            StringBuilder errorSB = new StringBuilder();
                            while ((s = stdError.readLine()) != null) {
                                errorSB.append(s);
                            }
                            if (!errorSB.toString().isEmpty()) {
                                ReportUtility.logger.get().log(Level.FINE, "The following errors were present when creating an archive for the expended app:\n" + errorSB.toString());
                            }
                            String successMessageID = "ADMA4007I";
                            if (!outputSB.toString().contains(successMessageID)) {
                                tempAppPath = null;
                                if (stopOnMissingBinary) {
                                    String message = "";
                                    message = runFromTaDc ? Messages.getFormattedMessage(Messages.getString("Missing_Binary_BinariesURL_Error_TA"), applicationDirectory.getAbsolutePath(), binaryURL) : Messages.getFormattedMessage(Messages.getString("Missing_Binary_BinariesURL_Error"), applicationDirectory.getAbsolutePath(), binaryURL);
                                    System.out.println("SEVERE: " + message);
                                }
                            }
                        } else if (stopOnMissingBinary) {
                            String message = "";
                            message = runFromTaDc ? Messages.getFormattedMessage(Messages.getString("Missing_Binary_Deployment_xml_Error_TA"), applicationDirectory.getAbsolutePath()) : Messages.getFormattedMessage(Messages.getString("Missing_Binary_Deployment_xml_Error"), applicationDirectory.getAbsolutePath());
                            System.out.println("SEVERE: " + message);
                        }
                    } else if (stopOnMissingBinary) {
                        String message = "";
                        message = runFromTaDc ? Messages.getFormattedMessage(Messages.getString("Missing_Binary_Deployment_xml_Error_TA"), applicationDirectory.getAbsolutePath()) : Messages.getFormattedMessage(Messages.getString("Missing_Binary_Deployment_xml_Error"), applicationDirectory.getAbsolutePath());
                        System.out.println("SEVERE: " + message);
                    }
                }
                catch (Exception exception) {
                    tempAppPath = null;
                    if (!stopOnMissingBinary) break block25;
                    if (binaryURL == null) {
                        String message = "";
                        message = runFromTaDc ? Messages.getFormattedMessage(Messages.getString("Missing_Binary_Deployment_xml_Error_TA"), applicationDirectory.getAbsolutePath()) : Messages.getFormattedMessage(Messages.getString("Missing_Binary_Deployment_xml_Error"), applicationDirectory.getAbsolutePath());
                        System.out.println("SEVERE: " + message);
                        break block25;
                    }
                    String message = "";
                    message = runFromTaDc ? Messages.getFormattedMessage(Messages.getString("Missing_Binary_BinariesURL_Error_TA"), applicationDirectory.getAbsolutePath(), binaryURL) : Messages.getFormattedMessage(Messages.getString("Missing_Binary_BinariesURL_Error"), applicationDirectory.getAbsolutePath(), binaryURL);
                    System.out.println("SEVERE: " + message);
                }
            } else if (stopOnMissingBinary) {
                String message = "";
                message = runFromTaDc ? Messages.getFormattedMessage(Messages.getString("Missing_Binary_Deployment_xml_Error_TA"), applicationDirectory.getAbsolutePath()) : Messages.getFormattedMessage(Messages.getString("Missing_Binary_Deployment_xml_Error"), applicationDirectory.getAbsolutePath());
                System.out.println("SEVERE: " + message);
            }
        }
        if (tempAppPath != null) {
            container.add(new File(tempAppPath));
        } else if (!stopOnMissingBinary) {
            ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("Missing_Binary_Skipped"), applicationDirectory.getAbsolutePath()));
        } else {
            returnCode = 3;
        }
        return returnCode;
    }
}

