/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom.inventory;

import com.ibm.ws.report.binary.asm.utilities.ClassDataStore;
import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectClass;
import com.ibm.ws.report.binary.rules.DetectElement;
import com.ibm.ws.report.binary.rules.DetectFile;
import com.ibm.ws.report.binary.rules.DetectPackage;
import com.ibm.ws.report.binary.rules.RuleType;
import com.ibm.ws.report.binary.utilities.XMLResource;
import com.ibm.ws.report.technology.DetailResult;
import com.ibm.ws.report.utilities.ReportUtility;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CountJAXRPCProviders
extends DetectClass {
    protected static final EnumSet<RuleType> ruleType = EnumSet.of(RuleType.XmlRule, RuleType.JavaRule);
    protected static final String RULE_DESC = "com.ibm.ws.report.binary.java.jaxrpcProviders";
    protected DetectClass _webServiceImplement = null;
    protected static final String[] webServiceExtendClassNames = new String[]{"java.rmi.Remote"};
    protected static final String[] webServiceImplementClassNames = new String[]{"javax.ejb.SessionBean"};
    protected DetectClass _stubDetectClass = null;
    protected static final String[] stubExtendClassNames = new String[]{"com.ibm.ws.webservices.engine.client.Stub"};
    DetectElement _detectJaxRpcMapping = null;
    protected static final String[] jaxrpcMappingsTag = new String[]{"jaxrpc-mapping-file"};
    protected static final String[] jaxrpcMappingFileName = new String[]{"(.*/)?(META-INF|WEB-INF)/webservices\\.xml"};
    DetectElement _detectEjbJarElements = null;
    protected static final String[] ejbJarMappingsTag = new String[]{"service-endpoint"};
    protected static final String[] ejbJarFileName = new String[]{"(.*/)?(META-INF)/ejb-jar\\.xml"};
    protected static final Pattern[] ejbJarFileNamePattern = new Pattern[]{Pattern.compile(ejbJarFileName[0])};
    protected static final Pattern EJB_CLASS_TAG = Pattern.compile("ejb\\-class");
    protected DetectFile _ejbJarFiles = null;
    protected DetectPackage _detectJaxrpcPackages = null;
    protected static final String[] jaxrpcPackage = new String[]{"javax.xml.rpc*"};
    protected DetectPackage _detectWebservicesPackages = null;
    protected static final String[] webservicesPackage = new String[]{"com.ibm.ws.webservices*"};
    protected static final String[] allFiles = new String[]{jaxrpcMappingFileName[0], ejbJarFileName[0]};
    protected Set<String> interfaceNamesExtendRemote = new HashSet<String>();
    protected Set<String> classNamesImplementSessionBean = new HashSet<String>();
    protected Set<String> stubClassNames = new HashSet<String>();
    protected Map<String, DetailResult> classNamesFromEjbjarToResult = new HashMap<String, DetailResult>();
    protected Map<String, List<String>> interfacesImplementedToClasses = new HashMap<String, List<String>>();
    protected Map<String, String> fileToClassName = new HashMap<String, String>();

    public CountJAXRPCProviders() {
        this("CountJAXRPCProviders", RULE_DESC, null, false, false, false, webServiceExtendClassNames, null, null, null, null, null);
    }

    public CountJAXRPCProviders(String ruleName, String desc, String[] classNames, boolean useAppProvidedLibraries, boolean skipScanForUsage, boolean flagOnce, String[] extendsClass, String[] implementsClass, String[] missingMethods, String[] missingMethodArgs, String[] implementsMethods, String[] implementsMethodArgs) {
        super(ruleName, desc, null, false, false, false, extendsClass, null, null, null, null, null);
        this._detectJaxrpcPackages = new DetectPackage(ruleName, desc, jaxrpcPackage, true, false, null, null, flagOnce);
        this._detectWebservicesPackages = new DetectPackage(ruleName, desc, webservicesPackage, false, false, null, null, true);
        this._ejbJarFiles = new DetectFile(ruleName, desc, ejbJarFileNamePattern, false);
        this._webServiceImplement = new DetectClass(ruleName, desc, null, false, false, false, null, webServiceImplementClassNames, null, null, null, null){

            @Override
            protected boolean includeInResults(ClassDataStore data, String filename) {
                boolean shouldScan = ReportUtility.shouldScanClassFileForRules(filename);
                if (shouldScan) {
                    CountJAXRPCProviders.this.classNamesImplementSessionBean.add(data.getClassName());
                }
                return false;
            }
        };
        this._detectJaxRpcMapping = new DetectElement("CountJAXRPCProviders", RULE_DESC, jaxrpcMappingsTag, jaxrpcMappingFileName, null, null, false, null, null, null, false, null, null, null, false, null, false);
        this._stubDetectClass = new DetectClass(ruleName, desc, null, false, false, false, stubExtendClassNames, null, null, null, null, null){

            @Override
            protected boolean includeInResults(ClassDataStore data, String filename) {
                boolean shouldScan = ReportUtility.shouldScanClassFileForRules(filename);
                if (shouldScan) {
                    CountJAXRPCProviders.this.stubClassNames.add(data.getClassName());
                }
                return false;
            }
        };
        this._detectEjbJarElements = new DetectElement("CountJAXRPCProviders", RULE_DESC, ejbJarMappingsTag, ejbJarFileName, null, null, false, null, null, null, false, null, null, null, false, null, false){

            @Override
            protected boolean includeInResults(Node node, String fileName, XMLResource resource) {
                NodeList nodes = node.getParentNode().getChildNodes();
                int i = 0;
                while (i < nodes.getLength()) {
                    String siblingNodeName;
                    Node siblingNode = nodes.item(i);
                    if (siblingNode != null && EJB_CLASS_TAG.matcher(siblingNodeName = siblingNode.getNodeName()).matches()) {
                        CountJAXRPCProviders.this.classNamesFromEjbjarToResult.put(siblingNode.getTextContent(), new DetailResult(this.ruleName, fileName, this.ruleDescription, String.valueOf(siblingNodeName) + ", " + node.getNodeName()));
                    }
                    ++i;
                }
                return false;
            }
        };
    }

    @Override
    public void clearResults() {
        super.clearResults();
        this._detectJaxRpcMapping.clearResults();
        this._webServiceImplement.clearResults();
        this._detectEjbJarElements.clearResults();
        this._stubDetectClass.clearResults();
        this._ejbJarFiles.clearResults();
        this._detectJaxrpcPackages.clearResults();
        this._detectWebservicesPackages.clearResults();
        this.interfaceNamesExtendRemote.clear();
        this.classNamesImplementSessionBean.clear();
        this.stubClassNames.clear();
        this.classNamesFromEjbjarToResult.clear();
        this.interfacesImplementedToClasses.clear();
        this.fileToClassName.clear();
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        super.analyze(store, detectOnce);
        this._detectJaxRpcMapping.analyze(store, detectOnce);
        this._webServiceImplement.analyze(store, detectOnce);
        this._detectEjbJarElements.analyze(store, detectOnce);
        this._stubDetectClass.analyze(store, detectOnce);
        this._detectJaxrpcPackages.analyze(store, detectOnce);
        this._detectWebservicesPackages.analyze(store, detectOnce);
        Set<String> keys = store.getClassDataStoreKeys();
        for (String key : keys) {
            ClassDataStore data;
            String[] implementedInterfacesArr;
            boolean shouldScan = ReportUtility.shouldScanClassFileForRules(key);
            if (!shouldScan || (implementedInterfacesArr = (data = store.getClassDataStore(key)).getImplementedInterfaces()) == null) continue;
            String[] stringArray = implementedInterfacesArr;
            int n = implementedInterfacesArr.length;
            int n2 = 0;
            while (n2 < n) {
                String implInterFace = stringArray[n2];
                List<String> classList = this.interfacesImplementedToClasses.get(implInterFace);
                if (classList != null) {
                    classList.add(key);
                    this.fileToClassName.put(key, data.getClassName());
                } else {
                    ArrayList<String> newClassList = new ArrayList<String>();
                    newClassList.add(key);
                    this.fileToClassName.put(key, data.getClassName());
                    this.interfacesImplementedToClasses.put(implInterFace, newClassList);
                }
                ++n2;
            }
        }
    }

    @Override
    public EnumSet<RuleType> getRuleTypes() {
        return ruleType;
    }

    @Override
    public String[] getFileNames() {
        return allFiles;
    }

    @Override
    protected boolean includeInResults(ClassDataStore data, String filename) {
        this.interfaceNamesExtendRemote.add(data.getClassName());
        return false;
    }

    @Override
    public List<DetailResult> getResults(SimpleDataStore store) {
        ArrayList<DetailResult> finalResults = new ArrayList<DetailResult>();
        ArrayList<DetailResult> ejbClassResults = new ArrayList<DetailResult>();
        ArrayList<DetailResult> implementsResults = new ArrayList<DetailResult>();
        List<DetailResult> jaxRpcResults = this._detectJaxRpcMapping.getResults(store);
        if ((this._detectJaxrpcPackages.getResults(store).size() > 0 || this._webServiceImplement.getResults(store).size() > 0 || super.getResults(store).size() > 0 || this._detectWebservicesPackages.getResults(store).size() > 0) && jaxRpcResults != null && jaxRpcResults.size() > 0) {
            ReportUtility.logger.get().log(Level.FINE, "CountJAXRPCProviders: 1. jaxrpc-mapping-file tag in the webservices.xml results:\n" + jaxRpcResults.toString());
            finalResults.addAll(jaxRpcResults);
        }
        this._ejbJarFiles.analyze(store, false);
        List<DetailResult> resultsForEjbJarFiles = this._ejbJarFiles.getResults(store);
        HashSet<String> ejbJarArchives = new HashSet<String>();
        for (DetailResult nextEjbJar : resultsForEjbJarFiles) {
            String fileName = ReportUtility.getLastArchiveFileName(nextEjbJar.getFileName());
            if (!fileName.endsWith(".jar")) continue;
            ejbJarArchives.add(fileName);
        }
        ReportUtility.logger.get().log(Level.FINE, "CountJAXRPCProviders - EJB Archives Found: " + ((Object)ejbJarArchives).toString());
        for (String interfaceName : this.interfaceNamesExtendRemote) {
            List<String> providerList = this.interfacesImplementedToClasses.get(interfaceName);
            if (providerList != null) {
                ReportUtility.logger.get().log(Level.FINE, "CountJAXRPCProviders - Classes implementing interface " + interfaceName + " that extends java.rmi.Remote: " + providerList.toString());
            }
            if (providerList == null) continue;
            for (String provider : providerList) {
                String className = this.fileToClassName.get(provider);
                String lastArchiveName = ReportUtility.getLastArchiveFileName(provider);
                String archiveBeforeLastArchive = ReportUtility.getLastPreviousArchivePath(lastArchiveName);
                if (this.stubClassNames.contains(className)) continue;
                if (archiveBeforeLastArchive != null && this.archiveEndsWithArchiveFiletype(archiveBeforeLastArchive)) {
                    if (archiveBeforeLastArchive.endsWith(".ear") && (lastArchiveName.endsWith(".jar") && ejbJarArchives.contains(lastArchiveName) || lastArchiveName.endsWith(".war"))) {
                        ejbClassResults.add(new DetailResult(this.ruleName, provider, this.ruleDescription, className));
                        continue;
                    }
                    ReportUtility.logger.get().log(Level.FINE, "CountJAXRPCProviders - provider was not in war or ejb jar: " + provider);
                    continue;
                }
                if (lastArchiveName == null) continue;
                if (lastArchiveName.endsWith(".jar") && ejbJarArchives.contains(lastArchiveName) || lastArchiveName.endsWith(".war")) {
                    ejbClassResults.add(new DetailResult(this.ruleName, provider, this.ruleDescription, className));
                    continue;
                }
                ReportUtility.logger.get().log(Level.FINE, "CountJAXRPCProviders - provider was not in ejb jar: " + provider);
            }
        }
        if (ejbClassResults != null && ejbClassResults.size() > 0) {
            ReportUtility.logger.get().log(Level.FINE, "CountJAXRPCProviders: 2. All classes that implement an interface that extends java.rmi.Remote that isn't a Stub class results:\n" + ((Object)ejbClassResults).toString());
            finalResults.addAll(ejbClassResults);
        }
        for (String className : this.classNamesImplementSessionBean) {
            DetailResult dr = this.classNamesFromEjbjarToResult.get(className);
            if (dr != null) {
                implementsResults.add(dr);
                continue;
            }
            ReportUtility.logger.get().log(Level.FINE, "CountJAXRPCProviders - no ejb result found for class : " + className + " that implements javax.ejb.SessionBean");
        }
        if (implementsResults != null && implementsResults.size() > 0) {
            ReportUtility.logger.get().log(Level.FINE, "CountJAXRPCProviders: 3. All classes found in the ejb-class tag with a service-endpoint tag under the same session parent in the ejb-jar.xml that implement's javax.ejb.SessionBean results:\n" + ((Object)implementsResults).toString());
            finalResults.addAll(implementsResults);
        }
        return finalResults;
    }

    boolean archiveEndsWithArchiveFiletype(String archive) {
        if (archive.endsWith(".ear")) {
            return true;
        }
        if (archive.endsWith(".war")) {
            return true;
        }
        return archive.endsWith(".jar");
    }
}

