/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom;

import com.ibm.ws.report.binary.asm.utilities.AnnotationDetails;
import com.ibm.ws.report.binary.asm.utilities.ClassDataStore;
import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectAnnotation;
import com.ibm.ws.report.binary.rules.DetectClass;
import com.ibm.ws.report.binary.rules.DetectElement;
import com.ibm.ws.report.binary.rules.RuleType;
import com.ibm.ws.report.binary.utilities.XMLResource;
import com.ibm.ws.report.technology.DetailResult;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Node;

public class ServletContextListenerBehaviorChange
extends DetectClass {
    protected static final EnumSet<RuleType> ruleType = EnumSet.of(RuleType.JavaRule, RuleType.XmlRule);
    protected static final String RULE_NAME = "ServletContextListenerBehaviorChange";
    protected static final String RULE_DESC = "appconversion.javaee7.servlet.ServletContextListenerBehaviorChange";
    protected static final String[] implementsClasses = new String[]{"javax.servlet.ServletContextListener"};
    protected static final String[] annoClassNames = new String[]{"javax.servlet.annotation.WebListener"};
    protected static final String[] tags = new String[]{"listener-class"};
    protected static final String[] fileNames = new String[]{"WEB-INF/web.xml", "META-INF/web-fragment.xml"};
    protected static final String namespace = "*";
    protected DetectAnnotation _detectWebListener = null;
    protected DetectElement _detectListenerDeclaration = null;
    protected Set<String> classesDeclaredinXml = new HashSet<String>();
    protected Set<String> servletContextListenerSatifiedByAnnoList = new HashSet<String>();
    protected Map<String, String> classesImplementingServletContextListenerMap = new HashMap<String, String>();

    public ServletContextListenerBehaviorChange() {
        this(RULE_NAME, RULE_DESC, null, false, false, false, null, implementsClasses, null, null, null, null);
    }

    public ServletContextListenerBehaviorChange(String ruleName, String desc, String[] classNames, boolean useAppProvidedLibraries, boolean skipScanForUsage, boolean flagOnce, String[] extendsClass, String[] implementsClass, String[] missingMethods, String[] missingMethodArgs, String[] implementsMethods, String[] implementsMethodArgs) {
        super(ruleName, desc, classNames, useAppProvidedLibraries, skipScanForUsage, flagOnce, extendsClass, implementsClass, missingMethods, missingMethodArgs, implementsMethods, implementsMethodArgs);
        this._detectWebListener = new DetectAnnotation(RULE_NAME, RULE_DESC, annoClassNames, null, null, null, null, null, false, "class", null, null){

            @Override
            protected boolean includeInResults(String key, ClassDataStore data, AnnotationDetails ad) {
                if (data.doesClassImplement("javax.servlet.ServletContextListener")) {
                    ServletContextListenerBehaviorChange.this.servletContextListenerSatifiedByAnnoList.add(key);
                }
                return false;
            }
        };
        this._detectListenerDeclaration = new DetectElement(RULE_NAME, RULE_DESC, tags, fileNames, null, namespace, false, null, null, null, false){

            @Override
            protected boolean includeInResults(Node result, String key, XMLResource resource) {
                String nodeValue;
                Node firstChild = result.getFirstChild();
                if (firstChild != null && (nodeValue = firstChild.getNodeValue()) != null) {
                    ServletContextListenerBehaviorChange.this.classesDeclaredinXml.add(nodeValue.trim());
                }
                return false;
            }
        };
    }

    @Override
    public String[] getAnnotations() {
        return annoClassNames;
    }

    @Override
    public EnumSet<RuleType> getRuleTypes() {
        return ruleType;
    }

    @Override
    public String[] getFileNames() {
        return fileNames;
    }

    @Override
    public void clearResults() {
        super.clearResults();
        this._detectWebListener.clearResults();
        this._detectListenerDeclaration.clearResults();
        this.classesDeclaredinXml.clear();
        this.servletContextListenerSatifiedByAnnoList.clear();
        this.classesImplementingServletContextListenerMap.clear();
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        super.analyze(store, detectOnce);
        this._detectWebListener.analyze(store, detectOnce);
        this._detectListenerDeclaration.analyze(store, detectOnce);
    }

    @Override
    public List<DetailResult> getResults(SimpleDataStore store) {
        List<DetailResult> parentResultsList = super.getResults(store);
        super.getClassNames();
        if (!parentResultsList.isEmpty()) {
            Iterator<DetailResult> it = parentResultsList.iterator();
            while (it.hasNext()) {
                DetailResult nextResult = it.next();
                String fileName = nextResult.getFileName();
                if (!this.servletContextListenerSatifiedByAnnoList.contains(fileName) && !this.classesDeclaredinXml.contains(this.classesImplementingServletContextListenerMap.get(fileName))) continue;
                it.remove();
            }
        }
        return parentResultsList;
    }

    @Override
    protected boolean flagImplementsClass(ClassDataStore data, String fileName, boolean detectOnce) {
        if (super.flagImplementsClass(data, fileName, detectOnce)) {
            this.classesImplementingServletContextListenerMap.put(fileName, data.getClassName());
            return true;
        }
        return false;
    }
}

