/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom;

import com.ibm.ws.report.binary.asm.utilities.AnnotationDetails;
import com.ibm.ws.report.binary.asm.utilities.ClassDataStore;
import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectAnnotation;
import com.ibm.ws.report.binary.rules.DetectElement;
import com.ibm.ws.report.binary.rules.RuleType;
import com.ibm.ws.report.binary.utilities.XMLResource;
import com.ibm.ws.report.binary.utilities.XMLRuleUtil;
import com.ibm.ws.report.technology.DetailResult;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ProducerFieldsSessionBeans
extends DetectAnnotation {
    protected static final EnumSet<RuleType> ruleType = EnumSet.of(RuleType.JavaRule, RuleType.XmlRule);
    protected static final String RULE_NAME = "ProducerFieldsSessionBeans";
    protected static final String RULE_DESC = "appconversion.javaee7.cdi.ProducerFieldsSessionBeans";
    protected static final String STATEFUL_ANNO = "javax.ejb.Stateful";
    protected static final String STATELESS_ANNO = "javax.ejb.Stateless";
    protected static final String SINGLETON_ANNO = "javax.ejb.Singleton";
    protected static final String[] classNames = new String[]{"javax.enterprise.inject.Produces"};
    protected static final String[] tags = new String[]{"session"};
    protected static final String[] ejbJarFileName = new String[]{"(.*/)?(META-INF|WEB-INF)/ejb-jar\\.xml"};
    protected DetectElement _sessionElements = null;
    protected Set<String> _sessionBeanClassNames = new HashSet<String>();
    protected List<DetailResult> _fieldsToFlag = new ArrayList<DetailResult>();
    protected Map<String, List<DetailResult>> _potentialFieldsToFlag = new HashMap<String, List<DetailResult>>();

    public ProducerFieldsSessionBeans() {
        this(RULE_NAME, RULE_DESC, classNames, null, null, null, null, null, false, "field", null, null);
    }

    public ProducerFieldsSessionBeans(String ruleName, String desc, String[] classNames, String attributeName, String attributeType, String[] attributeValues, String defaultValue, String accessFlag, boolean flagOnce, String location, String defaultName, String missingAttributeName) {
        super(ruleName, desc, classNames, attributeName, attributeType, attributeValues, defaultValue, accessFlag, flagOnce, location, defaultName, missingAttributeName);
        this._sessionElements = new DetectElement(ruleName, desc, tags, ejbJarFileName, null, null, false, null, null, null, false, null, null, null, false, null, false){

            @Override
            protected boolean includeInResults(Node node, String fileName, XMLResource resource) {
                String className = XMLRuleUtil.getFirstChildElementValue((Element)node, "*", "ejb-class");
                if (className != null) {
                    ProducerFieldsSessionBeans.this._sessionBeanClassNames.add(className);
                }
                return false;
            }
        };
    }

    @Override
    public EnumSet<RuleType> getRuleTypes() {
        return ruleType;
    }

    @Override
    public String[] getFileNames() {
        return ejbJarFileName;
    }

    @Override
    public void clearResults() {
        super.clearResults();
        this._sessionElements.clearResults();
        this._sessionBeanClassNames.clear();
        this._potentialFieldsToFlag.clear();
        this._fieldsToFlag = new ArrayList<DetailResult>();
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        super.analyze(store, detectOnce);
        this._sessionElements.analyze(store, detectOnce);
    }

    @Override
    public List<DetailResult> getResults(SimpleDataStore store) {
        if (!this._sessionBeanClassNames.isEmpty()) {
            for (String sessionBeanClassName : this._sessionBeanClassNames) {
                List<DetailResult> moreFieldsToFlag = this._potentialFieldsToFlag.get(sessionBeanClassName);
                if (moreFieldsToFlag == null) continue;
                this._fieldsToFlag.addAll(moreFieldsToFlag);
                this._potentialFieldsToFlag.remove(sessionBeanClassName);
            }
        }
        return this._fieldsToFlag;
    }

    @Override
    protected boolean includeInResults(String key, ClassDataStore data, AnnotationDetails ad) {
        String ref = ad.getReference();
        String fieldName = ref.substring(ref.lastIndexOf(32) + 1);
        if (!data.doesFieldHaveModifier(fieldName, 8)) {
            DetailResult result = new DetailResult(RULE_NAME, key, this.getRuleDescription(), classNames[0], 1, ad.getReference(), ad.getLineNumber());
            if (data.doesContainClassAnnotation(STATEFUL_ANNO) || data.doesContainClassAnnotation(STATELESS_ANNO) || data.doesContainClassAnnotation(SINGLETON_ANNO)) {
                this._fieldsToFlag.add(result);
            } else {
                String className = data.getClassName();
                if (this._potentialFieldsToFlag.containsKey(className)) {
                    List<DetailResult> results = this._potentialFieldsToFlag.get(className);
                    results.add(result);
                } else {
                    ArrayList<DetailResult> results = new ArrayList<DetailResult>();
                    results.add(result);
                    this._potentialFieldsToFlag.put(className, results);
                }
            }
        }
        return false;
    }
}

