/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom;

import com.ibm.ws.report.binary.Messages;
import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectFile;
import com.ibm.ws.report.binary.rules.DetectManifestAttribute;
import com.ibm.ws.report.binary.rules.DetectRule;
import com.ibm.ws.report.technology.DetailResult;
import com.ibm.ws.report.utilities.ReportUtility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class MigrateJBossManifestRule
extends DetectManifestAttribute {
    protected static final String RULE_NAME = "MigrateJBossManifestRule";
    protected static final String RULE_DESC = "com.ibm.ws.appconversion.weblogic.manifest.analysis.rule.label";
    protected static final String CLASS_PATH = "Class-Path";
    protected static final Pattern[] rootJarPattern = new Pattern[]{Pattern.compile(".*\\.ear/(?!.*[rw]ar/)(.*?\\.jar){1,1}")};
    protected static final Pattern earPathPattern = Pattern.compile(".*\\.ear/");
    protected static final Pattern warManifestFilePattern = Pattern.compile(".*\\.ear/.*\\.war/META-INF/MANIFEST.MF");
    DetectFile _detectJarFiles;
    Map<String, List<String>> mapOfEarsToRootJars = new HashMap<String, List<String>>();

    public MigrateJBossManifestRule() {
        this(RULE_NAME, RULE_DESC, CLASS_PATH, ".*", DetectRule.FlagOnce.NONE);
    }

    public MigrateJBossManifestRule(String ruleName, String desc, String name2, String value, DetectRule.FlagOnce flagOnceType) {
        super(ruleName, desc, name2, value, flagOnceType);
        this._detectJarFiles = new DetectFile(ruleName, desc, rootJarPattern, false){

            @Override
            public void analyze(SimpleDataStore store, boolean detectOnce) {
                int i = 0;
                while (i < this.files.length) {
                    Pattern pattern = this.files[i];
                    Set<String> matches = store.getMatchingFileNames(pattern);
                    for (String key : matches) {
                        String earName = ReportUtility.getFirstArchiveName(key);
                        List<String> rootJars = MigrateJBossManifestRule.this.mapOfEarsToRootJars.get(earName);
                        if (rootJars == null) {
                            rootJars = new ArrayList<String>();
                            MigrateJBossManifestRule.this.mapOfEarsToRootJars.put(earName, rootJars);
                        }
                        rootJars.add(earPathPattern.matcher(key).replaceFirst(""));
                    }
                    ++i;
                }
            }
        };
    }

    @Override
    public void clearResults() {
        super.clearResults();
        this._detectJarFiles.clearResults();
        this.mapOfEarsToRootJars.clear();
    }

    @Override
    public List<DetailResult> getResults(SimpleDataStore store) {
        this._detectJarFiles.analyze(store, false);
        ArrayList<DetailResult> finalResultsList = new ArrayList<DetailResult>();
        List<DetailResult> manifestResultsList = super.getResults(store);
        StringBuilder sb = new StringBuilder();
        for (DetailResult result : manifestResultsList) {
            String filePath = result.getFileName();
            if (!warManifestFilePattern.matcher(filePath).matches()) continue;
            String earName = ReportUtility.getFirstArchiveName(filePath);
            Set<String> setOfClassPathReferences = this.getClassPathFiles(result.getCriteria());
            for (String jarName : ReportUtility.nullGuard(this.mapOfEarsToRootJars.get(earName))) {
                if (setOfClassPathReferences.contains(jarName)) continue;
                sb.append(jarName).append("\n");
            }
            if (sb.length() == 0) continue;
            result.setCriteria(Messages.getFormattedMessage(Messages.getString("Report_Criteria_Missing_Class_Path"), sb.toString().trim()));
            finalResultsList.add(result);
            sb.setLength(0);
        }
        return finalResultsList;
    }

    public Set<String> getClassPathFiles(String classPath) {
        int indexOfEquals = classPath.indexOf(61);
        String classPathValue = classPath.substring(indexOfEquals).trim();
        return new HashSet<String>(Arrays.asList(classPathValue.split("\\s+")));
    }
}

