/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom;

import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectFile;
import com.ibm.ws.report.binary.rules.DetectPackage;
import com.ibm.ws.report.binary.rules.RuleType;
import com.ibm.ws.report.technology.DetailResult;
import com.ibm.ws.report.utilities.ReportUtility;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public class JaxBUsedJaxPProvided
extends DetectPackage {
    protected static final EnumSet<RuleType> ruleType = EnumSet.of(RuleType.JavaRule);
    protected static final String RULE_NAME = "JaxBUsedJaxPProvided";
    protected static final String RULE_DESC = "com.ibm.ws.appconversion.JaxBUsedJaxPProvided";
    protected static final Pattern[] implementations = new Pattern[]{Pattern.compile(".*/javax/xml/datatype/.*\\.class")};
    protected static final String[] jaxbPackage = new String[]{"javax.xml.bind*"};
    protected DetectFile jaxPPackages = null;
    protected Set<String> providedJaxPLibraries = new HashSet<String>();

    @Override
    public EnumSet<RuleType> getRuleTypes() {
        return ruleType;
    }

    public JaxBUsedJaxPProvided() {
        this(RULE_NAME, RULE_DESC, jaxbPackage, true, false, null, null, true);
    }

    public JaxBUsedJaxPProvided(String ruleName, String desc, String[] packageNames, boolean useAppProvidedLibraries, boolean skipScanForUsage, String[] excludeClassNames, String[] excludePackageNames, boolean flagOnce) {
        super(ruleName, desc, packageNames, useAppProvidedLibraries, skipScanForUsage, excludeClassNames, excludePackageNames, flagOnce);
        this.jaxPPackages = new DetectFile(RULE_NAME, RULE_DESC, implementations, false){

            @Override
            public void analyze(SimpleDataStore store, boolean detectOnce) {
                JaxBUsedJaxPProvided.this.providedJaxPLibraries = JaxBUsedJaxPProvided.this.filterClasses(store.getMatchingFileNames(implementations[0]));
            }
        };
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        super.analyze(store, detectOnce);
    }

    Set<String> filterClasses(Set<String> classes) {
        Pattern matchClassName = Pattern.compile("/[^/]+\\.class");
        HashSet<String> packages = new HashSet<String>();
        for (String clazz : classes) {
            packages.add(matchClassName.matcher(clazz).replaceFirst(""));
        }
        return packages;
    }

    @Override
    public void clearResults() {
        super.clearResults();
        this.jaxPPackages.clearResults();
        this.providedJaxPLibraries.clear();
    }

    @Override
    public List<DetailResult> getResults(SimpleDataStore store) {
        ArrayList<DetailResult> finalResults = new ArrayList<DetailResult>();
        List<DetailResult> jaxbResults = super.getResults(store);
        this.jaxPPackages.analyze(store, false);
        if (!this.providedJaxPLibraries.isEmpty() && !jaxbResults.isEmpty()) {
            for (String lib : this.providedJaxPLibraries) {
                finalResults.add(new DetailResult(this.ruleName, ReportUtility.getLastArchiveFileName(lib), this.ruleDescription, implementations[0].pattern()));
            }
        }
        return finalResults;
    }
}

