/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom;

import com.ibm.ws.report.binary.asm.utilities.AnnotationDetails;
import com.ibm.ws.report.binary.asm.utilities.ClassDataStore;
import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectAnnotation;
import com.ibm.ws.report.binary.rules.DetectClass;
import com.ibm.ws.report.technology.DetailResult;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class JakartaApplicationSubclassRequiresAnnotation
extends DetectClass {
    protected static final String RULE_NAME = "JakartaApplicationSubclassRequiresAnnotation";
    protected static final String RULE_DESC = "com.ibm.ws.report.binary.jakartaee9.restfulws.DetectApplicationSubclassWithoutAnnotation";
    protected static final String[] extendsClasses = new String[]{"javax.ws.rs.core.Application", "jakarta.ws.rs.core.Application"};
    protected static final String[] annoForApplicationPath = new String[]{"javax.ws.rs.ApplicationPath", "jakarta.ws.rs.ApplicationPath"};
    protected static final String[] annoToFlag = new String[]{"javax.inject.Inject", "jakarta.inject.Inject"};
    protected static final String[] allAnnotations = new String[]{annoForApplicationPath[0], annoForApplicationPath[1], annoToFlag[0], annoToFlag[1]};
    protected DetectAnnotation _detectApplicationPath = null;
    protected DetectAnnotation _detectCdiAnnotations = null;
    protected Set<String> applicationSubclassHasAnnotation = new HashSet<String>();
    protected Set<String> classesWithCdiInjection = new HashSet<String>();

    public JakartaApplicationSubclassRequiresAnnotation() {
        this(RULE_NAME, RULE_DESC, null, false, false, false, extendsClasses, null, null, null, null, null);
    }

    public JakartaApplicationSubclassRequiresAnnotation(String ruleName, String desc, String[] classNames, boolean useAppProvidedLibraries, boolean skipScanForUsage, boolean flagOnce, String[] extendsClass, String[] implementsClass, String[] missingMethods, String[] missingMethodArgs, String[] implementsMethods, String[] implementsMethodArgs) {
        super(ruleName, desc, classNames, useAppProvidedLibraries, skipScanForUsage, flagOnce, extendsClass, implementsClass, missingMethods, missingMethodArgs, implementsMethods, implementsMethodArgs);
        this._detectApplicationPath = new DetectAnnotation(RULE_NAME, RULE_DESC, annoForApplicationPath, null, null, null, null, null, false, "class", null, null){

            @Override
            protected boolean includeInResults(String key, ClassDataStore data, AnnotationDetails ad) {
                if (data.doesClassExtend(extendsClasses[0]) || data.doesClassExtend(extendsClasses[1])) {
                    JakartaApplicationSubclassRequiresAnnotation.this.applicationSubclassHasAnnotation.add(key);
                }
                return false;
            }
        };
        this._detectCdiAnnotations = new DetectAnnotation(RULE_NAME, RULE_DESC, annoToFlag, null, null, null, null, null, false, null, null, null){

            @Override
            protected boolean includeInResults(String key, ClassDataStore data, AnnotationDetails ad) {
                if (data.doesClassExtend(extendsClasses[0]) || data.doesClassExtend(extendsClasses[1])) {
                    JakartaApplicationSubclassRequiresAnnotation.this.classesWithCdiInjection.add(key);
                }
                return false;
            }
        };
    }

    @Override
    public String[] getAnnotations() {
        return allAnnotations;
    }

    @Override
    public void clearResults() {
        super.clearResults();
        this._detectApplicationPath.clearResults();
        this._detectCdiAnnotations.clearResults();
        this.applicationSubclassHasAnnotation.clear();
        this.classesWithCdiInjection.clear();
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        super.analyze(store, detectOnce);
        this._detectApplicationPath.analyze(store, detectOnce);
        this._detectCdiAnnotations.analyze(store, detectOnce);
    }

    @Override
    public List<DetailResult> getResults(SimpleDataStore store) {
        List<DetailResult> parentResultsList = super.getResults(store);
        if (!parentResultsList.isEmpty()) {
            Iterator<DetailResult> it = parentResultsList.iterator();
            while (it.hasNext()) {
                DetailResult nextResult = it.next();
                String fileName = nextResult.getFileName();
                if (!this.applicationSubclassHasAnnotation.contains(fileName) && this.classesWithCdiInjection.contains(fileName)) continue;
                it.remove();
            }
        }
        return parentResultsList;
    }
}

