/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom;

import com.ibm.ws.report.binary.Messages;
import com.ibm.ws.report.binary.asm.utilities.ClassDataStore;
import com.ibm.ws.report.binary.asm.utilities.ClassOrPackageDetails;
import com.ibm.ws.report.binary.asm.utilities.ClassOrPackageOccurrence;
import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectRule;
import com.ibm.ws.report.binary.rules.RuleType;
import com.ibm.ws.report.technology.DetailResult;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DetectWildcardRecord
extends DetectRule {
    protected static EnumSet<RuleType> ruleType = EnumSet.of(RuleType.JavaRule);
    protected static final String RULE_NAME = "DetectWildcardRecord";
    protected static final String RULE_DESC = "appconversion.jre.14.DetectWildcardRecord";
    Set<String> appsUsingSessions = null;

    public DetectWildcardRecord() {
        super(RULE_NAME, RULE_DESC, false);
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        Set<String> keys = store.getClassDataStoreKeys();
        if (!keys.isEmpty()) {
            for (String key : keys) {
                ClassDataStore data = store.getClassDataStore(key);
                Set<String> packageNames = data.getPackageNames();
                for (String packageName : packageNames) {
                    ClassOrPackageDetails[] packageDetails;
                    if (!packageName.endsWith("*") || (packageDetails = data.getPackageDetails(packageName)) == null) continue;
                    ClassOrPackageDetails[] classOrPackageDetailsArray = packageDetails;
                    int n = packageDetails.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ClassOrPackageDetails detail = classOrPackageDetailsArray[n2];
                        String packagePrefix = detail.getClassOrPackageName();
                        Map<String, ClassOrPackageOccurrence> occurrenceMap = detail.getReferenceAndLineInfo();
                        for (Map.Entry<String, ClassOrPackageOccurrence> entry : occurrenceMap.entrySet()) {
                            List<String> classNames = entry.getValue().getLineNumberClassNames();
                            for (String className : classNames) {
                                if (!className.equals(String.valueOf(packagePrefix) + ".Record")) continue;
                                this.detailResults.add(new DetailResult(this.ruleName, Messages.getString(key), this.ruleDescription, className));
                                return;
                            }
                        }
                        ++n2;
                    }
                }
            }
        }
    }

    @Override
    public EnumSet<RuleType> getRuleTypes() {
        return ruleType;
    }
}

