/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom;

import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectFile;
import com.ibm.ws.report.binary.rules.DetectMethod;
import com.ibm.ws.report.technology.DetailResult;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;

public class DetectSqlDriver
extends DetectMethod {
    protected static final String RULE_NAME = "DetectSqlDriver";
    protected static final String RULE_DESC = "rules.java.SqlDriverRule";
    protected static final String[] _allMethodNames = new String[]{"connect", "getConnection", "getDriver"};
    protected static final String[] _methodNamesDriver = new String[]{_allMethodNames[0]};
    protected static final String[] _ownerDriver = new String[]{"java.sql.Driver"};
    protected static final String[] _methodNamesDriverManager = new String[]{_allMethodNames[1], _allMethodNames[2]};
    protected static final String[] _ownerDriverManager = new String[]{"java.sql.DriverManager"};
    protected static final Pattern[] JDBC_DRIVER_FILE = new Pattern[]{Pattern.compile(".*META-INF/services/java\\.sql\\.Driver")};
    protected DetectFile JDBCDriverFileRule = new DetectFile("DetectSqlDriver", "rules.java.SqlDriverRule", JDBC_DRIVER_FILE, false);
    protected DetectMethod DriverManagerRule = null;

    public DetectSqlDriver() {
        this(RULE_NAME, RULE_DESC);
    }

    public DetectSqlDriver(String ruleName, String desc) {
        super(ruleName, desc, _methodNamesDriver, _ownerDriver, null, null, null, false, null, null, null);
        this.DriverManagerRule = new DetectMethod(ruleName, desc, _methodNamesDriverManager, _ownerDriverManager, null, null, null, false, null, null, null);
    }

    @Override
    public String[] getMethodNames() {
        return _allMethodNames;
    }

    @Override
    public void clearResults() {
        super.clearResults();
        this.DriverManagerRule.clearResults();
        this.JDBCDriverFileRule.clearResults();
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        super.analyze(store, detectOnce);
        this.DriverManagerRule.analyze(store, false);
    }

    @Override
    public List<DetailResult> getResults(SimpleDataStore store) {
        String fileName;
        this.JDBCDriverFileRule.analyze(store, false);
        List<DetailResult> fileResults = this.JDBCDriverFileRule.getResults(store);
        List<DetailResult> driverResults = super.getResults(store);
        List<DetailResult> driverManagerResults = this.DriverManagerRule.getResults(store);
        ArrayList<DetailResult> finalResults = new ArrayList<DetailResult>();
        HashSet<String> jarNamesForJdbcDrivers = new HashSet<String>();
        for (DetailResult result : fileResults) {
            fileName = this.getJarFileName(result.getFileName());
            if (fileName == null) continue;
            jarNamesForJdbcDrivers.add(fileName);
        }
        for (DetailResult result : driverResults) {
            fileName = this.getJarFileName(result.getFileName());
            if (jarNamesForJdbcDrivers.contains(fileName)) continue;
            finalResults.add(result);
        }
        for (DetailResult result : driverManagerResults) {
            fileName = this.getJarFileName(result.getFileName());
            if (jarNamesForJdbcDrivers.contains(fileName)) continue;
            finalResults.add(result);
        }
        return finalResults;
    }

    protected String getJarFileName(String fileName) {
        String jarFileName = null;
        int index = fileName.lastIndexOf(".jar");
        if (index > -1) {
            jarFileName = fileName.substring(0, index + 4);
        }
        return jarFileName;
    }
}

