/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom;

import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectAttribute;
import com.ibm.ws.report.binary.rules.DetectElement;
import com.ibm.ws.report.binary.rules.DetectRule;
import com.ibm.ws.report.binary.rules.RuleType;
import com.ibm.ws.report.binary.utilities.XMLResource;
import com.ibm.ws.report.binary.utilities.XMLRuleUtil;
import com.ibm.ws.report.technology.DetailResult;
import java.util.EnumSet;
import java.util.List;
import org.w3c.dom.Node;

public class DetectJndiEnvironmentElements
extends DetectRule {
    protected static final EnumSet<RuleType> ruleType = EnumSet.of(RuleType.XmlRule);
    protected static final String RULE_NAME = "DetectJndiEnvironmentElements";
    protected static final String RULE_DESC = "appconversion.framework.spring.xml.jndiEnvironmentValues";
    protected static final String JNDI_LOOKUP_ELEMENT = "jndi-lookup";
    protected static final String ENVIRONMENT_ELEMENT = "environment";
    protected static final String JNDI_ENVIRONMENT_ATTRIBUTE_VALUE = "jndiEnvironment";
    protected static final DetectRule.FlagOnce flagOnceType = DetectRule.FlagOnce.NONE;
    protected static final DetectRule.XMLFileType xmlFileType = DetectRule.XMLFileType.SPRING;
    protected static final String[] xmlFiles = new String[]{".xml"};
    protected DetectElement _environmentElement = new DetectElement("DetectJndiEnvironmentElements", "appconversion.framework.spring.xml.jndiEnvironmentValues", "environment", xmlFiles, xmlFileType, null, false, null, flagOnceType, null, null, null, false){

        @Override
        protected boolean includeInResults(Node result, String key, XMLResource resource) {
            Node parentNode = XMLRuleUtil.getParentNode(result, "*", DetectJndiEnvironmentElements.JNDI_LOOKUP_ELEMENT);
            return parentNode != null;
        }
    };
    protected DetectAttribute _jndiEnvironmentAttribute = new DetectAttribute("DetectJndiEnvironmentElements", "appconversion.framework.spring.xml.jndiEnvironmentValues", new String[]{"property"}, xmlFiles, xmlFileType, null, "name", "jndiEnvironment", null, flagOnceType, false, null, null);

    public DetectJndiEnvironmentElements() {
        this(RULE_NAME, RULE_DESC, false);
    }

    public DetectJndiEnvironmentElements(String ruleName, String desc, boolean flagOnce) {
        super(ruleName, desc, flagOnce);
    }

    @Override
    public void clearResults() {
        super.clearResults();
        this._environmentElement.clearResults();
        this._jndiEnvironmentAttribute.clearResults();
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        this._environmentElement.analyze(store, detectOnce);
        this._jndiEnvironmentAttribute.analyze(store, detectOnce);
    }

    @Override
    public String[] getFileNames() {
        return xmlFiles;
    }

    @Override
    public EnumSet<RuleType> getRuleTypes() {
        return ruleType;
    }

    @Override
    public List<DetailResult> getResults(SimpleDataStore store) {
        this.detailResults.addAll(this._environmentElement.getResults(store));
        this.detailResults.addAll(this._jndiEnvironmentAttribute.getResults(store));
        return this.detailResults;
    }
}

