/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom;

import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectElement;
import com.ibm.ws.report.binary.utilities.XMLResource;
import com.ibm.ws.report.binary.utilities.XMLRuleUtil;
import com.ibm.ws.report.technology.DetailResult;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DetectJAXRPCFaults
extends DetectElement {
    protected static String RULE_NAME = "DetectJAXRPCFaults";
    protected static String RULE_DESC = "com.ibm.ws.report.binary.java.DetectJAXRPCFaults";
    protected static final String[] fileNames = new String[]{"WEB-INF/webservices.xml", "WEB-INF/web.xml", "META-INF/webservices.xml", "META-INF/web.xml"};
    protected static final String[] allXmlNames = new String[]{".xml"};
    protected static final String JAXRPC_MAPPING_FILE = "jaxrpc-mapping-file";
    protected static final String EXCEPTION_MAPPING = "exception-mapping";
    protected static final String[] tags = new String[]{"exception-mapping"};
    protected DetectElement _detectJaxrpcElement = null;
    protected Set<String> listOfMappingFiles = new HashSet<String>();

    public DetectJAXRPCFaults() {
        this(RULE_NAME, RULE_DESC, tags, allXmlNames, null, null, false, null, null, null, false);
    }

    public DetectJAXRPCFaults(String ruleName, String desc, String[] tags, String[] fileNames, String value, String namespace, boolean flagOnce, String docNamespace, String missingChildElement, String missingChildElementValue, boolean flagNotEmpty) {
        super(ruleName, desc, tags, fileNames, value, namespace, flagOnce, docNamespace, missingChildElement, missingChildElementValue, flagNotEmpty);
        this._detectJaxrpcElement = new DetectElement(ruleName, desc, JAXRPC_MAPPING_FILE, fileNames, null, null, false, null, null, null, false){

            @Override
            protected boolean includeInResults(Node node, String fileName, XMLResource resource) {
                Node parent = node.getParentNode();
                List<Element> children = XMLRuleUtil.getChildElements((Element)parent, "*", DetectJAXRPCFaults.JAXRPC_MAPPING_FILE);
                if (children != null && children.size() > 0) {
                    for (Element el : children) {
                        String value = XMLRuleUtil.getTextWithoutWhitespace(el);
                        if (value == null) continue;
                        DetectJAXRPCFaults.this.listOfMappingFiles.add(value);
                    }
                }
                return false;
            }
        };
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        super.analyze(store, detectOnce);
        this._detectJaxrpcElement.analyze(store, detectOnce);
    }

    @Override
    public List<DetailResult> getResults(SimpleDataStore store) {
        ArrayList<DetailResult> exceptionMappingResults = new ArrayList<DetailResult>();
        List<DetailResult> results = super.getResults(store);
        if (!results.isEmpty()) {
            String exceptionMappingFileName = "";
            for (DetailResult dr : results) {
                if (exceptionMappingFileName.equals(dr.getFileName())) continue;
                exceptionMappingFileName = dr.getFileName();
                for (String mappingFileName : this.listOfMappingFiles) {
                    if (!exceptionMappingFileName.endsWith(mappingFileName)) continue;
                    exceptionMappingResults.add(dr);
                }
            }
        }
        return exceptionMappingResults;
    }
}

