/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom;

import com.ibm.ws.report.binary.rules.DetectAttribute;
import com.ibm.ws.report.binary.rules.DetectRule;
import com.ibm.ws.report.binary.utilities.XMLRuleUtil;
import java.util.regex.Pattern;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public class DetectEntityInterceptor
extends DetectAttribute {
    protected static final String RULE_NAME = "DetectEntityInterceptor";
    protected static final String RULE_DESC = "appconversion.framework.spring.xml.DetectEntityInterceptor";
    protected static final String[] propertyTag = new String[]{"property"};
    protected static final String[] xmlFiles = new String[]{".xml"};
    protected static final String NAME_ATTRIBUTE = "name";
    protected static final String CLASS_ATTRIBUTE = "class";
    protected static final String ENTITY_INTERCEPTOR_ATTRIBUTE_VALUE = "entityInterceptor";
    protected static Pattern classesToFlagOnRegex = Pattern.compile("org\\.springframework\\.(transaction\\.jta\\.(JtaTransactionManager|WebSphereUowTransactionManager)|orm\\.hibernate3\\.HibernateTransactionManager)");

    public DetectEntityInterceptor() {
        this(RULE_NAME, RULE_DESC, propertyTag, xmlFiles, null, NAME_ATTRIBUTE, ENTITY_INTERCEPTOR_ATTRIBUTE_VALUE, null, DetectRule.FlagOnce.NONE, null, null);
    }

    public DetectEntityInterceptor(String ruleName, String desc, String[] tags, String[] fileNames, String namespace, String attributeName, String attributeValue, String attributeNamespace, DetectRule.FlagOnce flagOnceType, String validateNamespace, String documentNamespace) {
        super(ruleName, desc, tags, fileNames, namespace, attributeName, attributeValue, attributeNamespace, flagOnceType, validateNamespace, documentNamespace);
    }

    @Override
    protected boolean includeInResults(String fileName, Node node) {
        Node parent = ((Attr)node).getOwnerElement().getParentNode();
        String classAttrValue = XMLRuleUtil.getAttributeValue(parent.getAttributes(), "*", CLASS_ATTRIBUTE);
        return classAttrValue == null ? false : classesToFlagOnRegex.matcher(classAttrValue).matches();
    }
}

