/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom;

import com.ibm.ws.report.analyze.IdentifierObject;
import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectJNDI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DetectConfigJNDI
extends DetectJNDI {
    protected static final String RULE_NAME = "DetectConfigJNDI";
    protected static final String RULE_DESC = "DetectConfigJNDI";

    public DetectConfigJNDI() {
        super("DetectConfigJNDI", "DetectConfigJNDI");
        this.flagOnce = true;
    }

    @Override
    public void addResult(String fileName, String jndiName, String resourceType, String reference, int lineNumber, Set<String> foundIdentifierNamesForApp, IdentifierObject idObj, SimpleDataStore store) {
        List<String> rules = idObj.getRules();
        if (rules != null && !rules.isEmpty()) {
            store.setDetectedJNDINameWithConfigRule(true);
        }
        foundIdentifierNamesForApp.add(jndiName);
    }

    @Override
    public Map<String, IdentifierObject> getIdentifierObjectsForRule(Map<String, IdentifierObject> identifierNamesForApp, Set<String> foundIdentifierNamesPerApp) {
        HashMap<String, IdentifierObject> relatedIdentifierObjects = new HashMap<String, IdentifierObject>();
        for (IdentifierObject obj : identifierNamesForApp.values()) {
            String name2 = obj.getIdentifierName();
            if (foundIdentifierNamesPerApp.contains(name2)) continue;
            relatedIdentifierObjects.put(name2, obj);
        }
        return relatedIdentifierObjects;
    }
}

