/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom;

import com.ibm.ws.report.binary.Messages;
import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectAnnotation;
import com.ibm.ws.report.binary.rules.DetectFile;
import com.ibm.ws.report.binary.rules.DetectMethod;
import com.ibm.ws.report.binary.rules.RuleType;
import com.ibm.ws.report.binary.utilities.ArgumentDetail;
import com.ibm.ws.report.technology.DetailResult;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public class CreateThreadMethodsInWebOrEjbProject
extends DetectMethod {
    protected static final EnumSet<RuleType> ruleType = EnumSet.of(RuleType.FileRule, RuleType.JavaRule);
    protected static final String RULE_NAME = "CreateThreadMethodsInWebOrEjbProject";
    protected static final String RULE_DESC = "com.ibm.ws.appconversion.BehaviorCreateThread";
    protected static final String[] _allMethodNames = new String[]{"run", "start"};
    protected static final String[] _methodNameRun = new String[]{_allMethodNames[0]};
    protected static final String[] _ownerRunMethod = new String[]{"java.lang.Runnable"};
    protected static final String[] _methodNameStart = new String[]{_allMethodNames[1]};
    protected static final String[] _ownerStartMethod = new String[]{"java.lang.Thread"};
    protected static final String[] annotationNames = new String[]{"javax.ejb.Stateless", "javax.ejb.Stateful", "javax.ejb.Singleton", "javax.ejb.MessageDriven"};
    protected static final String location = "class";
    protected static final Pattern[] ejbJarFileName = new Pattern[]{Pattern.compile("(.*/)?(META-INF|WEB-INF)/ejb-jar\\.xml")};
    protected DetectAnnotation _ejbAnnotations = null;
    protected DetectFile _ejbJarXml = null;
    protected DetectMethod _startMethod = null;

    public CreateThreadMethodsInWebOrEjbProject() {
        this(RULE_NAME, Messages.getRuleDescription(RULE_DESC), _methodNameRun, _ownerRunMethod, null, null, null, false, null, null, null);
    }

    public CreateThreadMethodsInWebOrEjbProject(String ruleName, String desc, String[] methodNames, String[] owners, String returnType, String args, String[] excludePackageNames, boolean flagOnce, List<ArgumentDetail> argDetails, String[] flagCatchExceptions, String[] flagUnhandledExceptions) {
        super(ruleName, desc, methodNames, owners, returnType, args, excludePackageNames, flagOnce, argDetails, flagCatchExceptions, flagUnhandledExceptions);
        this._startMethod = new DetectMethod(RULE_NAME, desc, _methodNameStart, _ownerStartMethod, null, null, excludePackageNames, false, null, null, null);
        this._ejbAnnotations = new DetectAnnotation(RULE_NAME, desc, annotationNames, null, null, null, null, null, false, location, null, null);
        this._ejbJarXml = new DetectFile(RULE_NAME, desc, ejbJarFileName, false);
    }

    @Override
    public String[] getAnnotations() {
        return annotationNames;
    }

    @Override
    public String[] getMethodNames() {
        return _allMethodNames;
    }

    @Override
    public EnumSet<RuleType> getRuleTypes() {
        return ruleType;
    }

    @Override
    public void clearResults() {
        super.clearResults();
        this._ejbAnnotations.clearResults();
        this._ejbJarXml.clearResults();
        this._startMethod.clearResults();
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        super.analyze(store, detectOnce);
        this._startMethod.analyze(store, detectOnce);
        this._ejbAnnotations.analyze(store, detectOnce);
    }

    @Override
    public List<DetailResult> getResults(SimpleDataStore store) {
        ArrayList<DetailResult> finalResults = new ArrayList<DetailResult>();
        List<DetailResult> runMethodResults = super.getResults(store);
        List<DetailResult> startMethodResults = this._startMethod.getResults(store);
        List<DetailResult> ejbJarAnnotations = this._ejbAnnotations.getResults(store);
        ArrayList<DetailResult> potentialResultsIfInEjbProject = new ArrayList<DetailResult>();
        HashSet<String> jarFileNames = new HashSet<String>();
        if (!runMethodResults.isEmpty() || !startMethodResults.isEmpty()) {
            this.processResults(runMethodResults, finalResults, potentialResultsIfInEjbProject);
            this.processResults(startMethodResults, finalResults, potentialResultsIfInEjbProject);
            this.processJarFileNames(ejbJarAnnotations, jarFileNames);
            this._ejbJarXml.analyze(store, this.flagOnce);
            List<DetailResult> ejbJarFiles = this._ejbJarXml.getResults(store);
            this.processJarFileNames(ejbJarFiles, jarFileNames);
            for (DetailResult nextResult : potentialResultsIfInEjbProject) {
                String fileName = nextResult.getFileName();
                if (!jarFileNames.contains(fileName.substring(0, fileName.lastIndexOf(".jar") + 4))) continue;
                finalResults.add(nextResult);
            }
        }
        return finalResults;
    }

    protected void processResults(List<DetailResult> results, List<DetailResult> finalResults, List<DetailResult> potentialResults) {
        for (DetailResult nextResult : results) {
            String fileName = nextResult.getFileName();
            if (fileName.contains(".war")) {
                finalResults.add(nextResult);
                continue;
            }
            if (!fileName.contains(".jar")) continue;
            potentialResults.add(nextResult);
        }
    }

    protected void processJarFileNames(List<DetailResult> results, Set<String> jarFileNames) {
        for (DetailResult nextResult : results) {
            String fileName = nextResult.getFileName();
            int index = fileName.lastIndexOf(".jar");
            if (index <= -1) continue;
            jarFileNames.add(fileName.substring(0, index + 4));
        }
    }
}

