/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom;

import com.ibm.ws.report.binary.Messages;
import com.ibm.ws.report.binary.asm.utilities.AnnotationDetails;
import com.ibm.ws.report.binary.asm.utilities.AnnotationInfo;
import com.ibm.ws.report.binary.asm.utilities.ClassDataStore;
import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectRule;
import com.ibm.ws.report.binary.rules.RuleType;
import com.ibm.ws.report.binary.utilities.XMLResource;
import com.ibm.ws.report.binary.utilities.XMLRuleUtil;
import com.ibm.ws.report.technology.DetailResult;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BehaviorXmlJPAUseListAttributeForArrays
extends DetectRule {
    protected static EnumSet<RuleType> ruleType = EnumSet.of(RuleType.XmlRule, RuleType.JavaRule);
    protected static String RULE_NAME = "BehaviorXmlJPAUseListAttributeForArrays";
    protected static String namespace = "*";
    protected static String[] tags = new String[]{"property"};
    protected static String[] xmlFiles = new String[]{"META-INF/persistence.xml"};
    protected static String attributeNamespace = "*";
    protected static String attributeName = "name";
    protected static String attributeValue = "openjpa\\.Compatibility";
    protected static String className = "javax.persistence.metamodel.StaticMetamodel";
    protected static String annotationAttributeName = "value";
    protected static String annotationAttributeType = "java.lang.String";
    protected static String USE_LIST_ATTRIBUTES_FOR_ARRAYS = "UseListAttributeForArrays=";
    protected Set<String> classNamesReferencedByAnnotation = new HashSet<String>();
    protected Map<String, List<String[]>> classNamesReferencedByPersistenceXml = new HashMap<String, List<String[]>>();
    protected Map<String, List<DetailResult>> tempResultsByPersistenceXml = new HashMap<String, List<DetailResult>>();
    private static String truePat = "[tT][rR][uU][eE]";

    public BehaviorXmlJPAUseListAttributeForArrays() {
        this(RULE_NAME, Messages.getRuleDescription("appconversion.was2was.v85.behavior.xml.JPAUseListAttributeForArrays"), false);
    }

    public BehaviorXmlJPAUseListAttributeForArrays(String ruleName, String desc, boolean flagOnce) {
        super(ruleName, desc, flagOnce);
    }

    @Override
    public EnumSet<RuleType> getRuleTypes() {
        return ruleType;
    }

    @Override
    public String[] getFileNames() {
        return xmlFiles;
    }

    @Override
    public String[] getAnnotations() {
        return new String[]{className};
    }

    @Override
    public void clearResults() {
        super.clearResults();
        this.classNamesReferencedByAnnotation.clear();
        this.classNamesReferencedByPersistenceXml.clear();
        this.tempResultsByPersistenceXml.clear();
    }

    @Override
    public List<DetailResult> getResults(SimpleDataStore store) {
        ArrayList<DetailResult> results = new ArrayList<DetailResult>();
        if (this.classNamesReferencedByAnnotation.isEmpty()) {
            return results;
        }
        Set<String> keys = this.classNamesReferencedByPersistenceXml.keySet();
        for (String key : keys) {
            List<String[]> classNamesFound = this.classNamesReferencedByPersistenceXml.get(key);
            List<DetailResult> resultsCached = this.tempResultsByPersistenceXml.get(key);
            int size = classNamesFound.size();
            int i = 0;
            while (i < size) {
                String[] cachedClassNames;
                String[] stringArray = cachedClassNames = classNamesFound.get(i);
                int n = cachedClassNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String thisClassName = stringArray[n2];
                    if (thisClassName != null && this.classNamesReferencedByAnnotation.contains(thisClassName)) {
                        DetailResult result = resultsCached.get(i);
                        results.add(result);
                        break;
                    }
                    ++n2;
                }
                ++i;
            }
        }
        return results;
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        Set<String> keys = store.getDocumentKeys();
        if (!keys.isEmpty()) {
            for (String key : keys) {
                XMLResource resource = store.getDocument(key);
                Document doc = resource.getDocument();
                List<Node> results = XMLRuleUtil.getTagDeclarationsByAttributeValue(doc, key, xmlFiles, namespace, tags, attributeNamespace, attributeName, attributeValue);
                if (results.isEmpty()) continue;
                for (Node node : results) {
                    List<Object> theseResults;
                    List<Object> theseClassNames;
                    String[] classNamesFound;
                    Element ownerElement;
                    NamedNodeMap attrs;
                    String propertyValue;
                    String attrValue = attributeValue;
                    String value = node.getNodeValue();
                    if (value != null) {
                        attrValue = value;
                    }
                    if ((propertyValue = (attrs = (ownerElement = ((Attr)node).getOwnerElement()).getAttributes()).getNamedItem("value").getNodeValue()) == null || this.propValueEqualsTrue(propertyValue) || (classNamesFound = this.getPersistenceUnitClasses(ownerElement)) == null || classNamesFound.length <= 0) continue;
                    if (this.classNamesReferencedByPersistenceXml.containsKey(key)) {
                        theseClassNames = this.classNamesReferencedByPersistenceXml.get(key);
                        theseClassNames.add(classNamesFound);
                    } else {
                        theseClassNames = new ArrayList<String[]>();
                        theseClassNames.add(classNamesFound);
                        this.classNamesReferencedByPersistenceXml.put(key, theseClassNames);
                    }
                    DetailResult thisResult = new DetailResult(this.ruleName, key, this.ruleDescription, String.valueOf(ownerElement.getLocalName()) + "." + attributeName + "=" + attrValue, 1, null, resource.getNodeLineNumber(node));
                    if (this.tempResultsByPersistenceXml.containsKey(key)) {
                        theseResults = this.tempResultsByPersistenceXml.get(key);
                        theseResults.add(thisResult);
                        continue;
                    }
                    theseResults = new ArrayList<DetailResult>();
                    theseResults.add(thisResult);
                    this.tempResultsByPersistenceXml.put(key, theseResults);
                }
            }
        }
        if (!(keys = store.getClassDataStoreKeys()).isEmpty()) {
            for (String key : keys) {
                ClassDataStore data = store.getClassDataStore(key);
                if (!data.containsAnnotation(className)) continue;
                List<AnnotationDetails> ads = data.getAnnotationDetails(className);
                for (AnnotationDetails ad : ads) {
                    Set<AnnotationInfo> ais = ad.getAnnotationInformation(annotationAttributeType);
                    if (ais.size() <= 0) continue;
                    for (AnnotationInfo ai : ais) {
                        String attributeValue;
                        if (!ai.matches(annotationAttributeName, annotationAttributeType) || (attributeValue = ai.getAttributeValue()) == null) continue;
                        this.classNamesReferencedByAnnotation.add(attributeValue);
                    }
                }
            }
        }
    }

    private boolean propValueEqualsTrue(String argPropValue) {
        String[] parts;
        if (!argPropValue.contains(USE_LIST_ATTRIBUTES_FOR_ARRAYS)) {
            return false;
        }
        String[] stringArray = parts = argPropValue.split(",");
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            if ((part = part.trim()).matches(String.valueOf(USE_LIST_ATTRIBUTES_FOR_ARRAYS) + truePat)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private String[] getPersistenceUnitClasses(Node node) {
        Node persistenceUnitNode = node.getParentNode().getParentNode();
        if (persistenceUnitNode.getLocalName() != null && !persistenceUnitNode.getLocalName().equals("persistence-unit")) {
            return null;
        }
        NodeList childNodes = persistenceUnitNode.getChildNodes();
        int size = childNodes.getLength();
        String[] classNamesFound = new String[size];
        int i = 0;
        int index = 0;
        while (i < size) {
            String classTextContent;
            Node childNode = childNodes.item(i);
            String childNodeName = childNode.getLocalName();
            if (childNodeName != null && childNodeName.equals("class") && (classTextContent = this.stripTrailingJavaOrClass(XMLRuleUtil.getTextWithoutWhitespace(childNode))) != null) {
                classNamesFound[index++] = classTextContent;
            }
            ++i;
        }
        return classNamesFound;
    }

    private String stripTrailingJavaOrClass(String argValue) {
        if (argValue.endsWith(".java")) {
            argValue = argValue.substring(0, argValue.lastIndexOf(".java"));
        } else if (argValue.endsWith(".class")) {
            argValue = argValue.substring(0, argValue.lastIndexOf(".class"));
        }
        return argValue;
    }
}

