/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom;

import com.ibm.ws.report.binary.Messages;
import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectMethod;
import com.ibm.ws.report.binary.rules.DetectStringLiteral;
import com.ibm.ws.report.binary.utilities.ArgumentDetail;
import com.ibm.ws.report.technology.DetailResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;

public class BehaviorSOAPAction
extends DetectMethod {
    protected static final String RULE_NAME = "BehaviorSOAPAction";
    protected static final String RULE_DESC = "appconversion.was2was.80.behavior.soap.action";
    protected static final String SOAP_PROP_KEY_URI = "javax\\.xml\\.ws\\.soap\\.http\\.soapaction\\.uri";
    protected static final String SOAP_PROP_KEY_USE = "javax\\.xml\\.ws\\.soap\\.http\\.soapaction\\.use";
    protected static final String[] _allMethodNames = new String[]{"createDispatch", "put"};
    protected static final String[] _methodNameCreateDispatch = new String[]{_allMethodNames[0]};
    protected static final String[] _ownerCreateDispatch = new String[]{"javax.xml.ws.Service"};
    protected static final String[] _methodNamePut = new String[]{_allMethodNames[1]};
    protected static final String[] _ownerPut = new String[]{"java.util.Map"};
    protected static final String _argPut = "java.lang.Object, java.lang.Object";
    protected static List<ArgumentDetail> argDetailPutSoapActionUri = new ArrayList<ArgumentDetail>();
    protected static List<ArgumentDetail> argDetailPutSoapActionUse = new ArrayList<ArgumentDetail>();
    protected static final Pattern[] _stringLiterals = new Pattern[]{Pattern.compile("javax\\.xml\\.ws\\.soap\\.http\\.soapaction\\.uri"), Pattern.compile("javax\\.xml\\.ws\\.soap\\.http\\.soapaction\\.use")};
    protected DetectMethod _putSoapActionUse = null;
    protected DetectMethod _putSoapActionUri = null;
    protected DetectStringLiteral _detectSoapPropertyKeys = null;

    static {
        argDetailPutSoapActionUri.add(new ArgumentDetail(0, false, false, SOAP_PROP_KEY_URI, null, null));
        argDetailPutSoapActionUse.add(new ArgumentDetail(0, false, false, SOAP_PROP_KEY_USE, null, null));
        argDetailPutSoapActionUse.add(new ArgumentDetail(1, true, false, null, "FALSE", "java.lang.Boolean"));
        argDetailPutSoapActionUse.add(new ArgumentDetail(1, true, false, null, "0", "boolean"));
        argDetailPutSoapActionUse.add(new ArgumentDetail(1, true, false, "(?i:false)$", null, "java.lang.String"));
    }

    public BehaviorSOAPAction() {
        this(RULE_NAME, Messages.getRuleDescription(RULE_DESC), _methodNameCreateDispatch, _ownerCreateDispatch, null, null, null, false, null, null, null);
    }

    public BehaviorSOAPAction(String ruleName, String desc, String[] methodNames, String[] owners, String returnType, String args, String[] excludePackageNames, boolean flagOnce, List<ArgumentDetail> argDetails, String[] flagCatchExceptions, String[] flagUnhandledExceptions) {
        super(ruleName, desc, methodNames, owners, returnType, args, excludePackageNames, flagOnce, argDetails, flagCatchExceptions, flagUnhandledExceptions);
        this._detectSoapPropertyKeys = new DetectStringLiteral(RULE_NAME, Messages.getRuleDescription(RULE_DESC), _stringLiterals, flagOnce);
        this._putSoapActionUri = new DetectMethod(RULE_NAME, Messages.getRuleDescription(RULE_DESC), _methodNamePut, _ownerPut, null, _argPut, excludePackageNames, false, argDetailPutSoapActionUri, null, null);
        this._putSoapActionUse = new DetectMethod(RULE_NAME, Messages.getRuleDescription(RULE_DESC), _methodNamePut, _ownerPut, null, _argPut, excludePackageNames, false, argDetailPutSoapActionUse, null, null);
    }

    @Override
    public String[] getMethodNames() {
        return _allMethodNames;
    }

    @Override
    public boolean requireStackDetails() {
        return true;
    }

    @Override
    public void clearResults() {
        super.clearResults();
        this._detectSoapPropertyKeys.clearResults();
        this._putSoapActionUri.clearResults();
        this._putSoapActionUse.clearResults();
    }

    @Override
    public List<DetailResult> getResults(SimpleDataStore store) {
        List<DetailResult> parentResults = super.getResults(store);
        if (!parentResults.isEmpty()) {
            List<DetailResult> soapPropKeyResults = this._detectSoapPropertyKeys.getResults(store);
            List<DetailResult> soapActionUriResults = this._putSoapActionUri.getResults(store);
            List<DetailResult> soapActionUse = this._putSoapActionUse.getResults(store);
            Iterator<DetailResult> it = parentResults.iterator();
            while (it.hasNext()) {
                DetailResult nextResult = it.next();
                String fileName = nextResult.getFileName();
                if (!this.containsResultForFileName(fileName, soapPropKeyResults) || !this.containsResultForFileName(fileName, soapActionUriResults) || this.containsResultForFileName(fileName, soapActionUse)) continue;
                it.remove();
            }
        }
        return parentResults;
    }

    protected boolean containsResultForFileName(String fileName, List<DetailResult> compareResults) {
        boolean flag = false;
        for (DetailResult compareResult : compareResults) {
            if (!fileName.equals(compareResult.getFileName())) continue;
            return true;
        }
        return flag;
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        super.analyze(store, detectOnce);
        this._detectSoapPropertyKeys.analyze(store, detectOnce);
        this._putSoapActionUri.analyze(store, detectOnce);
        this._putSoapActionUse.analyze(store, detectOnce);
    }
}

