/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules;

import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectRule;
import com.ibm.ws.report.binary.rules.RuleType;
import com.ibm.ws.report.technology.DetailResult;
import java.util.EnumSet;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class DetectManifestAttribute
extends DetectRule {
    protected static EnumSet<RuleType> ruleType = EnumSet.of(RuleType.ManifestRule);
    protected String attributeName = null;
    protected String attributeValue = null;
    protected String archiveName = null;

    public DetectManifestAttribute(String ruleName, String desc, String name2, String value, boolean flagOnce) {
        this(ruleName, desc, name2, value, flagOnce ? DetectRule.FlagOnce.ARCHIVE : DetectRule.FlagOnce.NONE);
    }

    public DetectManifestAttribute(String ruleName, String desc, String name2, String value, DetectRule.FlagOnce flagOnceType) {
        this(ruleName, desc, name2, value, null, flagOnceType, false);
    }

    public DetectManifestAttribute(String ruleName, String desc, String name2, String value, String archiveName, DetectRule.FlagOnce flagOnceType, boolean hideResult) {
        super(ruleName, desc, flagOnceType, hideResult);
        this.attributeName = name2;
        this.attributeValue = value;
        this.archiveName = archiveName;
    }

    @Override
    public EnumSet<RuleType> getRuleTypes() {
        return ruleType;
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        if (detectOnce && !this.detailResults.isEmpty()) {
            return;
        }
        Set<String> keys = store.getManifestKeys();
        if (!keys.isEmpty()) {
            for (String key : keys) {
                String value;
                if (this.archiveName != null && !key.matches(this.archiveName)) {
                    return;
                }
                if (!this.shouldFlag(key)) continue;
                Manifest mf = store.getManifest(key);
                Attributes manifestMap = mf.getMainAttributes();
                String string = value = manifestMap != null ? manifestMap.getValue(this.attributeName) : null;
                if (this.attributeValue != null) {
                    if (value == null || !value.matches(this.attributeValue)) continue;
                    if (this.flag(key)) {
                        this.detailResults.add(new DetailResult(this.ruleName, key, this.ruleDescription, String.valueOf(this.attributeName) + "=" + value));
                    }
                    if (!detectOnce && !this.flagOnce) continue;
                    return;
                }
                if (value == null) continue;
                if (this.flag(key)) {
                    this.detailResults.add(new DetailResult(this.ruleName, key, this.ruleDescription, this.attributeName));
                }
                if (!detectOnce && !this.flagOnce) continue;
                return;
            }
        }
    }
}

