/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules;

import com.ibm.ws.report.analyze.IdentifierObject;
import com.ibm.ws.report.binary.Messages;
import com.ibm.ws.report.binary.asm.utilities.ClassDataStore;
import com.ibm.ws.report.binary.asm.utilities.ClassOrPackageDetails;
import com.ibm.ws.report.binary.asm.utilities.ClassOrPackageOccurrence;
import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectRule;
import com.ibm.ws.report.binary.rules.RuleType;
import com.ibm.ws.report.binary.utilities.XMLResource;
import com.ibm.ws.report.binary.utilities.XMLRuleUtil;
import com.ibm.ws.report.technology.DetailResult;
import com.ibm.ws.report.utilities.ReportUtility;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Pattern;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DetectJNDI
extends DetectRule {
    protected static final EnumSet<RuleType> ruleType = EnumSet.of(RuleType.XmlRule, RuleType.JavaRule, RuleType.PropertyRule);
    public static final Pattern POM_PROPERTY_REGEX = Pattern.compile("(.*/)?pom\\.properties");
    private static String matchNameRegex = ".*name.*";

    public DetectJNDI(String ruleName, String desc) {
        super(ruleName, desc, false);
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        Map<String, Map<String, IdentifierObject>> possibleIdentifierNames = store.getPossibleIdentifierNames();
        if (possibleIdentifierNames != null && !possibleIdentifierNames.isEmpty()) {
            String appName = this.getAppName(store.getCurrentAppBeingProcessed(), possibleIdentifierNames);
            Map<String, IdentifierObject> identifiersRelatedToRule = null;
            Map<String, IdentifierObject> identifierNamesForApp = possibleIdentifierNames.get(appName);
            Set<String> foundIdentifierNamesForApp = store.getFoundIdentifierNames().get(appName);
            if (identifierNamesForApp == null || foundIdentifierNamesForApp == null) {
                ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(com.ibm.ws.report.Messages.getString("File_Not_Found"), appName));
                return;
            }
            identifiersRelatedToRule = this.getIdentifierObjectsForRule(identifierNamesForApp, foundIdentifierNamesForApp);
            if (identifiersRelatedToRule == null || identifiersRelatedToRule.isEmpty()) {
                return;
            }
            for (String key : store.getClassDataStoreKeys()) {
                ClassDataStore data = store.getClassDataStore(key);
                Iterator<IdentifierObject> namesIt = identifiersRelatedToRule.values().iterator();
                while (namesIt.hasNext()) {
                    IdentifierObject idObject = namesIt.next();
                    String name2 = idObject.getIdentifierName();
                    Pattern pattern = Pattern.compile(matchNameRegex.replace("name", name2));
                    Set<ClassOrPackageDetails> cpds = data.getStringLiteralDetails(pattern);
                    if (cpds.isEmpty()) continue;
                    this.addClassResultsForAllHits(cpds, key, idObject, foundIdentifierNamesForApp, store);
                    if (!this.flagOnce) continue;
                    namesIt.remove();
                    if (!identifiersRelatedToRule.isEmpty()) continue;
                    return;
                }
            }
            Set<String> keys = store.getDocumentKeys();
            if (!keys.isEmpty()) {
                for (String key : keys) {
                    XMLResource resource = store.getDocument(key);
                    Document doc = resource.getDocument();
                    boolean validFile = true;
                    validFile = XMLRuleUtil.validateXMLFile(doc, DetectRule.XMLFileType.ALL);
                    if (!validFile) continue;
                    Iterator<IdentifierObject> namesIt = identifiersRelatedToRule.values().iterator();
                    block3: while (namesIt.hasNext()) {
                        IdentifierObject idObject = namesIt.next();
                        String name3 = idObject.getIdentifierName();
                        List<Node> results = XMLRuleUtil.getTagDeclarationsByNodeOrAttributeValue(doc, "", new String[]{""}, "*", matchNameRegex.replace("name", name3), false, false);
                        for (Node result : results) {
                            this.addResult(key, name3, idObject.getType().toString(), null, resource.getNodeLineNumber(result), foundIdentifierNamesForApp, idObject, store);
                            if (!this.flagOnce) continue;
                            namesIt.remove();
                            if (!identifiersRelatedToRule.isEmpty()) continue block3;
                            return;
                        }
                    }
                }
            }
            for (String key : store.getPropsKeys()) {
                Properties props;
                String stringOfProps;
                if (POM_PROPERTY_REGEX.matcher(key).matches() || (stringOfProps = (props = store.getProps(key)).toString()) == null) continue;
                Iterator<IdentifierObject> namesIt = identifiersRelatedToRule.values().iterator();
                while (namesIt.hasNext()) {
                    IdentifierObject idObject = namesIt.next();
                    String name4 = idObject.getIdentifierName();
                    if (!stringOfProps.contains(name4)) continue;
                    this.addResult(key, name4, idObject.getType().toString(), null, -1, foundIdentifierNamesForApp, idObject, store);
                    if (!this.flagOnce) continue;
                    namesIt.remove();
                    if (!identifiersRelatedToRule.isEmpty()) continue;
                    return;
                }
            }
        }
    }

    private void addClassResultsForAllHits(Set<ClassOrPackageDetails> cpds, String key, IdentifierObject obj, Set<String> foundIdentifierNamesForApp, SimpleDataStore store) {
        for (ClassOrPackageDetails cpd : cpds) {
            Map<String, ClassOrPackageOccurrence> info = cpd.getReferenceAndLineInfo();
            Set<String> methodKeys = info.keySet();
            ArrayList<String> sortedKeys = new ArrayList<String>(methodKeys);
            Collections.sort(sortedKeys);
            int numKeys = sortedKeys.size();
            int i = 0;
            while (i < numKeys) {
                String methodKey;
                String reference = methodKey = (String)sortedKeys.get(i);
                if (methodKey.contains("<init>")) {
                    reference = Messages.getString("Report_Reference_Constructor");
                } else if (methodKey.contains("<clinit>")) {
                    reference = Messages.getString("Report_Reference_Static_Initializer");
                }
                ClassOrPackageOccurrence copo = info.get(methodKey);
                List<Integer> sortedLines = copo.getLineNumbers();
                Collections.sort(sortedLines);
                int numLines = sortedLines.size();
                int lastLineNumber = -1;
                int j = 0;
                while (j < numLines) {
                    Integer lineNumber = sortedLines.get(j);
                    int thisLineNumber = lineNumber;
                    if (thisLineNumber != lastLineNumber) {
                        this.addResult(key, obj.getIdentifierName(), obj.getType().toString(), reference, lineNumber, foundIdentifierNamesForApp, obj, store);
                        lastLineNumber = thisLineNumber;
                        if (this.flagOnce) {
                            return;
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public Map<String, IdentifierObject> getIdentifierObjectsForRule(Map<String, IdentifierObject> identifierNamesForApp, Set<String> foundIdentifierNamesPerApp) {
        HashMap<String, IdentifierObject> relatedIdentifierObjects = new HashMap<String, IdentifierObject>();
        block0: for (IdentifierObject obj : identifierNamesForApp.values()) {
            List<String> affectedRules = obj.getRules();
            if (affectedRules == null) continue;
            for (String rule : affectedRules) {
                if (!rule.equals(this.ruleName)) continue;
                relatedIdentifierObjects.put(obj.getIdentifierName(), obj);
                continue block0;
            }
        }
        return relatedIdentifierObjects;
    }

    public String getAppName(String currentAppName, Map<String, Map<String, IdentifierObject>> possibleIdentifierNames) {
        String appName = currentAppName;
        if (currentAppName.equals("sharedLibraries")) {
            appName = possibleIdentifierNames.keySet().iterator().next();
        }
        return appName;
    }

    public void addResult(String fileName, String jndiName, String resourceType, String reference, int lineNumber, Set<String> foundIdentifierNamesForApp, IdentifierObject obj, SimpleDataStore store) {
        this.detailResults.add(new DetailResult(this.ruleName, fileName, this.ruleDescription, String.valueOf(jndiName) + " (" + resourceType + ")", 1, reference, lineNumber));
    }

    public static String getStringFromDocument(Document doc) throws TransformerException {
        DOMSource domSource = new DOMSource(doc);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "4");
        transformer.transform(domSource, result);
        return writer.toString();
    }

    @Override
    public EnumSet<RuleType> getRuleTypes() {
        return ruleType;
    }

    @Override
    public String[] getFileNames() {
        return new String[]{"(?!.*pom).*\\.(xml|xmi|props|properties)"};
    }
}

