/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules;

import com.ibm.ws.report.binary.Messages;
import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectRule;
import com.ibm.ws.report.binary.rules.RuleType;
import com.ibm.ws.report.binary.utilities.RuleHelper;
import com.ibm.ws.report.technology.DetailResult;
import com.ibm.ws.report.utilities.ReportUtility;
import java.util.EnumSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Pattern;

public class DetectFile
extends DetectRule {
    protected static EnumSet<RuleType> ruleType = EnumSet.of(RuleType.FileRule);
    protected Pattern[] files = null;
    protected String[] folders = null;
    protected String[] fileNames = null;
    protected boolean flagMissingFile = false;
    protected boolean detectPomProperties = false;
    protected boolean detectMessageProperties = false;
    public static final Pattern POM_PROPERTY_REGEX = Pattern.compile("(.*/)?pom\\.properties");
    public static final Pattern MESSAGE_PROPERTY_REGEX = Pattern.compile("(.*/)?([mM]essage(s)?\\.properties|(.*)_[a-z][a-z](_[A-Z][A-Z])?\\.properties)");

    public DetectFile(String ruleName, String desc, Pattern[] files, boolean flagOnce) {
        this(ruleName, desc, files, flagOnce, null, null, false, false, false);
    }

    public DetectFile(String ruleName, String desc, Pattern[] files, boolean flagOnce, String[] folders, String[] fileNames, boolean flagMissingFile, boolean detectPomProperties, boolean detectMessageProperties) {
        this(ruleName, desc, files, flagOnce ? DetectRule.FlagOnce.ARCHIVE : DetectRule.FlagOnce.NONE, false, folders, fileNames, flagMissingFile, detectPomProperties, detectMessageProperties);
    }

    public DetectFile(String ruleName, String desc, Pattern[] files, DetectRule.FlagOnce flagOnceType, boolean hideResult, String[] folders, String[] fileNames, boolean flagMissingFile, boolean detectPomProperties, boolean detectMessageProperties) {
        super(ruleName, desc, flagOnceType, hideResult);
        this.files = files;
        this.folders = folders;
        this.fileNames = fileNames;
        this.flagMissingFile = flagMissingFile;
        this.detectPomProperties = detectPomProperties;
        this.detectMessageProperties = detectMessageProperties;
    }

    @Override
    public EnumSet<RuleType> getRuleTypes() {
        return ruleType;
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        if (detectOnce && !this.flagMissingFile && !this.detailResults.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < this.files.length) {
            Pattern pattern = this.files[i];
            Set<String> matches = null;
            matches = this.flagMissingFile ? store.getMatchingFoldersMissingFile(pattern, RuleHelper.splitArgs(this.folders[i]), this.fileNames[i]) : store.getMatchingFileNames(pattern);
            for (String key : matches) {
                if (this.flag(key) && DetectFile.flaggablePropertiesFile(this.detectPomProperties, this.detectMessageProperties, key)) {
                    this.detailResults.add(new DetailResult(this.ruleName, key, this.ruleDescription, pattern.pattern()));
                }
                if (!detectOnce) continue;
                return;
            }
            ++i;
        }
    }

    public static boolean flaggablePropertiesFile(boolean detectPomProperties, boolean detectMessageProperties, String file) {
        if (!detectPomProperties && POM_PROPERTY_REGEX.matcher(file).matches()) {
            ReportUtility.logger.get().log(Level.FINEST, Messages.getFormattedMessage(Messages.getString("PomProperties_Skipped"), file));
            return false;
        }
        if (!detectMessageProperties && MESSAGE_PROPERTY_REGEX.matcher(file).matches()) {
            ReportUtility.logger.get().log(Level.FINEST, Messages.getFormattedMessage(Messages.getString("MessagesFile_Skipped"), file));
            return false;
        }
        return true;
    }
}

