/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules;

import com.ibm.ws.report.binary.Messages;
import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectRule;
import com.ibm.ws.report.binary.rules.RuleType;
import com.ibm.ws.report.binary.utilities.XMLResource;
import com.ibm.ws.report.binary.utilities.XMLRuleUtil;
import com.ibm.ws.report.technology.DetailResult;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DetectDTD
extends DetectRule {
    protected static EnumSet<RuleType> ruleType = EnumSet.of(RuleType.XmlRule);
    protected String rootTag = null;
    protected String dtdName = null;
    protected String[] xmlFiles = null;
    protected boolean flagNullDocTypeWhenNoVersionAttrExists = false;

    public DetectDTD(String ruleName, String desc, String dtdName, String[] fileNames, boolean flagOnce, boolean flagNullDocTypeWhenNoVersionAttrExists) {
        this(ruleName, desc, dtdName, fileNames, flagOnce ? DetectRule.FlagOnce.ARCHIVE : DetectRule.FlagOnce.NONE, flagNullDocTypeWhenNoVersionAttrExists);
    }

    public DetectDTD(String ruleName, String desc, String dtdName, String[] fileNames, DetectRule.FlagOnce flagOnceType, boolean flagNullDocTypeWhenNoVersionAttrExists) {
        this(ruleName, desc, null, dtdName, fileNames, flagOnceType, false, flagNullDocTypeWhenNoVersionAttrExists);
    }

    public DetectDTD(String ruleName, String desc, String rootTag, String dtdName, String[] fileNames, DetectRule.FlagOnce flagOnceType, boolean hideResult, boolean flagNullDocTypeWhenNoVersionAttrExists) {
        super(ruleName, desc, flagOnceType, hideResult);
        this.rootTag = rootTag;
        this.dtdName = dtdName;
        this.xmlFiles = fileNames;
        this.flagNullDocTypeWhenNoVersionAttrExists = flagNullDocTypeWhenNoVersionAttrExists;
    }

    @Override
    public EnumSet<RuleType> getRuleTypes() {
        return ruleType;
    }

    @Override
    public String[] getFileNames() {
        if (this.xmlFiles == null) {
            return new String[0];
        }
        return this.xmlFiles;
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        if (detectOnce && !this.detailResults.isEmpty()) {
            return;
        }
        Set<String> keys = store.getDocumentKeys();
        if (!keys.isEmpty()) {
            for (String key : keys) {
                String criteria;
                XMLResource resource;
                Document doc;
                List<Node> results;
                if (!this.shouldFlag(key) || (results = XMLRuleUtil.getDoctypeDTDReference(doc = (resource = store.getDocument(key)).getDocument(), key, this.xmlFiles, this.rootTag, this.dtdName, this.flagNullDocTypeWhenNoVersionAttrExists)).isEmpty()) continue;
                String matchingDTD = XMLRuleUtil.getDocumentTypeSystemId(doc);
                if (matchingDTD == null) {
                    matchingDTD = Messages.getString("Report_Reference_No_Version_Found");
                }
                String string = criteria = this.rootTag == null ? matchingDTD : String.valueOf(matchingDTD) + ":" + this.rootTag;
                if (this.flag(key)) {
                    this.detailResults.add(new DetailResult(this.ruleName, key, this.ruleDescription, criteria, 1, null, 1));
                }
                if (detectOnce || this.flagOnce) break;
            }
        }
    }
}

