/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.featurelist;

import com.ibm.ws.report.binary.featurelist.FeatureList;
import com.ibm.ws.report.binary.featurelist.FeatureUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;

public class FeatureSet
implements Iterable<String> {
    private final String[] features;
    private final Document resource;

    public FeatureSet(Document featureListResource, String[] s) {
        this.features = s;
        this.resource = featureListResource;
    }

    public FeatureSet(Document featureListResource, List<String> s) {
        this.features = s.toArray(new String[s.size()]);
        this.resource = featureListResource;
    }

    public boolean supports(String featureToFind) {
        if (featureToFind == null) {
            return false;
        }
        if (!featureToFind.contains("-")) {
            String t = String.valueOf(featureToFind.toLowerCase()) + "-";
            String[] stringArray = this.features;
            int n = this.features.length;
            int n2 = 0;
            while (n2 < n) {
                String f = stringArray[n2];
                if (f.toLowerCase().startsWith(t) && this.isFeatureSupported(f)) {
                    return true;
                }
                ++n2;
            }
        } else {
            return this.isFeatureSupported(featureToFind);
        }
        return false;
    }

    public boolean isFeatureSupported(String featureToFind) {
        if (!featureToFind.contains("-")) {
            return false;
        }
        String[] stringArray = this.features;
        int n = this.features.length;
        int n2 = 0;
        while (n2 < n) {
            String feature = stringArray[n2];
            if (feature.equalsIgnoreCase(featureToFind) || FeatureUtil.isLowerVersion(featureToFind, feature) || FeatureList.isContainedBy(featureToFind, feature, this.resource)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public String resolve(String feature) {
        return FeatureSet.resolve(feature, this.features);
    }

    public static String resolve(String feature, String[] features) {
        if (feature == null) {
            return null;
        }
        if (!feature.contains("-")) {
            String t = String.valueOf(feature.toLowerCase()) + "-";
            String matchedFeature = null;
            String[] stringArray = features;
            int n = features.length;
            int n2 = 0;
            while (n2 < n) {
                String f = stringArray[n2];
                if (f.toLowerCase().startsWith(t)) {
                    try {
                        if (matchedFeature == null || FeatureUtil.compareFeatureVersions(matchedFeature, f) < 0) {
                            matchedFeature = f;
                        }
                    }
                    catch (Throwable throwable) {}
                }
                ++n2;
            }
            return matchedFeature;
        }
        String[] stringArray = features;
        int n = features.length;
        int n3 = 0;
        while (n3 < n) {
            String f = stringArray[n3];
            if (f.equalsIgnoreCase(feature)) {
                return f;
            }
            ++n3;
        }
        return null;
    }

    public String resolveToHigherVersion(String feature) {
        String resolvedFeature = FeatureSet.resolve(feature, this.features);
        if (resolvedFeature == null) {
            resolvedFeature = FeatureUtil.findHigherVersion(Arrays.asList(this.features), feature);
        }
        return resolvedFeature;
    }

    public String[] resolveAll(String feature) {
        return FeatureSet.resolveAll(feature, this.features);
    }

    public static String[] resolveAll(String feature, String[] features) {
        if (feature == null) {
            return null;
        }
        ArrayList<String> matchList = new ArrayList<String>();
        if (!feature.contains("-")) {
            String t = String.valueOf(feature.toLowerCase()) + "-";
            String[] stringArray = features;
            int n = features.length;
            int n2 = 0;
            while (n2 < n) {
                String f = stringArray[n2];
                if (f.toLowerCase().startsWith(t)) {
                    matchList.add(f);
                }
                ++n2;
            }
            if (matchList.isEmpty()) {
                return null;
            }
            String[] match = new String[matchList.size()];
            return matchList.toArray(match);
        }
        String[] stringArray = features;
        int n = features.length;
        int n3 = 0;
        while (n3 < n) {
            String f = stringArray[n3];
            if (f.equalsIgnoreCase(feature)) {
                return new String[]{f};
            }
            ++n3;
        }
        return null;
    }

    @Override
    public Iterator<String> iterator() {
        return Arrays.asList(this.features).iterator();
    }

    public void sort() {
        Arrays.sort(this.features);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("FeatureSet[");
        int size = this.features.length;
        int i = 0;
        while (i < size) {
            if (i > 0) {
                sb.append(",");
            }
            String s = this.features[i];
            sb.append(s);
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }
}

