/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.configutility.twas;

import com.ibm.ws.report.binary.configutility.FileUtilities;
import com.ibm.ws.report.utilities.ReportUtility;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TwasBindingScanningUtilities {
    public static void scanFilesForIdentifierNames(File xmlDir, Set<String> usedIdentifierNames, String appName) {
        HashSet<String> fileNames = new HashSet<String>();
        fileNames.add("web_merged.xml");
        fileNames.add("ejb-jar_merged.xml");
        fileNames.add("persistence.xml");
        fileNames.add("ibm-managed-beans_merged.xml");
        fileNames.add("ibm-managed-bean_merged.xml");
        fileNames.add("ibm-ejb-jar-bnd.xml");
        fileNames.add("ibm-web-bnd.xml");
        fileNames.add("ibm-managed-bean-bnd.xml");
        fileNames.add("ibm-managed-beans-bnd.xml");
        fileNames.add("ibm-ejb-jar-bnd.xmi");
        fileNames.add("ibm-web-bnd.xmi");
        List<File> fileList = FileUtilities.getFiles(fileNames, xmlDir);
        for (File xmlFile : fileList) {
            if (xmlFile.getName().equals("persistence.xml")) {
                TwasBindingScanningUtilities.scanPersistenceXMLJndiBindings(xmlFile, usedIdentifierNames, appName);
                continue;
            }
            if (xmlFile.getName().endsWith("-bnd.xml")) {
                TwasBindingScanningUtilities.scanForElementsWithAttribute(xmlFile, "resource-ref", "binding-name", usedIdentifierNames, appName);
                TwasBindingScanningUtilities.scanForElementsWithAttribute(xmlFile, "resource-env-ref", "binding-name", usedIdentifierNames, appName);
                TwasBindingScanningUtilities.scanForElementsWithAttribute(xmlFile, "message-destination-ref", "binding-name", usedIdentifierNames, appName);
                TwasBindingScanningUtilities.scanForElementsWithAttribute(xmlFile, "data-source", "binding-name", usedIdentifierNames, appName);
                TwasBindingScanningUtilities.scanForElementsWithAttribute(xmlFile, "env-entry", "binding-name", usedIdentifierNames, appName);
                TwasBindingScanningUtilities.scanForElementsWithAttribute(xmlFile, "authentication-alias", "name", usedIdentifierNames, appName);
                if (!xmlFile.getName().equals("ibm-ejb-jar-bnd.xml")) continue;
                TwasBindingScanningUtilities.scanIBMBindingsXMLActivationSpecBindings(xmlFile, usedIdentifierNames, appName);
                continue;
            }
            if (xmlFile.getName().endsWith("-bnd.xmi")) {
                TwasBindingScanningUtilities.scanIBMBindingsXMIAuthData(xmlFile, usedIdentifierNames, appName);
                TwasBindingScanningUtilities.scanForElementsWithAttribute(xmlFile, "resRefBindings", "jndiName", usedIdentifierNames, appName);
                TwasBindingScanningUtilities.scanForElementsWithAttribute(xmlFile, "datasource", "jndiName", usedIdentifierNames, appName);
                TwasBindingScanningUtilities.scanForElementsWithAttribute(xmlFile, "defaultDatasource", "jndiName", usedIdentifierNames, appName);
                TwasBindingScanningUtilities.scanForElementsWithAttribute(xmlFile, "defaultCMPConnectionFactory", "jndiName", usedIdentifierNames, appName);
                TwasBindingScanningUtilities.scanForElementsWithAttribute(xmlFile, "resourceEnvRefBindings", "jndiName", usedIdentifierNames, appName);
                TwasBindingScanningUtilities.scanForElementsWithAttribute(xmlFile, "cmpConnectionFactory", "jndiName", usedIdentifierNames, appName);
                if (!xmlFile.getName().equals("ibm-ejb-jar-bnd.xmi")) continue;
                TwasBindingScanningUtilities.scanIBMBindingsXMIActivationSpecBindings(xmlFile, usedIdentifierNames, appName);
                continue;
            }
            TwasBindingScanningUtilities.scanMergedXMLJndiBindings(xmlFile, "resource-ref", "res-ref-name", usedIdentifierNames, appName);
            TwasBindingScanningUtilities.scanMergedXMLJndiBindings(xmlFile, "resource-env-ref", "resource-env-ref-name", usedIdentifierNames, appName);
            TwasBindingScanningUtilities.scanMergedXMLJndiBindings(xmlFile, "message-destination-ref", "message-destination-ref-name", usedIdentifierNames, appName);
            TwasBindingScanningUtilities.scanMergedXMLJndiBindings(xmlFile, "env-entry", "env-entry-name", usedIdentifierNames, appName);
        }
    }

    private static void scanPersistenceXMLJndiBindings(File xmlFile, Set<String> usedIdentifierNames, String appName) {
        try {
            Document document = FileUtilities.getDocument(xmlFile);
            if (document != null) {
                NodeList jtaDSElementList = document.getElementsByTagName("jta-data-source");
                for (int i = 0; i < jtaDSElementList.getLength(); ++i) {
                    Element resourceRef = (Element)jtaDSElementList.item(i);
                    String jndiName = resourceRef.getTextContent();
                    ReportUtility.logger.get().log(Level.FINEST, "Adding used JNDI Name for app " + appName + ": " + jndiName + " from file " + xmlFile);
                    usedIdentifierNames.add(jndiName);
                }
                NodeList nonJtaDSElementList = document.getElementsByTagName("non-jta-data-source");
                for (int i = 0; i < nonJtaDSElementList.getLength(); ++i) {
                    Element resourceRef = (Element)nonJtaDSElementList.item(i);
                    String jndiName = resourceRef.getTextContent();
                    ReportUtility.logger.get().log(Level.FINEST, "Adding used JNDI Name for app " + appName + ": " + jndiName + " from file " + xmlFile);
                    usedIdentifierNames.add(jndiName);
                }
            }
        }
        catch (Exception e) {
            ReportUtility.logger.get().log(Level.FINE, "Caught exception in scanPersistenceXMLJndiBindings for file " + xmlFile + " for app " + appName + ". Exception " + e);
        }
    }

    private static void scanIBMBindingsXMLActivationSpecBindings(File xmlFile, Set<String> usedIdentifierNames, String appName) {
        try {
            Document document = FileUtilities.getDocument(xmlFile);
            if (document != null) {
                NodeList elementList = document.getElementsByTagName("jca-adapter");
                for (int i = 0; i < elementList.getLength(); ++i) {
                    Element jcaAdapter = (Element)elementList.item(i);
                    if (!jcaAdapter.hasAttribute("activation-spec-binding-name")) continue;
                    String activationSpecName = jcaAdapter.getAttribute("activation-spec-binding-name");
                    String destinationName = jcaAdapter.getAttribute("destination-binding-name");
                    String activationSpecAuthAlias = jcaAdapter.getAttribute("activation-spec-auth-alias");
                    if (!"".equals(activationSpecName)) {
                        ReportUtility.logger.get().log(Level.FINEST, "Adding Activation Spec Name for app " + appName + ": " + activationSpecName + " from file " + xmlFile);
                        usedIdentifierNames.add(activationSpecName);
                    }
                    if (!"".equals(destinationName)) {
                        ReportUtility.logger.get().log(Level.FINEST, "Adding Destination JNDI Name for app " + appName + ": " + destinationName + " from file " + xmlFile);
                        usedIdentifierNames.add(destinationName);
                    }
                    if ("".equals(activationSpecAuthAlias)) continue;
                    ReportUtility.logger.get().log(Level.FINEST, "Adding Activation Spec Auth Alias Name for app " + appName + ": " + activationSpecAuthAlias + " from file " + xmlFile);
                    usedIdentifierNames.add(activationSpecAuthAlias);
                }
            }
        }
        catch (Exception e) {
            ReportUtility.logger.get().log(Level.FINE, "Caught exception in scanIBMBindingsXMLActivationSpecBindings for file " + xmlFile + " for app " + appName + ". Exception " + e);
        }
    }

    private static void scanForElementsWithAttribute(File xmlFile, String elementName, String attributeName, Set<String> usedIdentifierNames, String appName) {
        try {
            Document document = FileUtilities.getDocument(xmlFile);
            if (document != null) {
                NodeList elementList = document.getElementsByTagName(elementName);
                for (int i = 0; i < elementList.getLength(); ++i) {
                    Element elem = (Element)elementList.item(i);
                    String jndiName = elem.getAttribute(attributeName);
                    ReportUtility.logger.get().log(Level.FINEST, "Adding used JNDI Name for app " + appName + ": " + jndiName + " from file " + xmlFile);
                    usedIdentifierNames.add(jndiName);
                }
            }
        }
        catch (Exception e) {
            ReportUtility.logger.get().log(Level.FINE, "Caught exception in scanForElementsWithAttribute for file: " + xmlFile + ", element: " + elementName + ", attribute: " + attributeName + ", app: " + appName + ". Exception " + e);
        }
    }

    private static void scanIBMBindingsXMIActivationSpecBindings(File xmlFile, Set<String> usedIdentifierNames, String appName) {
        try {
            Document document = FileUtilities.getDocument(xmlFile);
            if (document != null) {
                NodeList elementList = document.getElementsByTagName("ejbBindings");
                for (int i = 0; i < elementList.getLength(); ++i) {
                    Element messageDestinationRef = (Element)elementList.item(i);
                    String activationSpecName = messageDestinationRef.getAttribute("activationSpecJndiName");
                    String destinationName = messageDestinationRef.getAttribute("destinationJndiName");
                    if (!"".equals(activationSpecName)) {
                        ReportUtility.logger.get().log(Level.FINEST, "Adding Activation Spec JNDI Name for app " + appName + ": " + activationSpecName + " from file " + xmlFile);
                        usedIdentifierNames.add(activationSpecName);
                    }
                    if ("".equals(destinationName)) continue;
                    ReportUtility.logger.get().log(Level.FINEST, "Adding Destination JNDI Name for app " + appName + ": " + destinationName + " from file " + xmlFile);
                    usedIdentifierNames.add(destinationName);
                }
            }
        }
        catch (Exception e) {
            ReportUtility.logger.get().log(Level.FINE, "Caught exception in scanIBMBindingsXMIActivationSpecBindings for file " + xmlFile + " for app " + appName + ". Exception " + e);
        }
    }

    private static void scanMergedXMLJndiBindings(File xmlFile, String elementName, String childName, Set<String> usedIdentifierNames, String appName) {
        try {
            Document document = FileUtilities.getDocument(xmlFile);
            if (document != null) {
                NodeList elementList = document.getElementsByTagName(elementName);
                for (int i = 0; i < elementList.getLength(); ++i) {
                    Element messageDestinationRef = (Element)elementList.item(i);
                    String elementNameValue = "";
                    String lookupName = "";
                    NodeList children = messageDestinationRef.getChildNodes();
                    for (int j = 0; j < children.getLength(); ++j) {
                        Node childElement = children.item(j);
                        String childElementName = childElement.getNodeName();
                        if (childName.equals(childElementName)) {
                            elementNameValue = childElement.getTextContent();
                            continue;
                        }
                        if (!"lookup-name".contentEquals(childElementName)) continue;
                        lookupName = childElement.getTextContent();
                    }
                    String jndiName = lookupName == null || "".equals(lookupName) ? elementNameValue : lookupName;
                    ReportUtility.logger.get().log(Level.FINEST, "Adding used JNDI Name for app " + appName + ": " + jndiName + " from file " + xmlFile);
                    usedIdentifierNames.add(jndiName);
                }
            }
        }
        catch (Exception e) {
            ReportUtility.logger.get().log(Level.FINE, "Caught exception in scanMergedXMLJndiBindings for file: " + xmlFile + ", element: " + elementName + ", child: " + childName + ", app: " + appName + ". Exception " + e);
        }
    }

    private static void scanIBMBindingsXMIAuthData(File xmlFile, Set<String> usedIdentifierNames, String appName) {
        try {
            Document document = FileUtilities.getDocument(xmlFile);
            if (document != null) {
                NodeList elementList = document.getElementsByTagName("properties");
                for (int i = 0; i < elementList.getLength(); ++i) {
                    Element elem = (Element)elementList.item(i);
                    if (!"com.ibm.mapping.authDataAlias".equals(elem.getAttribute("name"))) continue;
                    String authData = elem.getAttribute("value");
                    ReportUtility.logger.get().log(Level.FINEST, "Adding used JNDI Name for app " + appName + ": " + authData + " from file " + xmlFile);
                    usedIdentifierNames.add(authData);
                }
            }
        }
        catch (Exception e) {
            ReportUtility.logger.get().log(Level.FINE, "Caught exception in scanIBMBindingsXMIAuthData for file " + xmlFile + " for app " + appName + ". Exception " + e);
        }
    }
}

