/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.configutility.resource;

import com.ibm.ws.report.binary.configutility.LibertyResource;
import com.ibm.ws.report.binary.configutility.Scope;
import com.ibm.ws.report.binary.configutility.mutableconfig.MappedDataHelper;
import com.ibm.ws.report.binary.configutility.mutableconfig.SensitiveDataHelper;
import com.ibm.ws.report.binary.configutility.resource.J2EEResourceProperty;
import com.ibm.ws.report.binary.configutility.resource.J2EEResourceProvider;
import java.util.Arrays;
import java.util.List;
import java.util.SortedMap;

public class J2EEResourceFactory
implements LibertyResource {
    private final String _name;
    private final String _jndiName;
    private final String _description;
    private final String _category;
    private final String _providerType;
    private final String _xmiId;
    private final J2EEResourceProvider _provider;
    private final String _libertyId;
    private final SortedMap<String, J2EEResourceProperty> _propertySet;
    static final List<String> commonSensitiveProperties = Arrays.asList("password", "userName", "user", "accessToken", "apiKey", "keyStoreSecret", "trustStorePassword", "sslTrustStorePassword", "sslKeyStorePassword", "connectionProperties", "connectionFactoryProperties");
    static final List<String> commonMappedProperties = Arrays.asList("databaseName", "clientId", "channel", "hostName", "port", "baseQueueName", "queueManager", "busName", "localAddress", "queueName", "remoteServerAddress", "ccdtURL", "clientHostName", "clientUser", "databaseServer", "URL", "portNumber", "serverName", "clientRerouteAlternatePortNumber", "clientRerouteAlternateServerName", "alternateServers", "alternateGroupDatabaseName", "alternateGroupPortNumber", "alternateGroupServerName", "ifxIFXHOST");

    public static void registerPropertiesForJEEResourceType(String jeeResourceType, List<String> jeeResourceSpecificSensitiveProperties, List<String> jeeResourceSpecificMappedProperties) {
        for (String prop : commonSensitiveProperties) {
            SensitiveDataHelper.registerMappedPropertyNamebyClass(jeeResourceType, prop.toLowerCase());
        }
        for (String prop : jeeResourceSpecificSensitiveProperties) {
            SensitiveDataHelper.registerMappedPropertyNamebyClass(jeeResourceType, prop.toLowerCase());
        }
        for (String prop : commonMappedProperties) {
            MappedDataHelper.registerMappedPropertyNamebyClass(jeeResourceType, prop.toLowerCase());
        }
        for (String prop : jeeResourceSpecificMappedProperties) {
            MappedDataHelper.registerMappedPropertyNamebyClass(jeeResourceType, prop.toLowerCase());
        }
    }

    public J2EEResourceFactory(String name2, String jndiName, String description, String category, String providerType, J2EEResourceProvider provider, SortedMap<String, J2EEResourceProperty> propertySet, String xmiId, Scope scope) {
        this._name = name2;
        this._jndiName = jndiName;
        this._description = description;
        this._category = category;
        this._providerType = providerType;
        this._provider = provider;
        this._propertySet = propertySet;
        this._xmiId = xmiId;
        this._libertyId = name2 + "_" + scope.getNameForId() + "_" + xmiId;
    }

    public String getName() {
        return this._name;
    }

    public String getJndiName() {
        return this._jndiName;
    }

    public String getDescription() {
        return this._description;
    }

    public String getCategory() {
        return this._category;
    }

    public String getProviderType() {
        return this._providerType;
    }

    public J2EEResourceProvider getProvider() {
        return this._provider;
    }

    public String getXmiId() {
        return this._xmiId;
    }

    public SortedMap<String, J2EEResourceProperty> getPropertySet() {
        return this._propertySet;
    }

    public String toString() {
        String nl = System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder();
        sb.append("J2EEResourceFactory: name=\"" + this._name + "\"" + nl);
        sb.append("xmiId=\"" + this._xmiId + "\"" + nl);
        sb.append("libertyId=\"" + this._libertyId + "\"" + nl);
        sb.append("jndiName=\"" + this._jndiName + "\"" + nl);
        sb.append("description=\"" + this._description + "\"" + nl);
        sb.append("category=\"" + this._category + "\"" + nl);
        sb.append("providerType=\"" + this._providerType + "\"" + nl);
        sb.append("Provider: " + (this._provider != null ? this._provider.getName() : null) + nl);
        sb.append("Properties: " + nl);
        if (this._propertySet != null) {
            for (J2EEResourceProperty prop : this._propertySet.values()) {
                sb.append(prop + nl);
            }
        }
        return sb.toString();
    }

    @Override
    public String getLibertyId() {
        return this._libertyId;
    }
}

