/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.configutility.generator;

import com.ibm.ws.report.binary.configutility.ScopedMap;
import com.ibm.ws.report.binary.configutility.Variable;
import com.ibm.ws.report.binary.configutility.twas.Apps;
import com.ibm.ws.report.utilities.ReportUtility;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileMigrationUtilities {
    private static final Set<String> usedFileNames = new HashSet<String>();

    public static String createNewFileName(String appName, String oldFileName, String managementScope, String configElementName, String migratedConfigDirPath) {
        int maxLength;
        int pathLength = migratedConfigDirPath == null ? 0 : migratedConfigDirPath.length();
        String oldFileNameNoPath = oldFileName;
        if (oldFileName.contains("/")) {
            oldFileNameNoPath = oldFileName.substring(oldFileName.lastIndexOf("/") + 1);
        } else if (oldFileName.contains("\\")) {
            oldFileNameNoPath = oldFileName.substring(oldFileName.lastIndexOf("\\") + 1);
        }
        String managementScopeName = "";
        String[] scopes = managementScope.split(":");
        managementScopeName = scopes.length <= 1 ? managementScope : scopes[scopes.length - 1];
        int currentLength = appName.length() + managementScopeName.length() + configElementName.length() + oldFileNameNoPath.length();
        String result = "";
        String osName = System.getProperty("os.name");
        boolean isWindows = osName == null || osName.toLowerCase().startsWith("windows");
        int n = maxLength = isWindows ? 245 - pathLength : 245;
        if (currentLength >= maxLength) {
            if ((currentLength -= managementScopeName.length()) >= maxLength) {
                if ((currentLength -= configElementName.length()) <= maxLength) {
                    result = appName + "_";
                }
            } else {
                result = appName + "_" + configElementName + "_";
            }
        } else {
            result = appName + "_" + managementScopeName + "_" + configElementName + "_";
        }
        result = result.replaceAll("[^a-zA-Z0-9-]", "_");
        result = result.replaceAll("_+", "_");
        if (usedFileNames.contains(result = result + oldFileNameNoPath)) {
            String extension;
            String name2;
            if (result.contains(".")) {
                name2 = result.substring(0, result.lastIndexOf("."));
                extension = result.substring(result.lastIndexOf("."));
            } else {
                name2 = result;
                extension = "";
            }
            int i = 1;
            while (usedFileNames.contains(result)) {
                result = name2 + "_" + i + extension;
                ++i;
            }
        }
        usedFileNames.add(result);
        return result;
    }

    public static String resolveVariablesInPath(Apps.App app, String path, File profileDir) {
        ScopedMap<Variable> variables = app.getVariables();
        Pattern p = Pattern.compile("\\$\\{[^}]+}");
        Matcher m = p.matcher(path);
        String result = path;
        while (m.find()) {
            String variableToBeReplaced = m.group();
            if (variableToBeReplaced != null) {
                String varNameWithoutBrackets = variableToBeReplaced.substring(2, variableToBeReplaced.length() - 1);
                Variable value = variables.getIgnoreScopeConflicts(varNameWithoutBrackets);
                if (value != null) {
                    result = m.replaceFirst(value.getValue());
                } else if ("CONFIG_ROOT".equals(varNameWithoutBrackets)) {
                    String pathToProfileConfig = profileDir.getAbsolutePath() + File.separator + "config";
                    pathToProfileConfig = pathToProfileConfig.replace("\\", "\\\\");
                    result = m.replaceFirst(pathToProfileConfig);
                } else {
                    ReportUtility.logger.get().log(Level.FINE, "Unable to resolve variable " + variableToBeReplaced + " in path " + result);
                    break;
                }
            }
            m = p.matcher(result);
        }
        return result;
    }

    public static void clearUsedFileNames() {
        usedFileNames.clear();
    }
}

