/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.cmdline.ta.nls;

import com.ibm.ws.report.binary.cmdline.Messages;
import com.ibm.ws.report.binary.cmdline.ta.nls.TALocale;
import com.ibm.ws.report.binary.cmdline.ta.nls.TALocaleException;
import com.ibm.ws.report.utilities.ReportUtility;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;

public class NLSUtils {
    public static void logInfoMsg(Locale locale, String msgID, Object ... args) {
        try {
            if (ReportUtility.logger.get().getLevel().intValue() <= Level.INFO.intValue()) {
                ReportUtility.logger.get().log(Level.INFO, NLSUtils.format(locale, msgID, args));
            }
        }
        catch (MissingResourceException e) {
            e.printStackTrace(System.out);
            ReportUtility.logger.get().log(Level.SEVERE, Messages.getFormattedMessage("fail to log ", e));
            ReportUtility.logger.get().log(Level.SEVERE, Messages.getFormattedMessage(NLSUtils.formatError("ta.dc.globalization.key.error", msgID), e));
        }
    }

    public static String format(String msgID) {
        return NLSUtils.format(null, msgID);
    }

    public static String format(Locale locale, String msgID) {
        String msg = null;
        try {
            msg = NLSUtils.getResourceBundle(locale).getString(msgID);
        }
        catch (MissingResourceException e) {
            msg = msgID;
        }
        return msg;
    }

    public static String formatUsingLocaleString(String localeStr, String msgID) {
        String msg = null;
        try {
            TALocale taLocale = new TALocale(localeStr);
            Locale locale = taLocale.toLocale();
            msg = NLSUtils.getResourceBundle(locale).getString(msgID);
        }
        catch (MissingResourceException e) {
            msg = msgID;
        }
        catch (TALocaleException e) {
            msg = msgID;
        }
        return msg;
    }

    public static String format(Locale locale, String msgID, Object ... args) {
        String msg = null;
        try {
            String msgTemplate = NLSUtils.getResourceBundle(locale).getString(msgID);
            msg = NLSUtils.formatMsg(msgTemplate, args);
        }
        catch (MissingResourceException e) {
            ReportUtility.logger.get().log(Level.SEVERE, Messages.getFormattedMessage(NLSUtils.formatError("ta.dc.globalization.key.error", msgID), e));
            msg = NLSUtils.formatError(msgID, args);
        }
        return msg;
    }

    public static String formatMsg(String msg, Object ... args) {
        String str = null;
        try {
            str = MessageFormat.format(msg, args);
        }
        catch (IllegalArgumentException e) {
            ReportUtility.logger.get().log(Level.SEVERE, Messages.getFormattedMessage(NLSUtils.formatError("ta.dc.globalization.format.error", msg), e));
            str = NLSUtils.formatError(msg, args);
        }
        return str;
    }

    public static String formatError(String msg, Object ... args) {
        String str = null;
        try {
            str = MessageFormat.format(msg, args);
        }
        catch (IllegalArgumentException e) {
            StringBuilder strBld = new StringBuilder("    ");
            strBld.append(msg);
            int i = 0;
            for (Object arg : args) {
                strBld.append(System.getProperty("line.separator"));
                strBld.append("        ");
                strBld.append(i++);
                strBld.append(" = ");
                strBld.append(arg);
            }
            str = strBld.toString();
        }
        return str;
    }

    protected static ResourceBundle getResourceBundle(Locale requestedLocale) {
        ResourceBundle bundle = null;
        if (requestedLocale == null) {
            ReportUtility.logger.get().log(Level.FINE, Messages.getFormattedMessage("requestedLocale is null, return bundle using default locale: ", bundle));
            bundle = NLSUtils.getDefaultResourceBundle();
        } else {
            bundle = ResourceBundle.getBundle("com.ibm.ws.report.binary.cmdline.messages", requestedLocale);
            if (bundle == null) {
                bundle = NLSUtils.getDefaultResourceBundle();
                ReportUtility.logger.get().log(Level.FINE, Messages.getFormattedMessage("can not find bundle using requestedLocale: " + requestedLocale + " return bundle using default locale:", bundle));
            }
        }
        return bundle;
    }

    protected static ResourceBundle getDefaultResourceBundle() {
        return ResourceBundle.getBundle("com.ibm.ws.report.binary.cmdline.messages", new Locale("en"));
    }
}

