/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.asm.utilities;

public class AnnotationInfo {
    private String _name = null;
    private String _type = null;
    private String _attributeName = null;
    private Object _attributeValue = null;
    private String _reference = null;
    private int _lineNumber = 0;

    public AnnotationInfo(String name2, String attributeName, String attributeValue, String type, String reference, int lineNumber) {
        this._name = name2;
        this._type = type;
        this._attributeName = attributeName;
        this._attributeValue = attributeValue;
        this._reference = reference;
        this._lineNumber = lineNumber;
    }

    public AnnotationInfo(String name2, String attributeName, Object attributeValue, String reference, int lineNumber) {
        this._name = name2;
        this._type = attributeValue.getClass().getName();
        this._attributeName = attributeName;
        this._attributeValue = attributeValue;
        this._reference = reference;
        this._lineNumber = lineNumber;
    }

    public boolean matches(String attributeName, String type, String[] values) {
        boolean flag = false;
        if (this._attributeName != null && this._attributeName.matches(attributeName) && type.equals(this._type)) {
            if (values != null) {
                String[] stringArray = values;
                int n = values.length;
                int n2 = 0;
                while (n2 < n) {
                    String value = stringArray[n2];
                    if (this._attributeValue != null && this._attributeValue.toString().matches(value)) {
                        flag = true;
                        break;
                    }
                    ++n2;
                }
            } else if (this._attributeValue == null) {
                flag = true;
            }
        }
        return flag;
    }

    public boolean matches(String attributeName, String type) {
        boolean flag = false;
        if (this._attributeName != null && this._attributeName.matches(attributeName) && type.equals(this._type)) {
            flag = true;
        }
        return flag;
    }

    public String getName() {
        return this._name;
    }

    public String getType() {
        return this._type;
    }

    public int getLineNumber() {
        return this._lineNumber;
    }

    public String getReference() {
        return this._reference;
    }

    public String getAttributeName() {
        return this._attributeName;
    }

    public String getAttributeValue() {
        return this._attributeValue.toString();
    }
}

