/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.asm.utilities;

import com.ibm.ws.report.binary.Messages;
import com.ibm.ws.report.binary.asm.utilities.AnnotationInfo;
import com.ibm.ws.report.utilities.ReportUtility;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;

public class AnnotationDetails {
    private static boolean DEBUG = false;
    private String _name = null;
    private String _reference = null;
    private int _lineNumber = 0;
    private int _referenceType = -1;
    private String _locationClass = null;
    private String _methodSignature = null;
    private final List<AnnotationInfo> _annotationInformation = new ArrayList<AnnotationInfo>();
    public static final int CLASS_ANNOTATION = 0;
    public static final int METHOD_ANNOTATION = 1;
    public static final int FIELD_ANNOTATION = 2;
    public static final int TYPE_ANNOTATION = 3;
    public static final int INTERFACE_ANNOTATION = 4;

    public AnnotationDetails(String name2, String reference, int lineNumber, int referenceType) {
        this._name = name2;
        this._referenceType = referenceType;
        this._reference = reference;
        this._lineNumber = lineNumber;
    }

    public void addOccurrence(String attributeName, String type, String attributeValue, String reference, int lineNumber) {
        if (reference == null) {
            reference = this.getReferenceTypeDescription();
        }
        ReportUtility.logger.get().log(Level.FINEST, "AnnotationDetails.addOccurrence for name: " + this._name + " attributeName: " + attributeName + System.getProperty("line.separator") + "     reference: " + reference + " line: " + lineNumber);
        AnnotationInfo ai = new AnnotationInfo(this._name, attributeName, attributeValue, type, reference, lineNumber);
        this._annotationInformation.add(ai);
    }

    public void addOccurrence(String attributeName, Object attributeValue, String reference, int lineNumber) {
        if (reference == null) {
            reference = this.getReferenceTypeDescription();
        }
        ReportUtility.logger.get().log(Level.FINEST, "AnnotationDetails.addOccurrence for name: " + this._name + " attributeName: " + attributeName + System.getProperty("line.separator") + "     reference: " + reference + " line: " + lineNumber);
        AnnotationInfo ai = new AnnotationInfo(this._name, attributeName, attributeValue, reference, lineNumber);
        this._annotationInformation.add(ai);
    }

    public String getName() {
        return this._name;
    }

    public Set<AnnotationInfo> getAnnotationInformation(String type) {
        HashSet<AnnotationInfo> ais = new HashSet<AnnotationInfo>();
        for (AnnotationInfo ai : this._annotationInformation) {
            if (!ai.getType().equals(type)) continue;
            ais.add(ai);
        }
        return ais;
    }

    public List<AnnotationInfo> getAnnotationInformation() {
        return this._annotationInformation;
    }

    public boolean containsAttributeName(String attributeName) {
        for (AnnotationInfo ai : this._annotationInformation) {
            if (!attributeName.equals(ai.getAttributeName())) continue;
            return true;
        }
        return false;
    }

    public boolean containsAttributeValue(String attributeName, String attributeValue) {
        for (AnnotationInfo ai : this._annotationInformation) {
            if (!attributeName.equals(ai.getAttributeName()) || !attributeValue.equals(ai.getAttributeValue())) continue;
            return true;
        }
        return false;
    }

    public int getReferenceType() {
        return this._referenceType;
    }

    public int getLineNumber() {
        return this._lineNumber;
    }

    public String getReference() {
        return this._reference;
    }

    public String getLocationClass() {
        return this._locationClass;
    }

    public String getMethodSignature() {
        return this._methodSignature;
    }

    public void setMethodSignature(String methodSignature) {
        this._methodSignature = methodSignature;
    }

    public void setLocationClass(String _locationClass) {
        this._locationClass = _locationClass;
    }

    public String getReferenceTypeDescription() {
        String desc = null;
        switch (this._referenceType) {
            case 0: {
                desc = Messages.getString("Report_Reference_Class_Annotation");
                break;
            }
            case 1: {
                desc = Messages.getString("Report_Reference_Annotation");
                break;
            }
            case 2: {
                desc = Messages.getString("Report_Reference_Field_Annotation");
                break;
            }
            case 3: {
                desc = Messages.getString("Report_Reference_Type_Annotation");
                break;
            }
            case 4: {
                desc = Messages.getString("Report_Reference_Interface_Annotation");
            }
        }
        return desc;
    }
}

