/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.appserver.tools.jaxrpc.common.data;

import com.ibm.websphere.appserver.tools.jaxrpc.common.ArchiveResources;
import com.ibm.websphere.appserver.tools.jaxrpc.common.data.WSDLResource;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class WSDLResources {
    public static final String BASE_WSIMPORT_DIR = "jaxrpc-tools-wsimport";
    public static final String WSIMPORT_SERVICE_DIR = "jaxrpc-tools-wsimport" + File.separator + "service";
    public static final String WSIMPORT_CLIENT_DIR = "jaxrpc-tools-wsimport" + File.separator + "client";
    private ArchiveResources archiveResource;
    private Map<String, WSDLResource> serviceWsdls = new HashMap<String, WSDLResource>();
    private Map<String, WSDLResource> clientWsdls = new HashMap<String, WSDLResource>();
    private Map<File, WSDLResource> serviceMigrateDirs = new HashMap<File, WSDLResource>();
    private Map<File, WSDLResource> clientMigrateDirs = new HashMap<File, WSDLResource>();

    public WSDLResources(ArchiveResources ar) {
        this.archiveResource = ar;
    }

    public boolean hasService() {
        return !this.serviceWsdls.isEmpty();
    }

    public boolean hasClient() {
        return !this.clientWsdls.isEmpty();
    }

    @Deprecated
    public Set<String> getAllWsdlPaths() {
        HashSet<String> union = new HashSet<String>(this.getClientWsdlPaths());
        union.addAll(this.getServiceWsdlPaths());
        return union;
    }

    @Deprecated
    public Set<String> getServiceWsdlPaths() {
        return this.serviceWsdls.keySet();
    }

    @Deprecated
    public Set<String> getClientWsdlPaths() {
        return this.clientWsdls.keySet();
    }

    public Set<WSDLResource> getAllWsdls() {
        HashSet<WSDLResource> union = new HashSet<WSDLResource>(this.getClientWsdls());
        union.addAll(this.getServiceWsdls());
        return union;
    }

    public Collection<WSDLResource> getServiceWsdls() {
        return this.serviceWsdls.values();
    }

    public Collection<WSDLResource> getClientWsdls() {
        return this.clientWsdls.values();
    }

    public Set<WSDLResource> getAllWsdls_files() {
        return this.isFileOrURLFilter(this.getAllWsdlMap(), true);
    }

    public Set<WSDLResource> getServiceWsdls_files() {
        return this.isFileOrURLFilter(this.serviceWsdls, true);
    }

    public Set<WSDLResource> getClientWsdls_files() {
        return this.isFileOrURLFilter(this.clientWsdls, true);
    }

    public Set<WSDLResource> getAllWsdls_URL() {
        return this.isFileOrURLFilter(this.getAllWsdlMap(), false);
    }

    public Set<WSDLResource> getServiceWsdls_URL() {
        return this.isFileOrURLFilter(this.serviceWsdls, false);
    }

    public Set<WSDLResource> getClientWsdls_URL() {
        return this.isFileOrURLFilter(this.clientWsdls, false);
    }

    private Set<WSDLResource> isFileOrURLFilter(Map<String, WSDLResource> wsdlMap, boolean isFile) {
        HashSet<WSDLResource> collectionSet = new HashSet<WSDLResource>();
        for (WSDLResource wsdlResource : wsdlMap.values()) {
            if ((!isFile || !wsdlResource.isFile()) && (isFile || !wsdlResource.isURL())) continue;
            collectionSet.add(wsdlResource);
        }
        return collectionSet;
    }

    private Map<String, WSDLResource> getAllWsdlMap() {
        Map<String, WSDLResource> union = this.serviceWsdls;
        union.putAll(this.clientWsdls);
        return union;
    }

    public Map<String, WSDLResource> getServiceWsdlMap() {
        return this.serviceWsdls;
    }

    public Map<String, WSDLResource> getClientWsdlMap() {
        return this.clientWsdls;
    }

    public boolean isServiceWsdl(WSDLResource wsdl) {
        return this.serviceWsdls.values().contains(wsdl);
    }

    public boolean isClientWsdl(WSDLResource wsdl) {
        return this.clientWsdls.values().contains(wsdl);
    }

    public WSDLResource addServiceWsdl(String wsdl, String wsdlReferenceFile) throws Exception {
        WSDLResource resource = WSDLResource.createServiceWsdl(wsdl, wsdlReferenceFile);
        this.serviceWsdls.put(wsdl, resource);
        return resource;
    }

    public WSDLResource addClientWsdl(String wsdl, String wsdlReferenceFile) throws Exception {
        WSDLResource resource = WSDLResource.createClientWsdl(wsdl, wsdlReferenceFile);
        this.clientWsdls.put(wsdl, resource);
        return resource;
    }

    public String getGeneratedWsImportDirName(File wsimportDir) throws Exception {
        if (this.serviceMigrateDirs.containsKey(wsimportDir)) {
            return this.serviceMigrateDirs.get(wsimportDir).getGeneratedPortionOfPath();
        }
        if (this.clientMigrateDirs.containsKey(wsimportDir)) {
            return this.clientMigrateDirs.get(wsimportDir).getGeneratedPortionOfPath();
        }
        return null;
    }

    public String getServiceMigrateDirPath(String wsdlPath) {
        return this.serviceWsdls.get(wsdlPath).getWsImportDirPath();
    }

    public String getClientMigrateDirPath(String wsdlPath) {
        return this.clientWsdls.get(wsdlPath).getWsImportDirPath();
    }

    public void consolidate(WSDLResources wr) {
        this.serviceWsdls.putAll(wr.getServiceWsdlMap());
        this.clientWsdls.putAll(wr.getClientWsdlMap());
    }

    public Set<File> getAllMigrateDirs() {
        HashSet<File> allMigrateDirs = new HashSet<File>(this.serviceMigrateDirs.keySet());
        allMigrateDirs.addAll(this.clientMigrateDirs.keySet());
        return allMigrateDirs;
    }

    public boolean checkIfServiceMigrateDir(File importDir) {
        return this.serviceMigrateDirs.containsKey(importDir);
    }

    public Set<File> getServiceMigrateDirs() {
        return this.serviceMigrateDirs.keySet();
    }

    public void addServiceMigrateDir(File migrateDir, WSDLResource wsdl) throws IOException {
        this.serviceMigrateDirs.put(migrateDir, wsdl);
        String migrateDirPath = migrateDir.getCanonicalPath();
        for (ArchiveResources ar : this.archiveResource.getContainedArchives()) {
            if (!migrateDirPath.startsWith(ar.getExpandedResourceDirectoryPath())) continue;
            ar.addServiceMigrateDir(migrateDir, wsdl);
        }
    }

    public boolean checkIfClientMigrateDir(File importDir) {
        return this.clientMigrateDirs.containsKey(importDir);
    }

    public Set<File> getClientMigrateDirs() {
        return this.clientMigrateDirs.keySet();
    }

    public void addClientMigrateDir(File migrateDir, WSDLResource wsdl) throws IOException {
        this.clientMigrateDirs.put(migrateDir, wsdl);
        String migrateDirPath = migrateDir.getCanonicalPath();
        for (ArchiveResources ar : this.archiveResource.getContainedArchives()) {
            if (!migrateDirPath.startsWith(ar.getExpandedResourceDirectoryPath())) continue;
            ar.addClientMigrateDir(migrateDir, wsdl);
        }
    }
}

