/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.json.java;

import com.ibm.json.java.JSONArtifact;
import com.ibm.json.java.JSONObject;
import com.ibm.json.java.internal.Serializer;
import com.ibm.json.java.internal.SerializerVerbose;
import java.io.BufferedWriter;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class JSONArray
extends ArrayList
implements JSONArtifact {
    private static final long serialVersionUID = 9076798781015779954L;

    public JSONArray() {
    }

    public JSONArray(int n) {
        super(n);
    }

    public void add(int n, Object object) {
        this.checkElement(object);
        super.add(n, object);
    }

    public boolean add(Object object) {
        this.checkElement(object);
        return super.add(object);
    }

    public boolean addAll(Collection collection) {
        this.checkElements(collection);
        return super.addAll(collection);
    }

    public boolean addAll(int n, Collection collection) {
        this.checkElements(collection);
        return super.addAll(n, collection);
    }

    public Object set(int n, Object object) {
        this.checkElement(object);
        return super.set(n, object);
    }

    public static JSONArray parse(InputStream inputStream) throws IOException {
        InputStreamReader inputStreamReader = null;
        try {
            inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
        }
        catch (Exception exception) {
            inputStreamReader = new InputStreamReader(inputStream);
        }
        return JSONArray.parse(inputStreamReader);
    }

    public static JSONArray parse(Reader reader) throws IOException {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("{\"jsonArray\":");
        char[] cArray = new char[8196];
        int n = 0;
        n = reader.read(cArray, 0, 8196);
        while (n != -1) {
            stringBuffer.append(cArray, 0, n);
            n = reader.read(cArray, 0, 8196);
        }
        stringBuffer.append("}");
        JSONObject jSONObject = JSONObject.parse(stringBuffer.toString());
        return (JSONArray)jSONObject.get("jsonArray");
    }

    public static JSONArray parse(String string) throws IOException {
        StringReader stringReader = new StringReader(string);
        return JSONArray.parse(stringReader);
    }

    public void serialize(OutputStream outputStream) throws IOException {
        this.serialize(outputStream, false);
    }

    public void serialize(OutputStream outputStream, boolean bl) throws IOException {
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            IOException iOException = new IOException(unsupportedEncodingException.toString());
            iOException.initCause(unsupportedEncodingException);
            throw iOException;
        }
        this.serialize(bufferedWriter, bl);
    }

    public void serialize(Writer writer) throws IOException {
        this.serialize(writer, false);
    }

    public void serialize(Writer writer, boolean bl) throws IOException {
        Class<?> clazz;
        if (!(StringWriter.class.isAssignableFrom(clazz = writer.getClass()) || CharArrayWriter.class.isAssignableFrom(clazz) || BufferedWriter.class.isAssignableFrom(clazz))) {
            writer = new BufferedWriter(writer);
        }
        Serializer serializer = bl ? new SerializerVerbose(writer) : new Serializer(writer);
        serializer.writeArray(this).flush();
    }

    public String serialize(boolean bl) throws IOException {
        StringWriter stringWriter = new StringWriter();
        Serializer serializer = bl ? new SerializerVerbose(stringWriter) : new Serializer(stringWriter);
        serializer.writeArray(this).flush();
        return stringWriter.toString();
    }

    public String serialize() throws IOException {
        return this.serialize(false);
    }

    private void checkElement(Object object) {
        if (!JSONObject.isValidObject(object)) {
            throw new IllegalArgumentException("invalid type of element");
        }
    }

    private void checkElements(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (JSONObject.isValidObject(iterator.next())) continue;
            throw new IllegalArgumentException("invalid type of element");
        }
    }
}

