/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.text_to_speech.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.util.List;

public class SynthesizeOptions
extends GenericModel {
    protected String text;
    protected String accept;
    protected String voice;
    protected String customizationId;
    protected List<String> timings;

    protected SynthesizeOptions(Builder builder) {
        Validator.notNull((Object)builder.text, (String)"text cannot be null");
        this.text = builder.text;
        this.accept = builder.accept;
        this.voice = builder.voice;
        this.customizationId = builder.customizationId;
        this.timings = builder.timings;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String text() {
        return this.text;
    }

    public String accept() {
        return this.accept;
    }

    public String voice() {
        return this.voice;
    }

    public String customizationId() {
        return this.customizationId;
    }

    public List<String> getTimings() {
        return this.timings;
    }

    public static class Builder {
        private String text;
        private String accept;
        private String voice;
        private String customizationId;
        private List<String> timings;

        private Builder(SynthesizeOptions synthesizeOptions) {
            this.text = synthesizeOptions.text;
            this.accept = synthesizeOptions.accept;
            this.voice = synthesizeOptions.voice;
            this.customizationId = synthesizeOptions.customizationId;
            this.timings = synthesizeOptions.timings;
        }

        public Builder() {
        }

        public Builder(String text) {
            this.text = text;
        }

        public SynthesizeOptions build() {
            return new SynthesizeOptions(this);
        }

        public Builder text(String text) {
            this.text = text;
            return this;
        }

        public Builder accept(String accept) {
            this.accept = accept;
            return this;
        }

        public Builder voice(String voice) {
            this.voice = voice;
            return this;
        }

        public Builder customizationId(String customizationId) {
            this.customizationId = customizationId;
            return this;
        }

        public Builder timings(List<String> timings) {
            this.timings = timings;
            return this;
        }
    }

    public static interface Voice {
        public static final String AR_AR_OMARVOICE = "ar-AR_OmarVoice";
        public static final String DE_DE_BIRGITVOICE = "de-DE_BirgitVoice";
        public static final String DE_DE_BIRGITV3VOICE = "de-DE_BirgitV3Voice";
        public static final String DE_DE_DIETERVOICE = "de-DE_DieterVoice";
        public static final String DE_DE_DIETERV3VOICE = "de-DE_DieterV3Voice";
        public static final String EN_GB_KATEVOICE = "en-GB_KateVoice";
        public static final String EN_GB_KATEV3VOICE = "en-GB_KateV3Voice";
        public static final String EN_US_ALLISONVOICE = "en-US_AllisonVoice";
        public static final String EN_US_ALLISONV3VOICE = "en-US_AllisonV3Voice";
        public static final String EN_US_LISAVOICE = "en-US_LisaVoice";
        public static final String EN_US_LISAV3VOICE = "en-US_LisaV3Voice";
        public static final String EN_US_MICHAELVOICE = "en-US_MichaelVoice";
        public static final String EN_US_MICHAELV3VOICE = "en-US_MichaelV3Voice";
        public static final String ES_ES_ENRIQUEVOICE = "es-ES_EnriqueVoice";
        public static final String ES_ES_ENRIQUEV3VOICE = "es-ES_EnriqueV3Voice";
        public static final String ES_ES_LAURAVOICE = "es-ES_LauraVoice";
        public static final String ES_ES_LAURAV3VOICE = "es-ES_LauraV3Voice";
        public static final String ES_LA_SOFIAVOICE = "es-LA_SofiaVoice";
        public static final String ES_LA_SOFIAV3VOICE = "es-LA_SofiaV3Voice";
        public static final String ES_US_SOFIAVOICE = "es-US_SofiaVoice";
        public static final String ES_US_SOFIAV3VOICE = "es-US_SofiaV3Voice";
        public static final String FR_FR_RENEEVOICE = "fr-FR_ReneeVoice";
        public static final String FR_FR_RENEEV3VOICE = "fr-FR_ReneeV3Voice";
        public static final String IT_IT_FRANCESCAVOICE = "it-IT_FrancescaVoice";
        public static final String IT_IT_FRANCESCAV3VOICE = "it-IT_FrancescaV3Voice";
        public static final String JA_JP_EMIVOICE = "ja-JP_EmiVoice";
        public static final String JA_JP_EMIV3VOICE = "ja-JP_EmiV3Voice";
        public static final String NL_NL_EMMAVOICE = "nl-NL_EmmaVoice";
        public static final String NL_NL_LIAMVOICE = "nl-NL_LiamVoice";
        public static final String PT_BR_ISABELAVOICE = "pt-BR_IsabelaVoice";
        public static final String PT_BR_ISABELAV3VOICE = "pt-BR_IsabelaV3Voice";
        public static final String ZH_CN_LINAVOICE = "zh-CN_LiNaVoice";
        public static final String ZH_CN_WANGWEIVOICE = "zh-CN_WangWeiVoice";
        public static final String ZH_CN_ZHANGJINGVOICE = "zh-CN_ZhangJingVoice";
    }
}

