/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxPreparedStatement;
import com.informix.jdbc.IfxSqliConnect;
import com.informix.util.DelayedWeakReference;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.ref.WeakReference;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.DelayQueue;
import org.bson.BSONObject;
import org.bson.BasicBSONObject;

public class PreparedStatementCache
extends LinkedHashMap<String, IfxPreparedStatement> {
    private static final long serialVersionUID = 1L;
    private static final BlockingQueue<DelayedWeakReference<PreparedStatementCache>> queueOfCaches = new DelayQueue<DelayedWeakReference<PreparedStatementCache>>();
    private static final MemoryMXBean memoryBean = ManagementFactory.getMemoryMXBean();
    final transient WeakReference<IfxSqliConnect> connectionWeakReference;
    private int maximumEntries;

    public static List<BSONObject> getCacheInfo() {
        DelayedWeakReference<PreparedStatementCache>[] arrayOfCaches = PreparedStatementCache.getPreparedStatementCaches();
        ArrayList<BSONObject> cacheInfos = new ArrayList<BSONObject>();
        for (DelayedWeakReference<PreparedStatementCache> dwrPsc : arrayOfCaches) {
            PreparedStatementCache psc = (PreparedStatementCache)dwrPsc.get();
            BasicBSONObject cacheInfo = new BasicBSONObject();
            if (psc == null || dwrPsc.isEnqueued()) continue;
            cacheInfo.put("size", (Object)psc.size());
        }
        return cacheInfos;
    }

    public static DelayedWeakReference<PreparedStatementCache>[] getPreparedStatementCaches() {
        return queueOfCaches.toArray(new DelayedWeakReference[0]);
    }

    public static double computeUsedHeapPercentage() {
        long heapUsed = memoryBean.getHeapMemoryUsage().getUsed();
        long heapMax = memoryBean.getHeapMemoryUsage().getMax();
        double percentUsed = (double)(heapUsed * 100L) / (double)heapMax;
        return percentUsed;
    }

    public PreparedStatementCache(IfxSqliConnect connection, int maximumEntries) {
        super(maximumEntries + 1, 1.0f, false);
        this.connectionWeakReference = new WeakReference<IfxSqliConnect>(connection);
        this.maximumEntries = maximumEntries;
        queueOfCaches.offer(new DelayedWeakReference<PreparedStatementCache>(this, 0L));
    }

    public synchronized int getMaximumEntries() {
        return this.maximumEntries;
    }

    public synchronized void setMaximumEntries(int maximumEntries) throws SQLException {
        this.maximumEntries = maximumEntries;
        if (this.size() > maximumEntries) {
            Set keySet = this.keySet();
            Iterator iterator = keySet.iterator();
            ArrayList<String> keysToRemove = new ArrayList<String>();
            int i = 0;
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                if (i >= maximumEntries) {
                    keysToRemove.add(key);
                }
                ++i;
            }
            SQLException exception = null;
            for (String key : keysToRemove) {
                IfxPreparedStatement p = (IfxPreparedStatement)this.remove(key);
                try {
                    p.superClose();
                }
                catch (SQLException e) {
                    if (exception == null) {
                        exception = e;
                        continue;
                    }
                    exception.setNextException(e);
                }
            }
            if (exception != null) {
                throw exception;
            }
        }
    }

    @Override
    protected synchronized boolean removeEldestEntry(Map.Entry<String, IfxPreparedStatement> eldest) {
        if (this.size() > this.maximumEntries) {
            IfxPreparedStatement preparedStatement = eldest.getValue();
            if (preparedStatement != null) {
                try {
                    preparedStatement.superClose();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public synchronized void clear() {
        for (IfxPreparedStatement preparedStatement : this.values()) {
            try {
                if (preparedStatement == null) continue;
                preparedStatement.superClose();
            }
            catch (SQLException sQLException) {}
        }
        super.clear();
    }

    @Override
    public synchronized boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public synchronized int hashCode() {
        return super.hashCode();
    }
}

