/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxBaseType;
import com.informix.jdbc.IfxBblob;
import com.informix.jdbc.IfxCblob;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxLobDescriptor;
import com.informix.jdbc.IfxLobInputStream;
import com.informix.jdbc.IfxLocator;
import com.informix.jdbc.IfxSmartBlob;
import com.informix.jdbc.IfxSqliConnect;
import com.informix.jdbc.IfxTmpFile;
import com.informix.util.IfxErrMsg;
import com.informix.util.TraceFlag;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;

public class IfxSmBlob
extends IfxBaseType {
    private static final short TYPE_IS_BYTE = 0;
    private static final short TYPE_IS_TEXT = 1;
    private static final short TYPE_IS_BLOB = 2;
    private static final short TYPE_IS_CLOB = 3;
    protected static final short BLOB_BUFFER_SIZE = 1024;
    protected static final short LO_READ = 0;
    protected static final short LO_READWITHSEEK = 1;
    protected static final short LO_WRITE = 2;
    protected static final short R_W_BUFSIZE = 32000;
    protected static final short FILE_OPEN = 0;
    protected static final short FILE_CLOSE = 1;
    protected static final short FILE_READ = 2;
    protected static final short FILE_WRITE = 3;
    protected static final int LO_O_EXCL = 1;
    protected static final int LO_O_APPEND = 2;
    protected static final int LO_O_TRUNC = 4;
    protected static final int LO_O_RDWR = 8;
    protected static final int LO_O_RDONLY = 16;
    protected static final int LO_O_WRONLY = 32;
    protected static final int LO_O_BINARY = 64;
    protected static final int LO_O_TEXT = 128;
    protected static final short EIO = 5;
    protected static final short ENOENT = 2;
    protected static final short EBADF = 9;
    protected static final short EACCES = 13;
    protected static final short EEXIST = 17;
    protected static final short ESPIPE = 29;
    protected static final short BLOB_TYPE_BYTES = 1;
    protected static final short BLOB_TYPE_STREAM = 2;
    protected static final short BLOB_TYPE_CHARSTREAM = 3;
    protected boolean LOB_ELEMENT_COLL = false;
    protected IfxLocator locator = null;
    protected int loFd = -1;
    protected long sm_size;
    protected InputStream BlobInputStream;
    protected Reader BlobCharInputStream;
    protected IfxTmpFile tempBlobFile = null;
    protected byte[] blobBuffer;
    protected short blobType;
    protected boolean isBlob_loaded = false;
    protected short IfxSmBlobType = (short)2;
    protected String tableName = null;
    protected String columnName = null;

    public IfxSmBlob() throws SQLException {
    }

    public IfxSmBlob(IfxConnection conn, IfxLocator loc) throws SQLException {
        this.conn = conn;
        this.locator = loc;
        this.isBlob_loaded = false;
        this.blobType = 0;
        this.unnullify();
    }

    public IfxSmBlob(InputStream fin, int length) throws SQLException {
        this.fromInputStream(fin, length);
    }

    public IfxSmBlob(byte[] blobBuffer) throws SQLException {
        this.fromBytes(blobBuffer);
    }

    public IfxSmBlob(Blob blob) throws SQLException {
        this.fromBlob(blob);
        this.IfxSmBlobType = (short)2;
    }

    public IfxSmBlob(Clob clob) throws SQLException {
        this.fromClob(clob);
        this.IfxSmBlobType = (short)3;
    }

    public void setTableName(String tn) {
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxSmBlob.setTableName(String) called");
        }
        int x = 0;
        String temp1 = "";
        String temp2 = "";
        this.tableName = tn != null && tn.indexOf(40) > 0 ? tn.substring(0, tn.indexOf(40)) : tn;
        if (this.tableName != null && (x = this.tableName.indexOf(46)) > 0) {
            temp1 = this.tableName.substring(0, x);
            temp1 = this.toCaseLikeServer(temp1);
            temp2 = this.tableName.substring(x, this.tableName.length());
            this.tableName = temp1.concat(temp2);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxSmBlob.setTableName(String) exit");
        }
    }

    public void setColumnName(String cn) {
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxSmBlob.setTableName(String) called");
        }
        this.columnName = cn;
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxSmBlob.setTableName(String) exit");
        }
    }

    private void getSize() {
        try {
            IfxSmartBlob smb = new IfxSmartBlob(this.conn);
            this.loFd = smb.IfxLoOpen(this.locator, 16);
            this.sm_size = smb.IfxLoSize(this.loFd);
            smb.IfxLoClose(this.loFd);
            smb = null;
        }
        catch (Exception e) {
            this.sm_size = 0L;
        }
    }

    @Override
    public void fromIfx(byte[] b) throws SQLException {
        this.fromIfx(b, 0, b.length);
    }

    @Override
    public void fromIfx(byte[] b, int offset, int length) throws SQLException {
        super.fromIfx(b, offset, length);
        if (!this.isNull()) {
            byte[] tempLoc = this.inputStream.toByteArray();
            this.locator = new IfxLocator(tempLoc, this.conn);
            this.isBlob_loaded = false;
            this.blobType = 0;
            this.unnullify();
        } else {
            this.locator = null;
            this.nullify();
        }
    }

    protected void fromIfxFP(byte[] b) throws SQLException {
        super.fromIfx(b);
        if (!this.isNull()) {
            byte[] tempLoc = this.inputStream.toByteArray();
            this.locator = new IfxLocator(tempLoc, this.conn);
        } else {
            this.locator = null;
            this.nullify();
        }
    }

    @Override
    public byte[] toIfx() throws SQLException {
        this.outputStream.reset();
        if (!this.isNull()) {
            this.outputStream.writeBytes(this.locator.toBytes());
        }
        return super.toIfx();
    }

    @Override
    public byte[] toIfxTuple() throws SQLException {
        this.outputStream.reset();
        if (!this.isNull()) {
            this.outputStream.writeBytes(this.locator.toBytes());
        }
        return super.toIfxTuple();
    }

    @Override
    public InputStream toAsciiStream() throws SQLException {
        if (!this.isBlob_loaded) {
            return new IfxLobInputStream(this.conn, this.locator);
        }
        if (this.tempBlobFile != null) {
            try {
                return this.tempBlobFile.getInputStream();
            }
            catch (Exception e) {
                if (TraceFlag.isTraceEnabled()) {
                    this.writeTrace(99, "IfxBlob:fromCharacterStream(): " + e.getMessage());
                }
                SQLException sqlException = IfxErrMsg.getSQLException(-79701, e.toString(), this.conn);
                sqlException = IfxErrMsg.setSQLExceptionCause(sqlException, e);
                throw sqlException;
            }
        }
        return new ByteArrayInputStream(this.blobBuffer);
    }

    @Override
    public void fromInputStream(InputStream fin, int length) throws SQLException {
        this.fromInputStream(fin, (long)length);
    }

    @Override
    public void fromInputStream(InputStream fi, long len) throws SQLException {
        this.sm_size = len;
        this.BlobInputStream = fi;
        this.isBlob_loaded = false;
        this.blobType = (short)2;
        this.blobBuffer = null;
        this.locator = new IfxLocator(this.conn);
        if (((IfxSqliConnect)this.conn).usePut || this.LOB_ELEMENT_COLL) {
            this.createBlobOnServer(fi, len);
        }
    }

    void createBlobOnServer(Reader r, long length) throws SQLException {
        this.unnullify();
        IfxSmartBlob smb = null;
        try {
            smb = this.createSmartLob();
            this.sm_size = length == -1L ? smb.writeWithConversion(this.loFd, r) : smb.writeWithConversion(this.loFd, r, length);
            if (this.sm_size != length && length > 0L) {
                throw IfxErrMsg.getSQLException(-79754, this.conn);
            }
            if (smb != null && this.loFd != -1) {
                smb.IfxLoClose(this.loFd);
            }
        }
        catch (SQLException e) {
            if (smb != null && this.loFd != -1) {
                try {
                    smb.IfxLoClose(this.loFd);
                }
                catch (SQLException ee) {
                    e.addSuppressed(ee);
                }
            }
            this.sm_size = 0L;
            this.nullify();
            throw e;
        }
    }

    void createBlobOnServer(byte[] bytes) throws SQLException {
        this.createBlobOnServer(bytes, (long)bytes.length);
    }

    void createBlobOnServer(byte[] bytes, long length) throws SQLException {
        this.createBlobOnServer(new ByteArrayInputStream(bytes), length);
    }

    void createBlobOnServer(InputStream is, long length) throws SQLException {
        this.unnullify();
        IfxSmartBlob smb = null;
        try {
            smb = this.createSmartLob();
            if (this.extendedID == 11 && ((IfxSqliConnect)this.conn).isConvText()) {
                if (is == null && this.blobBuffer != null) {
                    is = new ByteArrayInputStream(this.blobBuffer);
                }
                if (length > 0L) {
                    this.sm_size = smb.writeWithConversion(this.loFd, is, length);
                    if (this.sm_size != length) {
                        throw IfxErrMsg.getSQLException(-79754, this.conn);
                    }
                } else if (length == -1L) {
                    this.sm_size = smb.writeWithConversion(this.loFd, is);
                }
            } else if (is == null) {
                smb.IfxLoWrite(this.loFd, this.blobBuffer);
            } else if (length == -1L) {
                this.sm_size = smb.write(this.loFd, is);
            } else if (length > 0L) {
                this.sm_size = smb.write(this.loFd, is, length);
                if (this.sm_size != length) {
                    throw IfxErrMsg.getSQLException(-79754, this.conn);
                }
            }
            if (this.loFd != -1) {
                smb.IfxLoClose(this.loFd);
            }
        }
        catch (SQLException e) {
            if (smb != null && this.loFd != -1) {
                try {
                    smb.IfxLoClose(this.loFd);
                }
                catch (SQLException ee) {
                    e.addSuppressed(ee);
                }
            }
            this.sm_size = 0L;
            this.nullify();
            throw e;
        }
    }

    private IfxSmartBlob createSmartLob() throws SQLException {
        IfxSmartBlob smb = new IfxSmartBlob(this.conn);
        IfxLobDescriptor loDesc = null;
        loDesc = this.tableName == null || this.tableName.isEmpty() || this.columnName == null || this.columnName.isEmpty() ? new IfxLobDescriptor(this.conn) : (((IfxSqliConnect)this.conn).isDelimIdentSet() ? smb.IfxLoColInfo(this.tableName + ".\"" + this.columnName + "\"") : smb.IfxLoColInfo(this.tableName + "." + this.columnName));
        this.loFd = smb.IfxLoCreate(loDesc, 8, this.locator);
        return smb;
    }

    @Override
    public void fromCharacterStream(Reader reader, int length) throws SQLException {
        this.fromCharacterStream(reader, (long)length);
    }

    @Override
    public void fromCharacterStream(Reader reader, long length) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxSmBlob.fromCharacterStream(Reader, long) called");
        }
        this.sm_size = length;
        this.BlobCharInputStream = reader;
        this.isBlob_loaded = false;
        this.blobType = (short)3;
        this.blobBuffer = null;
        this.BlobInputStream = null;
        this.locator = new IfxLocator(this.conn);
        if (((IfxSqliConnect)this.conn).usePut || this.LOB_ELEMENT_COLL) {
            this.createBlobOnServer(reader, length);
        }
        this.IfxSmBlobType = (short)3;
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxSmBlob.fromCharacterStream(Reader, int) exited");
        }
    }

    @Override
    public void fromAsciiStream(InputStream fin, int length) throws SQLException {
        this.fromAsciiStream(fin, (long)length);
    }

    @Override
    public void fromAsciiStream(InputStream fin, long length) throws SQLException {
        this.fromInputStream(fin, length);
        this.IfxSmBlobType = (short)3;
    }

    @Override
    public InputStream toBinaryStream() throws SQLException {
        return this.toAsciiStream();
    }

    @Override
    public void fromBinaryStream(InputStream fin, int length) throws SQLException {
        this.fromBinaryStream(fin, (long)length);
    }

    @Override
    public void fromBinaryStream(InputStream fin, long length) throws SQLException {
        this.fromInputStream(fin, length);
        this.IfxSmBlobType = (short)2;
    }

    @Override
    public String toString() {
        try {
            IfxCblob cb = new IfxCblob(this.conn, this.locator);
            cb.setSize(this.sm_size);
            return cb.getSubString(1L, (int)this.sm_size);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void fromString(String S) throws SQLException {
        if (S == null) {
            this.sm_size = 0L;
            this.blobBuffer = null;
            this.nullify();
            return;
        }
        try {
            String dbEnc = this.conn.getdbEncoding();
            this.blobBuffer = dbEnc != null ? S.getBytes(dbEnc) : S.getBytes();
            this.sm_size = this.blobBuffer.length;
        }
        catch (IOException e) {
            SQLException sqlException = IfxErrMsg.getSQLException(-79783, e.toString(), this.conn);
            sqlException = IfxErrMsg.setSQLExceptionCause(sqlException, e);
            throw sqlException;
        }
        this.BlobInputStream = null;
        this.isBlob_loaded = false;
        this.blobType = 1;
        this.unnullify();
        this.locator = new IfxLocator(this.conn);
    }

    @Override
    public Object toObject() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        if (this.extendedID == 10) {
            return this.toBlob();
        }
        return this.toClob();
    }

    @Override
    public void fromObject(Object obj) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxSmBlob.fromObject(Object) called");
        }
        if (obj == null) {
            if (TraceFlag.isTraceEnabled()) {
                this.writeTrace(2, "    Object is null");
            }
            return;
        }
        if (obj instanceof String) {
            if (TraceFlag.isTraceEnabled()) {
                this.writeTrace(2, "    Object is instance of String");
            }
            this.fromString((String)obj);
        } else if (obj instanceof byte[]) {
            if (TraceFlag.isTraceEnabled()) {
                this.writeTrace(2, "    Object is instance of Byte[]");
            }
            this.fromBytes((byte[])obj);
        } else if (obj instanceof Blob) {
            if (TraceFlag.isTraceEnabled()) {
                this.writeTrace(2, "    Object is instance of Blob");
            }
            this.fromBlob((Blob)obj);
        } else if (obj instanceof Clob) {
            if (TraceFlag.isTraceEnabled()) {
                this.writeTrace(2, "    Object is instance of Clob");
            }
            this.fromClob((Clob)obj);
        } else {
            throw IfxErrMsg.getSQLException(-79791, this.conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxSmBlob.fromObject(Object) exited");
        }
    }

    @Override
    public byte[] toBytes() throws SQLException {
        IfxBblob bb = new IfxBblob(this.conn, this.locator);
        try {
            byte[] byArray = bb.getBytes();
            return byArray;
        }
        finally {
            bb.free();
        }
    }

    @Override
    public void fromBytes(byte[] blobBuffer) throws SQLException {
        if (blobBuffer == null) {
            this.sm_size = 0L;
            this.blobBuffer = null;
            this.nullify();
            return;
        }
        this.sm_size = blobBuffer.length;
        this.blobBuffer = blobBuffer;
        this.unnullify();
        this.BlobInputStream = null;
        this.isBlob_loaded = false;
        this.blobType = 1;
        try {
            this.locator = new IfxLocator(this.conn);
            if (((IfxSqliConnect)this.conn).usePut || this.LOB_ELEMENT_COLL) {
                this.createBlobOnServer(new ByteArrayInputStream(blobBuffer), -1L);
            }
        }
        catch (SQLException e) {
            this.sm_size = 0L;
            this.nullify();
            throw e;
        }
    }

    @Override
    public Blob toBlob() throws SQLException {
        IfxBblob blob = null;
        if (this.isBlob_loaded) {
            if (this.tempBlobFile != null) {
                try {
                    blob = new IfxBblob(this.tempBlobFile);
                }
                catch (Exception e) {
                    SQLException sqlException = IfxErrMsg.getSQLException(-79701, e.toString(), this.conn);
                    sqlException = IfxErrMsg.setSQLExceptionCause(sqlException, e);
                    throw sqlException;
                }
            } else if (this.blobBuffer != null) {
                blob = new IfxBblob(this.blobBuffer);
            }
        } else {
            blob = new IfxBblob(this.conn, this.locator);
        }
        this.sm_size = blob.getLoStat().getSize();
        ((IfxSqliConnect)this.conn).addToBlobList(blob.smb);
        blob.setIfxLobType((short)2);
        blob.setSize(this.sm_size);
        return blob;
    }

    @Override
    public Clob toClob() throws SQLException {
        return this.toClob(this.conn.getLOMode());
    }

    public Clob toClob(int mode) throws SQLException {
        this.getSize();
        IfxCblob clob = null;
        if (this.isBlob_loaded) {
            if (this.tempBlobFile != null) {
                try {
                    clob = new IfxCblob(this.tempBlobFile);
                }
                catch (Exception e) {
                    SQLException sqlException = IfxErrMsg.getSQLException(-79701, e.toString(), this.conn);
                    sqlException = IfxErrMsg.setSQLExceptionCause(sqlException, e);
                    throw sqlException;
                }
            } else if (this.blobBuffer != null) {
                clob = new IfxCblob(this.blobBuffer);
            }
        } else {
            clob = new IfxCblob(this.conn, this.locator, mode);
        }
        ((IfxSqliConnect)this.conn).addToBlobList(clob.smb);
        clob.setIfxLobType((short)3);
        clob.setSize(this.sm_size);
        return clob;
    }

    @Override
    public void fromBlob(Blob blob) throws SQLException {
        if (blob instanceof IfxBblob) {
            IfxBblob b = (IfxBblob)blob;
            short type = b.getIfxLobType();
            if (type == 2) {
                this.locator = b.getLocator();
            } else if (type == 0) {
                this.fromBinaryStream(b.getBinaryStream(), b.length());
            }
        } else {
            this.fromBinaryStream(blob.getBinaryStream(), blob.length());
        }
        this.unnullify();
    }

    @Override
    public void fromClob(Clob clob) throws SQLException {
        if (clob instanceof IfxCblob) {
            IfxCblob b = (IfxCblob)clob;
            short type = b.getIfxLobType();
            if (type == 3) {
                this.locator = b.getLocator();
            } else if (type == 1) {
                this.fromAsciiStream(b.getAsciiStream(), (int)b.length());
            }
        } else {
            this.fromAsciiStream(clob.getAsciiStream(), (int)clob.length());
        }
        this.unnullify();
    }

    @Override
    public void clear() {
        this.nullify();
        this.isBlob_loaded = false;
        this.IfxSmBlobType = (short)2;
        this.blobBuffer = null;
        this.locator = null;
        if (this.tempBlobFile != null) {
            this.tempBlobFile.close();
        }
        this.tempBlobFile = null;
    }

    private String toCaseLikeServer(String tablePattern) {
        if (this.conn.isANSI() && !tablePattern.toUpperCase().equals("INFORMIX")) {
            return tablePattern.toUpperCase();
        }
        return tablePattern.toLowerCase();
    }

    @Override
    public Reader toCharacterStream() throws SQLException {
        Reader r1 = null;
        if (!this.extendedName.toLowerCase().equals("clob")) {
            throw IfxErrMsg.getSQLMinorException(-79741, -80039, this.conn);
        }
        Clob cl = this.toClob();
        r1 = cl.getCharacterStream();
        return r1;
    }
}

