/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfmxResultSet;
import com.informix.jdbc.IfxBSONObject;
import com.informix.jdbc.IfxCollection;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxDateTime;
import com.informix.jdbc.IfxObject;
import com.informix.jdbc.IfxResultSetMetaData;
import com.informix.jdbc.IfxValue;
import com.informix.lang.Interval;
import com.informix.lang.IntervalDF;
import com.informix.lang.IntervalYM;
import com.informix.util.IfxErrMsg;
import com.informix.util.Trace;
import com.informix.util.TraceFlag;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.DataTruncation;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;

public abstract class IfxScrollableResultSet
implements IfmxResultSet {
    private static final Object logger = Trace.getLoggerForClass(IfxScrollableResultSet.class);
    protected IfxResultSetMetaData rsmd = null;
    protected IfxConnection conn = null;
    protected Trace trace = null;
    protected Vector<IfxObject> insertRowVector = null;
    protected Vector<IfxObject> colVector = null;
    protected boolean insertMode = false;
    protected boolean lastColWasNull = false;
    protected Hashtable<String, Integer> nameToIdxTable = null;
    protected boolean delimIdent = false;
    protected Map<String, Class<?>> typeMap = null;
    protected SQLWarning warnings = null;

    IfxScrollableResultSet(IfxConnection conn, ResultSetMetaData rsmd) throws SQLException {
        this.rsmd = (IfxResultSetMetaData)rsmd;
        if (conn != null) {
            this.conn = conn;
            this.trace = conn.getTrace();
            this.typeMap = conn.getTypeMap();
        }
    }

    private IfxObject getValue(int columnIndex) throws SQLException {
        return this.getValue(columnIndex, null);
    }

    private IfxObject getValue(int columnIndex, Calendar cal) throws SQLException {
        IfxObject value;
        Vector<IfxObject> v = null;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxScrollableResultSet.getValue() called");
            this.trace.writeTrace(logger, 2, "   getValue() insertMode: " + this.insertMode);
            this.trace.writeTrace(logger, 2, "   getValue() insertRowVector: " + this.insertRowVector);
            this.trace.writeTrace(logger, 2, "   getValue() colVector: " + this.colVector);
        }
        if ((value = (v = this.getRowVector(columnIndex)).elementAt(columnIndex - 1)) == null) {
            value = IfxValue.makeInstance(this.conn, this.rsmd.getColumnInfo(columnIndex));
            v.setElementAt(value, columnIndex - 1);
        } else if (value instanceof IfxDateTime && !((IfxDateTime)value).isTimeValue()) {
            ((IfxDateTime)value).toTimestampFromRawData(cal);
        }
        this.lastColWasNull = value.isNull();
        return value;
    }

    private Vector<IfxObject> getRowVector(int columnIndex) throws SQLException {
        Vector<IfxObject> v = null;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxScrollableResultSet.getRowVector() called");
            this.trace.writeTrace(logger, 2, "   getValue() insertMode: " + this.insertMode);
            this.trace.writeTrace(logger, 2, "   getValue() insertRowVector: " + this.insertRowVector);
            this.trace.writeTrace(logger, 2, "   getValue() colVector: " + this.colVector);
        }
        try {
            if (this.insertMode) {
                if (this.insertRowVector == null) {
                    if (this.rsmd == null) {
                        throw IfxErrMsg.getSQLException(-79737, this.conn);
                    }
                    this.insertRowVector = new Vector(this.rsmd.getColumnCount());
                    this.insertRowVector.setSize(this.rsmd.getColumnCount());
                }
                v = this.insertRowVector;
            } else {
                if (this.colVector == null) {
                    throw IfxErrMsg.getSQLException(-79739, this.conn);
                }
                v = this.colVector;
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
        if (columnIndex < 1 || columnIndex > v.size()) {
            throw IfxErrMsg.getSQLException(-79703, this.conn);
        }
        return v;
    }

    @Override
    public boolean wasNull() {
        return this.lastColWasNull;
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        Integer idx;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxScrollableResultSet.findColumn() called");
        }
        if (this.nameToIdxTable == null) {
            if (this.rsmd == null) {
                throw IfxErrMsg.getSQLException(-79737, this.conn);
            }
            int numCols = this.rsmd.getColumnCount();
            this.nameToIdxTable = new Hashtable(numCols);
            for (int i = 1; i <= numCols; ++i) {
                if (!this.delimIdent) {
                    this.nameToIdxTable.put(this.rsmd.getColumnName(i).toLowerCase(), i);
                    continue;
                }
                this.nameToIdxTable.put(this.rsmd.getColumnName(i), i);
            }
        }
        if ((idx = !this.delimIdent ? this.nameToIdxTable.get(columnName.toLowerCase()) : this.nameToIdxTable.get(columnName)) == null) {
            throw IfxErrMsg.getSQLException(-79738, this.conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxScrollableResultSet.findColumn() exited");
        }
        return idx;
    }

    protected void chainWarnings(SQLWarning cwarn) {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: chainWarnings() called");
        }
        if (cwarn != null) {
            if (this.warnings != null) {
                this.warnings.setNextWarning(cwarn);
            } else {
                this.warnings = cwarn;
            }
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxSqli: chainWarnings() exited");
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.warnings;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.warnings = null;
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        IfxObject value = this.getValue(columnIndex);
        value.nullify();
    }

    @Override
    public void updateNull(String column) throws SQLException {
        this.updateNull(this.findColumn(column));
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        IfxObject value = this.getValue(columnIndex);
        value.fromBoolean(x);
    }

    @Override
    public void updateBoolean(String column, boolean x) throws SQLException {
        this.updateBoolean(this.findColumn(column), x);
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        IfxObject value = this.getValue(columnIndex);
        value.fromByte(x);
    }

    @Override
    public void updateByte(String column, byte x) throws SQLException {
        this.updateByte(this.findColumn(column), x);
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        IfxObject value = this.getValue(columnIndex);
        value.fromShort(x);
    }

    @Override
    public void updateShort(String column, short x) throws SQLException {
        this.updateShort(this.findColumn(column), x);
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        IfxObject value = this.getValue(columnIndex);
        value.fromInt(x);
    }

    @Override
    public void updateInt(String column, int x) throws SQLException {
        this.updateInt(this.findColumn(column), x);
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        IfxObject value = this.getValue(columnIndex);
        value.fromLong(x);
    }

    @Override
    public void updateLong(String column, long x) throws SQLException {
        this.updateLong(this.findColumn(column), x);
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        IfxObject value = this.getValue(columnIndex);
        value.fromFloat(x);
    }

    @Override
    public void updateFloat(String column, float x) throws SQLException {
        this.updateFloat(this.findColumn(column), x);
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        IfxObject value = this.getValue(columnIndex);
        value.fromDouble(x);
    }

    @Override
    public void updateDouble(String column, double x) throws SQLException {
        this.updateDouble(this.findColumn(column), x);
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        IfxObject value = this.getValue(columnIndex);
        value.fromDecimal(x);
    }

    @Override
    public void updateBigDecimal(String column, BigDecimal x) throws SQLException {
        this.updateBigDecimal(this.findColumn(column), x);
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        IfxObject value = this.getValue(columnIndex);
        value.fromString(x);
    }

    @Override
    public void updateString(String column, String x) throws SQLException {
        this.updateString(this.findColumn(column), x);
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        IfxObject value = this.getValue(columnIndex);
        value.fromBytes(x);
    }

    @Override
    public void updateBytes(String column, byte[] x) throws SQLException {
        this.updateBytes(this.findColumn(column), x);
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        IfxObject value = this.getValue(columnIndex);
        value.fromDate(x);
    }

    @Override
    public void updateDate(String column, Date x) throws SQLException {
        this.updateDate(this.findColumn(column), x);
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        IfxObject value = this.getValue(columnIndex);
        value.fromTime(x);
    }

    @Override
    public void updateTime(String column, Time x) throws SQLException {
        this.updateTime(this.findColumn(column), x);
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        IfxObject value = this.getValue(columnIndex);
        value.fromTimestamp(x);
    }

    @Override
    public void updateTimestamp(String column, Timestamp x) throws SQLException {
        this.updateTimestamp(this.findColumn(column), x);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        IfxObject value = this.getValue(columnIndex);
        value.fromAsciiStream(x, length);
    }

    @Override
    public void updateAsciiStream(String column, InputStream x, int length) throws SQLException {
        this.updateAsciiStream(this.findColumn(column), x, length);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        IfxObject value = this.getValue(columnIndex);
        value.fromBinaryStream(x, length);
    }

    @Override
    public void updateBinaryStream(String column, InputStream x, int length) throws SQLException {
        this.updateBinaryStream(this.findColumn(column), x, length);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        IfxObject value = this.getValue(columnIndex);
        value.fromCharacterStream(x, length);
    }

    @Override
    public void updateCharacterStream(String column, Reader reader, int length) throws SQLException {
        this.updateCharacterStream(this.findColumn(column), reader, length);
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxScrollableResultSet.updateObject(int, Object) entered");
            this.trace.writeTrace(logger, 2, " columnIndex: " + columnIndex);
        }
        IfxObject value = this.getValue(columnIndex);
        value.fromObject(x);
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxScrollableResultSet.updateObject(int, Object) exited");
        }
    }

    @Override
    public void updateObject(String column, Object x) throws SQLException {
        this.updateObject(this.findColumn(column), x);
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        IfxObject value = this.getValue(columnIndex);
        value.fromObject(x, scale);
    }

    @Override
    public void updateObject(String column, Object x, int scale) throws SQLException {
        this.updateObject(this.findColumn(column), x, scale);
    }

    public void updateIfxObject(int columnIndex, Object x) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxScrollableResultSet.updateIfxObject(int, Object) entered");
            this.trace.writeTrace(logger, 2, " columnIndex: " + columnIndex);
        }
        this.setIfxValue(columnIndex, x);
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxScrollableResultSet.updateIfxObject(int, Object) exited");
        }
    }

    public void updateIfxObject(String column, Object x) throws SQLException {
        this.updateObject(this.findColumn(column), x);
    }

    private void setIfxValue(int columnIndex, Object x) throws SQLException {
        Vector<IfxObject> v = null;
        try {
            v = this.getRowVector(columnIndex);
            IfxObject obj = (IfxObject)x;
            v.setElementAt(obj, columnIndex - 1);
            this.lastColWasNull = obj.isNull();
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        IfxObject value = this.getValue(columnIndex);
        String S = null;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxScrollableResultSet.getString(int) called. ColumnIndex: ", columnIndex);
        }
        if (value == null || value.isNull()) {
            return null;
        }
        S = value.toString();
        DataTruncation dt = value.getWarning();
        if (dt != null) {
            this.chainWarnings(new DataTruncation(columnIndex, false, true, dt.getDataSize(), dt.getTransferSize()));
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxScrollableResultSet.getString() exited.");
        }
        return S;
    }

    @Override
    public String getUnloadString(int columnIndex) throws SQLException {
        IfxObject value = this.getValue(columnIndex);
        if (value == null || value.isNull()) {
            return null;
        }
        value.setConnection(this.conn);
        return value.toUnloadString();
    }

    @Override
    public String getString(String columnName) throws SQLException {
        int idx = this.findColumn(columnName);
        return this.getString(idx);
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxScrollableResultSet.getObject(int) called. ColumnIndex: ", columnIndex);
            this.trace.writeTrace(logger, 2, "connection: " + this.conn);
        }
        Object res = null;
        if (this.conn != null) {
            res = this.getObject(columnIndex, this.conn.getTypeMap());
        } else {
            Map<String, Class<?>> map = null;
            res = this.getObject(columnIndex, map);
        }
        return res;
    }

    @Override
    public Object getObject(String columnName) throws SQLException {
        int idx = this.findColumn(columnName);
        return this.getObject(idx);
    }

    @Override
    public Object getObject(int colIdx, Map<String, Class<?>> map) throws SQLException {
        IfxObject value = this.getValue(colIdx);
        Object Obj = null;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxScrollableResultSet.getObject(int, Map) entered.");
        }
        if (value != null && !value.isNull()) {
            value.setTypeMap(map);
            Obj = value.toObject();
            DataTruncation dt = value.getWarning();
            if (dt != null) {
                this.chainWarnings(new DataTruncation(colIdx, false, true, dt.getDataSize(), dt.getTransferSize()));
            }
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxScrollableResultSet.getObject() exited.");
        }
        return Obj;
    }

    @Override
    public Object getObject(String columnName, Map<String, Class<?>> map) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxScrollableResultSet.getObject(String, Map) called.");
        }
        int idx = this.findColumn(columnName);
        return this.getObject(idx, map);
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        IfxObject value = this.getValue(columnIndex);
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxScrollableResultSet.getAsciiStream() called. ColumnIndex", columnIndex);
        }
        if (value == null || value.isNull()) {
            return null;
        }
        InputStream is = value.toAsciiStream();
        DataTruncation dt = value.getWarning();
        if (dt != null) {
            this.chainWarnings(new DataTruncation(columnIndex, false, true, dt.getDataSize(), dt.getTransferSize()));
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxScrollableResultSet.getAsciiStream() exited.");
        }
        return is;
    }

    @Override
    public InputStream getAsciiStream(String columnName) throws SQLException {
        int idx = this.findColumn(columnName);
        return this.getAsciiStream(idx);
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        String tmpst = this.getString(columnIndex);
        if (tmpst != null) {
            return new StringReader(tmpst);
        }
        return null;
    }

    @Override
    public Reader getCharacterStream(String columnName) throws SQLException {
        int idx = this.findColumn(columnName);
        return this.getCharacterStream(idx);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        IfxObject value = this.getValue(columnIndex);
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxScrollableResultSet.getBigDecimal() called. ColumnIndex", columnIndex);
            this.trace.writeTrace(logger, 1, "IfxScrollableResultSet.getBigDecimal() called. Scale", scale);
        }
        if (value == null || value.isNull()) {
            return null;
        }
        BigDecimal B = value.toDecimal().setScale(scale, 4);
        DataTruncation dt = value.getWarning();
        if (dt != null) {
            this.chainWarnings(new DataTruncation(columnIndex, false, true, dt.getDataSize(), dt.getTransferSize()));
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxScrollableResultSet.getBigDecimal() exited.");
        }
        return B;
    }

    @Override
    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        int idx = this.findColumn(columnName);
        return this.getBigDecimal(idx, scale);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        IfxObject value = this.getValue(columnIndex);
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxScrollableResultSet.getBigDecimal() called. ColumnIndex", columnIndex);
        }
        if (value == null || value.isNull()) {
            return null;
        }
        return value.toDecimal();
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        int idx = this.findColumn(columnName);
        return this.getBigDecimal(idx);
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        IfxObject value = this.getValue(columnIndex);
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxScrollableResultSet.getBoolean() called. ColumnIndex", columnIndex);
        }
        if (value == null || value.isNull()) {
            return false;
        }
        boolean b = value.toBoolean();
        DataTruncation dt = value.getWarning();
        if (dt != null) {
            this.chainWarnings(new DataTruncation(columnIndex, false, true, dt.getDataSize(), dt.getTransferSize()));
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxScrollableResultSet.getBoolean() exited");
        }
        return b;
    }

    @Override
    public boolean getBoolean(String columnName) throws SQLException {
        int idx = this.findColumn(columnName);
        return this.getBoolean(idx);
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        IfxObject value = this.getValue(columnIndex);
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxScrollableResultSet.getShort() called. ColumnIndex", columnIndex);
        }
        if (value == null || value.isNull()) {
            return 0;
        }
        short s = value.toShort();
        DataTruncation dt = value.getWarning();
        if (dt != null) {
            this.chainWarnings(new DataTruncation(columnIndex, false, true, dt.getDataSize(), dt.getTransferSize()));
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 3, "short value", s);
            this.trace.writeTrace(logger, 1, "IfxScrollableResultSet.getShort() exited");
        }
        return s;
    }

    @Override
    public short getShort(String columnName) throws SQLException {
        int idx = this.findColumn(columnName);
        return this.getShort(idx);
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        IfxObject value = this.getValue(columnIndex);
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxScrollableResultSet.getInt() called. ColumnIndex", columnIndex);
        }
        if (value == null || value.isNull()) {
            return 0;
        }
        int i = value.toInt();
        DataTruncation dt = value.getWarning();
        if (dt != null) {
            this.chainWarnings(new DataTruncation(columnIndex, false, true, dt.getDataSize(), dt.getTransferSize()));
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxScrollableResultSet.getInt() exited");
        }
        return i;
    }

    @Override
    public int getInt(String columnName) throws SQLException {
        int idx = this.findColumn(columnName);
        return this.getInt(idx);
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        IfxObject value = this.getValue(columnIndex);
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxScrollableResultSet.getLong() called. ColumnIndex", columnIndex);
        }
        if (value == null || value.isNull()) {
            return 0L;
        }
        long l = value.toLong();
        DataTruncation dt = value.getWarning();
        if (dt != null) {
            this.chainWarnings(new DataTruncation(columnIndex, false, true, dt.getDataSize(), dt.getTransferSize()));
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxScrollableResultSet.getLong() exited");
        }
        return l;
    }

    @Override
    public long getLong(String columnName) throws SQLException {
        int idx = this.findColumn(columnName);
        return this.getLong(idx);
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        IfxObject value = this.getValue(columnIndex);
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxScrollableResultSet.getFloat() called. ColumnIndex", columnIndex);
        }
        if (value == null || value.isNull()) {
            return 0.0f;
        }
        float f = value.toFloat();
        DataTruncation dt = value.getWarning();
        if (dt != null) {
            this.chainWarnings(new DataTruncation(columnIndex, false, true, dt.getDataSize(), dt.getTransferSize()));
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxScrollableResultSet.getFloat() exited");
        }
        return f;
    }

    @Override
    public float getFloat(String columnName) throws SQLException {
        int idx = this.findColumn(columnName);
        return this.getFloat(idx);
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        IfxObject value = this.getValue(columnIndex);
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxScrollableResultSet.getByte() called. ColumnIndex", columnIndex);
        }
        if (value == null || value.isNull()) {
            return 0;
        }
        byte b = value.toByte();
        DataTruncation dt = value.getWarning();
        if (dt != null) {
            this.chainWarnings(new DataTruncation(columnIndex, false, true, dt.getDataSize(), dt.getTransferSize()));
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxScrollableResultSet.getByte() exited");
        }
        return b;
    }

    @Override
    public byte getByte(String columnName) throws SQLException {
        int idx = this.findColumn(columnName);
        return this.getByte(idx);
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        IfxObject value = this.getValue(columnIndex);
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxScrollableResultSet.getBytes() called. ColumnIndex", columnIndex);
        }
        if (value == null || value.isNull()) {
            return null;
        }
        byte[] b = value.toBytes();
        DataTruncation dt = value.getWarning();
        if (dt != null) {
            this.chainWarnings(new DataTruncation(columnIndex, false, true, dt.getDataSize(), dt.getTransferSize()));
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxScrollableResultSet.getBytes() exited");
        }
        return b;
    }

    @Override
    public byte[] getBytes(String columnName) throws SQLException {
        int idx = this.findColumn(columnName);
        return this.getBytes(idx);
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        IfxObject value = this.getValue(columnIndex);
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxScrollableResultSet.getDate() called. ColumnIndex", columnIndex);
        }
        if (value == null || value.isNull()) {
            return null;
        }
        Date D = value.toDate();
        DataTruncation dt = value.getWarning();
        if (dt != null) {
            this.chainWarnings(new DataTruncation(columnIndex, false, true, dt.getDataSize(), dt.getTransferSize()));
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxScrollableResultSet.getDate() exited");
        }
        return D;
    }

    @Override
    public Date getDate(String columnName) throws SQLException {
        int idx = this.findColumn(columnName);
        return this.getDate(idx);
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        IfxObject value = this.getValue(columnIndex);
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxScrollableResultSet.getDouble() called. ColumnIndex", columnIndex);
        }
        if (value == null || value.isNull()) {
            return 0.0;
        }
        double d = value.toDouble();
        DataTruncation dt = value.getWarning();
        if (dt != null) {
            this.chainWarnings(new DataTruncation(columnIndex, false, true, dt.getDataSize(), dt.getTransferSize()));
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxScrollableResultSet.getDouble() exited");
        }
        return d;
    }

    @Override
    public double getDouble(String columnName) throws SQLException {
        int idx = this.findColumn(columnName);
        return this.getDouble(idx);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        IfxObject value = this.getValue(columnIndex);
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxScrollableResultSet.getTime() called. ColumnIndex", columnIndex);
        }
        if (value == null || value.isNull()) {
            return null;
        }
        Time T = value.toTime();
        DataTruncation dt = value.getWarning();
        if (dt != null) {
            this.chainWarnings(new DataTruncation(columnIndex, false, true, dt.getDataSize(), dt.getTransferSize()));
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxScrollableResultSet.getTime() exited");
        }
        return T;
    }

    @Override
    public Time getTime(String columnName) throws SQLException {
        int idx = this.findColumn(columnName);
        return this.getTime(idx);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return this.getTimestamp(columnIndex, (Calendar)null);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        IfxObject value;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxScrollableResultSet.getTimestamp() called. ColumnIndex", columnIndex);
        }
        if ((value = this.getValue(columnIndex, cal)) == null || value.isNull()) {
            return null;
        }
        Timestamp T = value.toTimestamp();
        DataTruncation dt = value.getWarning();
        if (dt != null) {
            this.chainWarnings(new DataTruncation(columnIndex, false, true, dt.getDataSize(), dt.getTransferSize()));
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxScrollableResultSet.getTimestmap() exited");
        }
        return T;
    }

    @Override
    public Timestamp getTimestamp(String columnName) throws SQLException {
        int idx = this.findColumn(columnName);
        return this.getTimestamp(idx);
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.getUnicodeStream(int).", this.conn);
    }

    @Override
    public InputStream getUnicodeStream(String columnName) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.getUnicodeStream(String).", this.conn);
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        IfxObject value = this.getValue(columnIndex);
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxScrollableResultSet.getBinaryStream() called. ColumnIndex", columnIndex);
        }
        if (value == null || value.isNull()) {
            return null;
        }
        InputStream is = value.toBinaryStream();
        DataTruncation dt = value.getWarning();
        if (dt != null) {
            this.chainWarnings(new DataTruncation(columnIndex, false, true, dt.getDataSize(), dt.getTransferSize()));
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxScrollableResultSet.getBinaryStream() exited");
        }
        return is;
    }

    @Override
    public InputStream getBinaryStream(String columnName) throws SQLException {
        int idx = this.findColumn(columnName);
        return this.getBinaryStream(idx);
    }

    @Override
    public Interval getInterval(int columnIndex) throws SQLException {
        IfxObject value = this.getValue(columnIndex);
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxScrollableResultSet.getInterval() called. ColumnIndex", columnIndex);
        }
        if (value == null || value.isNull()) {
            return null;
        }
        Interval I = value.toInterval();
        DataTruncation dt = value.getWarning();
        if (dt != null) {
            this.chainWarnings(new DataTruncation(columnIndex, false, true, dt.getDataSize(), dt.getTransferSize()));
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxScrollableResultSet.getInterval() exited");
        }
        return I;
    }

    @Override
    public Interval getInterval(String columnName) throws SQLException {
        int idx = this.findColumn(columnName);
        return this.getInterval(idx);
    }

    @Override
    public IntervalYM getIntervalYM(int columnIndex) throws SQLException {
        IfxObject value = this.getValue(columnIndex);
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxScrollableResultSet.getIntervalYM() called. ColumnIndex", columnIndex);
        }
        if (value == null || value.isNull()) {
            return null;
        }
        IntervalYM I = value.toIntervalYM();
        DataTruncation dt = value.getWarning();
        if (dt != null) {
            this.chainWarnings(new DataTruncation(columnIndex, false, true, dt.getDataSize(), dt.getTransferSize()));
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxScrollableResultSet.getIntervalYM() exited");
        }
        return I;
    }

    @Override
    public IntervalYM getIntervalYM(String columnName) throws SQLException {
        int idx = this.findColumn(columnName);
        return this.getIntervalYM(idx);
    }

    @Override
    public IntervalDF getIntervalDF(int columnIndex) throws SQLException {
        IfxObject value = this.getValue(columnIndex);
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxScrollableResultSet.getIntervalDF() called. ColumnIndex", columnIndex);
        }
        if (value == null || value.isNull()) {
            return null;
        }
        IntervalDF I = value.toIntervalDF();
        DataTruncation dt = value.getWarning();
        if (dt != null) {
            this.chainWarnings(new DataTruncation(columnIndex, false, true, dt.getDataSize(), dt.getTransferSize()));
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxScrollableResultSet.getIntervalDF() exited");
        }
        return I;
    }

    @Override
    public IntervalDF getIntervalDF(String columnName) throws SQLException {
        int idx = this.findColumn(columnName);
        return this.getIntervalDF(idx);
    }

    @Override
    public Ref getRef(int i) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.getRef(int).", this.conn);
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        IfxObject value = this.getValue(columnIndex);
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxScrollableResultSet.getBlob() called. ColumnIndex", columnIndex);
        }
        if (value == null || value.isNull()) {
            return null;
        }
        Blob is = value.toBlob();
        DataTruncation dt = value.getWarning();
        if (dt != null) {
            this.chainWarnings(new DataTruncation(columnIndex, false, true, dt.getDataSize(), dt.getTransferSize()));
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxScrollableResultSet.getBlob() exited.");
        }
        return is;
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        IfxObject value = this.getValue(columnIndex);
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxScrollableResultSet.getClob() called. ColumnIndex", columnIndex);
        }
        if (value == null || value.isNull()) {
            return null;
        }
        Clob is = value.toClob();
        DataTruncation dt = value.getWarning();
        if (dt != null) {
            this.chainWarnings(new DataTruncation(columnIndex, false, true, dt.getDataSize(), dt.getTransferSize()));
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxScrollableResultSet.getClob() exited.");
        }
        return is;
    }

    @Override
    public Array getArray(int colIdx) throws SQLException {
        IfxCollection value = (IfxCollection)this.getValue(colIdx);
        Array array = null;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxScrollableResultSet.getArray(int) entered.");
        }
        if (value != null && !value.isNull()) {
            array = value.toArray();
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxScrollableResultSet.getArray() exited.");
        }
        return array;
    }

    @Override
    public Ref getRef(String colName) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.getRef(String).", this.conn);
    }

    @Override
    public Blob getBlob(String colName) throws SQLException {
        int idx = this.findColumn(colName);
        return this.getBlob(idx);
    }

    @Override
    public Clob getClob(String colName) throws SQLException {
        int idx = this.findColumn(colName);
        return this.getClob(idx);
    }

    @Override
    public Array getArray(String colName) throws SQLException {
        int idx = this.findColumn(colName);
        return this.getArray(idx);
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        Date tmpdate = this.getDate(columnIndex);
        if (tmpdate == null) {
            return null;
        }
        long tm = tmpdate.getTime() + (long)cal.get(15) + (long)cal.get(16);
        return new Date(tm);
    }

    @Override
    public Date getDate(String columnName, Calendar cal) throws SQLException {
        int idx = this.findColumn(columnName);
        return this.getDate(idx, cal);
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        Time tmptime = this.getTime(columnIndex);
        if (tmptime == null) {
            return null;
        }
        long tm = tmptime.getTime() + (long)cal.get(15) + (long)cal.get(16);
        return new Time(tm);
    }

    @Override
    public Time getTime(String columnName, Calendar cal) throws SQLException {
        int idx = this.findColumn(columnName);
        return this.getTime(idx, cal);
    }

    @Override
    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        int idx = this.findColumn(columnName);
        return this.getTimestamp(idx, cal);
    }

    @Override
    public void close() {
        if (this.insertRowVector != null) {
            this.insertRowVector.removeAllElements();
            this.insertRowVector = null;
        }
    }

    @Override
    public IfxBSONObject getIfxBSONObject(int columnIndex) throws SQLException {
        IfxObject value = this.getValue(columnIndex);
        IfxBSONObject bsonObject = null;
        if (value instanceof IfxBSONObject) {
            if (this.conn != null) {
                bsonObject = (IfxBSONObject)this.getObject(columnIndex, this.conn.getTypeMap());
            } else {
                Map<String, Class<?>> map = null;
                bsonObject = (IfxBSONObject)this.getObject(columnIndex, map);
            }
        } else {
            throw IfxErrMsg.getSQLMinorException(-79741, -80040, this.conn);
        }
        return bsonObject;
    }

    @Override
    public IfxBSONObject getIfxBSONObject(String columnName) throws SQLException {
        return this.getIfxBSONObject(this.findColumn(columnName));
    }
}

