/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxDecimal;
import com.informix.jdbc.IfxObject;
import com.informix.lang.Decimal;
import com.informix.lang.IfxToJavaType;
import com.informix.lang.JavaToIfxType;
import com.informix.util.IfxErrMsg;
import com.informix.util.dateUtil;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class IfxDateTime
extends IfxObject {
    private long value = 0L;
    private int nanos = 0;
    private boolean isTime = false;
    private boolean isTimeStampFF = false;
    private boolean isTimeStampSS = false;
    private boolean isTimeStampMT = false;
    private boolean isTimeStampHH = false;
    private boolean isTimeStampDD = false;
    private boolean isTimeStampMM = false;
    private boolean isTimeStampYY = false;
    private boolean isTimeStampSF = false;
    private boolean isTimeStampMTF = false;
    private boolean isTimeStampMTS = false;
    private boolean isTimeStampHF = false;
    private boolean isTimeStampHM = false;
    private boolean isTimeStampDF = false;
    private boolean isTimeStampDS = false;
    private boolean isTimeStampDMT = false;
    private boolean isTimeStampDH = false;
    private boolean isTimeStampMF = false;
    private boolean isTimeStampMS = false;
    private boolean isTimeStampMMT = false;
    private boolean isTimeStampMH = false;
    private boolean isTimeStampMD = false;
    private boolean isTimeStampYS = false;
    private boolean isTimeStampYMT = false;
    private boolean isTimeStampYH = false;
    private boolean isTimeStampYD = false;
    private boolean isTimeStampYM = false;
    private short qualifier = 0;
    protected Calendar dbCalendar = null;
    private byte[] rawData = null;
    private short storedQualifier = 0;
    public static final byte TU_YEAR = 0;
    public static final byte TU_MONTH = 2;
    public static final byte TU_DAY = 4;
    public static final byte TU_HOUR = 6;
    public static final byte TU_MINUTE = 8;
    public static final byte TU_SECOND = 10;
    public static final byte TU_FRAC = 12;
    public static final byte TU_F1 = 11;
    public static final byte TU_F2 = 12;
    public static final byte TU_F3 = 13;
    public static final byte TU_F4 = 14;
    public static final byte TU_F5 = 15;

    IfxDateTime() throws SQLException {
        this.setIfxType(10);
    }

    public IfxDateTime(Time time) {
        this.setIfxType(10);
        this.qualifier = IfxDateTime.getQualifier((byte)6, (byte)10);
        if (time != null) {
            this.value = time.getTime();
            this.isTime = true;
            this.unnullify();
        }
    }

    public IfxDateTime(Timestamp timestamp) {
        this.setIfxType(10);
        this.qualifier = IfxDateTime.getQualifier((byte)0, (byte)15);
        if (timestamp != null) {
            this.value = timestamp.getTime();
            this.nanos = timestamp.getNanos();
            this.isTime = false;
            this.unnullify();
        }
    }

    @Override
    public byte[] toIfx() {
        if (this.isTime) {
            return JavaToIfxType.JavaToIfxDateTime(new Time(this.value));
        }
        Timestamp ts = new Timestamp(this.value);
        ts.setNanos(this.nanos);
        int colLength = this.getRawEncodedLength();
        int length = (colLength - colLength % 256) / 256;
        byte startCode = (byte)(((colLength -= 256 * length) - colLength % 16) / 16);
        if (this.encodedLength > 0 && this.conn.getIFX_USEPUT() && startCode != 0) {
            return new Decimal(this).javaToIfx();
        }
        return JavaToIfxType.JavaToIfxDateTime(ts, this.dbCalendar);
    }

    @Override
    public byte[] toIfxTuple() {
        if (this.isNull()) {
            return JavaToIfxType.JavaToIfxDecimalNull((short)this.encodedLength);
        }
        byte[] b = this.toIfx();
        return Decimal.fromBindToTuple(b, IfxDecimal.decLength(this.encodedLength));
    }

    @Override
    public void fromIfx(byte[] b, short prec) {
        this.fromIfx(b, 0, b.length, prec);
    }

    @Override
    public void fromIfx(byte[] b, int offset, int length, short prec) {
        this.rawData = new byte[length];
        System.arraycopy(b, offset, this.rawData, 0, length);
        if (b[offset] == 0 && b[offset + 1] == 0) {
            this.nullify();
        } else {
            this.storedQualifier = prec;
            this.qualifier = prec;
            Timestamp ts = IfxToJavaType.IfxToJavaDateTime(b, offset, length, prec, this.dbCalendar);
            this.value = ts.getTime();
            byte startCodex = IfxDateTime.getStartCode(this.qualifier);
            byte endCodex = IfxDateTime.getEndCode(this.qualifier);
            this.nanos = ts.getNanos();
            this.setDateTimeType(this.nanos, startCodex, endCodex);
            this.unnullify();
        }
    }

    @Override
    public Object toObject() {
        if (this.isNull()) {
            return null;
        }
        if (this.isTime) {
            return this.toTime();
        }
        return this.toTimestamp();
    }

    @Override
    public java.sql.Date toDate() {
        if (this.isNull()) {
            return null;
        }
        return new java.sql.Date(this.value);
    }

    @Override
    public void fromDate(java.sql.Date date) {
        if (date == null) {
            this.nullify();
        } else {
            this.value = date.getTime();
            this.nanos = 0;
            this.isTime = false;
            this.qualifier = IfxDateTime.getQualifier((byte)0, (byte)10);
            this.unnullify();
        }
    }

    public void fromCalendar(GregorianCalendar calendar) {
        this.fromCalendar((Calendar)calendar);
    }

    public Calendar toCalendar() {
        Calendar c = Calendar.getInstance();
        c.setTime(new Date(this.value));
        return c;
    }

    public void fromCalendar(Calendar calendar) {
        if (calendar == null) {
            this.nullify();
        } else {
            this.value = calendar.getTimeInMillis();
            this.nanos = 0;
            this.isTime = false;
            this.qualifier = IfxDateTime.getQualifier((byte)0, (byte)10);
            this.unnullify();
        }
    }

    public void fromDate(Date date) {
        if (date == null) {
            this.nullify();
        } else {
            this.value = date.getTime();
            this.nanos = 0;
            this.isTime = false;
            this.qualifier = IfxDateTime.getQualifier((byte)0, (byte)10);
            this.unnullify();
        }
    }

    @Override
    public Timestamp toTimestamp() {
        if (this.isNull()) {
            return null;
        }
        Timestamp ts = new Timestamp(this.value);
        ts.setNanos(this.nanos);
        return ts;
    }

    @Override
    public void fromTimestamp(Timestamp ts) {
        if (ts == null) {
            this.nullify();
        } else {
            this.value = ts.getTime();
            this.nanos = ts.getNanos();
            this.isTime = false;
            this.qualifier = IfxDateTime.getQualifier((byte)0, (byte)15);
            this.unnullify();
        }
    }

    public void fromRawDateTime(byte[] b, short prec) {
        if (b == null) {
            this.nullify();
        } else {
            int length = b.length;
            this.rawData = new byte[length];
            System.arraycopy(b, 0, this.rawData, 0, length);
            if (b[0] == 0 && b[1] == 0) {
                this.nullify();
            } else {
                this.isTime = false;
                this.storedQualifier = prec;
                this.unnullify();
            }
        }
    }

    Timestamp toTimestampFromRawData(Calendar cal) {
        if (this.rawData == null || this.rawData.length == 0 || this.storedQualifier == 0) {
            return null;
        }
        Decimal d = new Decimal(this.rawData, 0, this.rawData.length, this.storedQualifier, true);
        Timestamp ts = d.timestampValue(cal);
        this.value = ts.getTime();
        this.nanos = ts.getNanos();
        return ts;
    }

    public void fromTimestamp(Timestamp ts, short qual) {
        if (ts == null) {
            this.nullify();
        } else {
            this.value = ts.getTime();
            this.nanos = ts.getNanos();
            this.isTime = false;
            this.qualifier = qual;
            this.unnullify();
        }
    }

    public void fromLocalDate(LocalDate date) {
        if (date == null) {
            this.nullify();
        } else {
            this.fromDate(java.sql.Date.valueOf(date));
        }
    }

    public void fromLocalDateTime(LocalDateTime date) {
        if (date == null) {
            this.nullify();
        } else {
            this.fromTimestamp(Timestamp.valueOf(date));
        }
    }

    public void fromLocalTime(LocalTime time) {
        if (time == null) {
            this.nullify();
        } else {
            this.fromTime(Time.valueOf(time));
        }
    }

    @Override
    public Time toTime() {
        if (this.isNull()) {
            return null;
        }
        return Time.valueOf(new Time(this.value).toString());
    }

    @Override
    public void fromTime(Time time) {
        if (time == null) {
            this.nullify();
        } else {
            this.value = time.getTime();
            this.isTime = true;
            this.qualifier = IfxDateTime.getQualifier((byte)6, (byte)10);
            this.unnullify();
        }
    }

    @Override
    public String toString() {
        String s = null;
        String s1 = null;
        if (this.isNull()) {
            return null;
        }
        try {
            if (this.isTime) {
                Time time = new Time(this.value);
                s = dateUtil.convertDateTimeStr(time, this.conn, this.value);
                int length = s.length();
                int firstColon = s.indexOf(58);
                int secondColon = s.indexOf(58, firstColon + 1);
                if (this.isTimeStampSS) {
                    s = s1 = s.substring(secondColon + 1, length);
                } else if (this.isTimeStampMTS) {
                    s = s1 = s.substring(firstColon + 1, secondColon + 3);
                } else if (this.isTimeStampMT) {
                    s = s1 = s.substring(firstColon + 1, secondColon);
                } else if (this.isTimeStampHM) {
                    s = s1 = s.substring(0, secondColon);
                } else if (this.isTimeStampHH) {
                    s = s1 = s.substring(0, secondColon - 3);
                }
            } else if (this.value + (long)(this.nanos / 1000000) != 0L || this.rawData == null || this.rawData.length < 1) {
                Timestamp ts = this.toTimestamp();
                s = dateUtil.convertDateTimeStr(ts, this.conn, this.value);
                int length = s.length();
                int firstDash = s.indexOf(45);
                int secondDash = s.indexOf(45, firstDash + 1);
                if (this.isTimeStampFF) {
                    s = s1 = s.substring(secondDash + 12, length);
                } else if (this.isTimeStampSF) {
                    s = s1 = s.substring(secondDash + 10, length);
                } else if (this.isTimeStampMTF) {
                    s = s1 = s.substring(secondDash + 7, length);
                } else if (this.isTimeStampHF) {
                    s = s1 = s.substring(11, length);
                } else if (this.isTimeStampDF) {
                    s = s1 = s.substring(secondDash + 1, length);
                } else if (this.isTimeStampDS) {
                    s = s1 = s.substring(secondDash + 1, length - 2);
                } else if (this.isTimeStampDMT) {
                    s = s1 = s.substring(secondDash + 1, length - 5);
                } else if (this.isTimeStampDH) {
                    s = s1 = s.substring(secondDash + 1, length - 8);
                } else if (this.isTimeStampDD) {
                    s = s1 = s.substring(secondDash + 1, length - 11);
                } else if (this.isTimeStampMF) {
                    s = s1 = s.substring(firstDash + 1, length);
                } else if (this.isTimeStampMS) {
                    s = s1 = s.substring(firstDash + 1, length - 2);
                } else if (this.isTimeStampMMT) {
                    s = s1 = s.substring(firstDash + 1, length - 5);
                } else if (this.isTimeStampMH) {
                    s = s1 = s.substring(firstDash + 1, length - 8);
                } else if (this.isTimeStampMD) {
                    s = s1 = s.substring(firstDash + 1, length - 11);
                } else if (this.isTimeStampMM) {
                    s = s1 = s.substring(firstDash + 1, length - 14);
                } else if (this.isTimeStampYY) {
                    s = s1 = s.substring(0, length - 17);
                } else if (this.isTimeStampYM) {
                    s = s1 = s.substring(0, length - 14);
                } else if (this.isTimeStampYD) {
                    s = s1 = s.substring(0, length - 11);
                } else if (this.isTimeStampYH) {
                    s = s1 = s.substring(0, length - 8);
                } else if (this.isTimeStampYMT) {
                    s = s1 = s.substring(0, length - 5);
                } else if (this.isTimeStampYS) {
                    s = s1 = s.substring(0, length - 2);
                }
            } else {
                StringBuffer sb = new StringBuffer(this.rawData.length * 3 + 2);
                for (int i = 0; i < this.rawData.length; ++i) {
                    sb.append(' ');
                    sb.append(this.rawData[i]);
                }
                s = new String(sb);
            }
        }
        catch (Exception e) {
            s = null;
        }
        return s;
    }

    @Override
    public String toUnloadString() {
        if (this.isNull()) {
            return null;
        }
        return IfxToJavaType.IfxToDateTimeUnloadString(this.rawData, 0, this.rawData.length, this.storedQualifier);
    }

    @Override
    public void fromString(String str) throws SQLException {
        if (str == null) {
            this.nullify();
        } else {
            String nstr = str.trim();
            try {
                Timestamp ts = dateUtil.convertStringToTimestamp(nstr, this.conn);
                this.value = ts.getTime();
                this.nanos = ts.getNanos();
                this.isTime = false;
                this.unnullify();
            }
            catch (SQLException e) {
                try {
                    Time Tobj = dateUtil.convertStringToTime(nstr, this.conn);
                    this.value = Tobj.getTime();
                    this.nanos = 0;
                    this.isTime = true;
                    this.qualifier = IfxDateTime.getQualifier((byte)6, (byte)10);
                    this.unnullify();
                }
                catch (Exception ee) {
                    this.nullify();
                    this.value = 0L;
                    this.nanos = 0;
                    throw IfxErrMsg.getSQLException(-79716, ee.toString(), this.conn);
                }
            }
            catch (Exception e) {
                this.nullify();
                this.value = 0L;
                this.nanos = 0;
                throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
            }
        }
    }

    @Override
    public boolean equals(Object other) {
        if (this.isNull() || other == null) {
            return false;
        }
        if (other instanceof IfxDateTime) {
            IfxDateTime dtOther = (IfxDateTime)other;
            if (dtOther.isNull()) {
                return false;
            }
            if (dtOther.value == this.value && dtOther.nanos == this.nanos) {
                return true;
            }
        }
        return false;
    }

    static short getQualifier(byte startCode, byte endCode) {
        short length = (short)(endCode - startCode + (startCode == 0 ? 4 : 2));
        short qual = (short)((byte)length << 8 | startCode << 4 | endCode);
        return qual;
    }

    static byte getLength(short qual) {
        return (byte)(qual >> 8);
    }

    public static byte getStartCode(short qual) {
        return (byte)(qual >> 4 & 0xF);
    }

    public static byte getEndCode(short qualifier) {
        return (byte)(qualifier & 0xF);
    }

    @Override
    public short getEncodedLength() {
        if (this.qualifier == 0) {
            this.qualifier = IfxDateTime.getQualifier((byte)0, (byte)15);
        }
        return this.qualifier;
    }

    public int getRawEncodedLength() {
        return this.encodedLength;
    }

    static String getQualifierName(short qual, int ifxType) {
        if (qual == 0) {
            return null;
        }
        byte startCode = IfxDateTime.getStartCode(qual);
        byte endCode = IfxDateTime.getEndCode(qual);
        byte length = IfxDateTime.getLength(qual);
        String s = IfxDateTime.getFieldName(startCode, true);
        if (ifxType == 14 && startCode <= 10) {
            int leadingFieldPrecision = length - endCode + startCode;
            s = s + "(" + leadingFieldPrecision + ")";
        }
        s = s + " to ";
        s = s + IfxDateTime.getFieldName(endCode, false);
        return s;
    }

    static String getFieldName(byte x, boolean startCode) {
        if (startCode && x >= 11) {
            return "fraction";
        }
        switch (x) {
            case 0: {
                return "year";
            }
            case 2: {
                return "month";
            }
            case 4: {
                return "day";
            }
            case 6: {
                return "hour";
            }
            case 8: {
                return "minute";
            }
            case 10: {
                return "second";
            }
            case 11: {
                return "fraction(1)";
            }
            case 12: {
                return "fraction(2)";
            }
            case 13: {
                return "fraction(3)";
            }
            case 14: {
                return "fraction(4)";
            }
            case 15: {
                return "fraction(5)";
            }
        }
        return "";
    }

    public boolean isTimeValue() {
        return this.isTime;
    }

    public void setDateTimeType(int nanos, byte startCode, byte endCode) {
        if (startCode == endCode) {
            switch (startCode) {
                case 0: {
                    this.isTimeStampYY = true;
                    this.isTime = false;
                    break;
                }
                case 2: {
                    this.isTimeStampMM = true;
                    this.isTime = false;
                    break;
                }
                case 4: {
                    this.isTimeStampDD = true;
                    this.isTime = false;
                    break;
                }
                case 6: {
                    this.isTimeStampHH = true;
                    this.isTime = true;
                    break;
                }
                case 8: {
                    this.isTimeStampMT = true;
                    this.isTime = true;
                    break;
                }
                case 10: {
                    nanos = 0;
                    this.isTimeStampSS = true;
                    this.isTime = true;
                    break;
                }
                case 12: {
                    this.isTimeStampFF = true;
                    this.isTime = false;
                }
            }
        } else if (endCode < 11) {
            this.setDateTimeByStEndCode(startCode, endCode);
        } else if (endCode <= 15) {
            this.setDateTimeByStCode(startCode);
        }
    }

    public void setDateTimeByStCode(byte startCode) {
        switch (startCode) {
            case 0: {
                this.isTime = false;
                break;
            }
            case 2: {
                this.isTimeStampMF = true;
                this.isTime = false;
                break;
            }
            case 4: {
                this.isTimeStampDF = true;
                this.isTime = false;
                break;
            }
            case 6: {
                this.isTimeStampHF = true;
                this.isTime = false;
                break;
            }
            case 8: {
                this.isTimeStampMTF = true;
                this.isTime = false;
                break;
            }
            case 10: {
                this.isTimeStampSF = true;
                this.isTime = false;
                break;
            }
            case 12: {
                this.isTimeStampFF = true;
                this.isTime = false;
            }
        }
    }

    public void setDateTimeByStEndCode(byte startCode, byte endCode) {
        if (startCode == 0) {
            switch (endCode) {
                case 2: {
                    this.isTimeStampYM = true;
                    this.isTime = false;
                    break;
                }
                case 4: {
                    this.isTimeStampYD = true;
                    this.isTime = false;
                    break;
                }
                case 6: {
                    this.isTimeStampYH = true;
                    this.isTime = false;
                    break;
                }
                case 8: {
                    this.isTimeStampYMT = true;
                    this.isTime = false;
                    break;
                }
                case 10: {
                    this.isTimeStampYS = true;
                    this.isTime = false;
                }
            }
        } else if (startCode == 2) {
            switch (endCode) {
                case 4: {
                    this.isTimeStampMD = true;
                    this.isTime = false;
                    break;
                }
                case 6: {
                    this.isTimeStampMH = true;
                    this.isTime = false;
                    break;
                }
                case 8: {
                    this.isTimeStampMMT = true;
                    this.isTime = false;
                    break;
                }
                case 10: {
                    this.isTimeStampMS = true;
                    this.isTime = false;
                }
            }
        } else if (startCode == 4) {
            switch (endCode) {
                case 6: {
                    this.isTimeStampDH = true;
                    this.isTime = false;
                    break;
                }
                case 8: {
                    this.isTimeStampDMT = true;
                    this.isTime = false;
                    break;
                }
                case 10: {
                    this.isTimeStampDS = true;
                    this.isTime = false;
                }
            }
        } else if (startCode == 6) {
            switch (endCode) {
                case 8: {
                    this.nanos = 0;
                    this.isTimeStampHM = true;
                    this.isTime = true;
                    break;
                }
                case 10: {
                    this.nanos = 0;
                    this.isTime = true;
                }
            }
        } else if (startCode == 8) {
            switch (endCode) {
                case 10: {
                    this.nanos = 0;
                    this.isTimeStampMTS = true;
                    this.isTime = true;
                }
            }
        }
    }

    public int getNanos() {
        return this.nanos;
    }

    public void setNanos(int nanos) {
        this.nanos = nanos;
    }

    public boolean truncateDataForPut(byte colDefEndCode) {
        long orgNanos = this.nanos;
        long orgValue = this.value;
        Timestamp ts = new Timestamp(this.value);
        switch (colDefEndCode) {
            case 15: {
                this.nanos -= this.nanos % 10000;
                break;
            }
            case 14: {
                this.nanos -= this.nanos % 100000;
                break;
            }
            case 13: {
                this.nanos -= this.nanos % 1000000;
                break;
            }
            case 12: {
                this.nanos -= this.nanos % 10000000;
                break;
            }
            case 11: {
                this.nanos -= this.nanos % 100000000;
                break;
            }
            case 10: {
                this.nanos = 0;
                break;
            }
            case 8: {
                this.nanos = 0;
                ts.setSeconds(0);
                break;
            }
            case 6: {
                this.nanos = 0;
                ts.setSeconds(0);
                ts.setMinutes(0);
                break;
            }
            case 4: {
                this.nanos = 0;
                ts.setSeconds(0);
                ts.setMinutes(0);
                ts.setHours(0);
                break;
            }
            case 2: {
                this.nanos = 0;
                ts.setSeconds(0);
                ts.setMinutes(0);
                ts.setHours(0);
                ts.setDate(1);
                break;
            }
            case 0: {
                this.nanos = 0;
                ts.setSeconds(0);
                ts.setMinutes(0);
                ts.setHours(0);
                ts.setDate(1);
                ts.setMonth(0);
            }
        }
        this.value = ts.getTime();
        return this.value != orgValue || (long)this.nanos != orgNanos;
    }
}

