/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxSqliConnect;
import com.informix.lang.IfxTypes;
import com.informix.util.Trace;
import com.informix.util.TraceFlag;
import com.informix.util.stringUtil;
import java.util.Vector;

public class IfxColumnInfo {
    private static final Object logger = Trace.getLoggerForClass(IfxColumnInfo.class);
    int Nullable = 2;
    int MaxWidth;
    String Coltitle = "";
    String ColName = "";
    int DecimalDigits;
    int RightDecimal;
    String TableName = "";
    int SQLtype = 49;
    String DataSourceName = "";
    int SourceType;
    int ColLength;
    int ColStartPos;
    int ExtendedId;
    String ExtendedOwner = "";
    String ExtendedName = "";
    short Reference;
    short Alignment;
    boolean IsDistinct;
    boolean IsNamedRow;
    Vector<IfxColumnInfo> child;
    short Levelno;
    short Seqno;
    short Parentno;
    short Fieldno;
    short autoIncrement;
    int colMode = 1;
    String ArgumentName = "";
    byte ArgumentFlags = 0;
    private int adjustedColumnLength = -1;
    private int variableLengthTypeCheck = -1;
    private boolean variableLengthType = false;
    int ColumnDisplaySize = -1;
    private int isSignedCheck = -1;
    private boolean isSigned = false;
    private int isSearchableCheck = -1;
    private boolean isSearchable = false;
    protected String ifxTypeClassName = null;
    protected int ifxRealType = -1;
    boolean isIfxColLenSet = false;
    int ifxColLen;

    IfxColumnInfo() {
    }

    public Object clone() {
        IfxColumnInfo colInfo = new IfxColumnInfo();
        this.copy(colInfo);
        return colInfo;
    }

    public void copy(IfxColumnInfo colInfo) {
        colInfo.Nullable = this.Nullable;
        colInfo.MaxWidth = this.MaxWidth;
        colInfo.Coltitle = this.Coltitle;
        colInfo.ColName = this.ColName;
        colInfo.DecimalDigits = this.DecimalDigits;
        colInfo.RightDecimal = this.RightDecimal;
        colInfo.TableName = this.TableName;
        colInfo.SQLtype = this.SQLtype;
        colInfo.DataSourceName = this.DataSourceName;
        colInfo.SourceType = this.SourceType;
        colInfo.ColLength = this.ColLength;
        colInfo.ColStartPos = this.ColStartPos;
        colInfo.ExtendedId = this.ExtendedId;
        colInfo.ExtendedOwner = this.ExtendedOwner;
        colInfo.ExtendedName = this.ExtendedName;
        colInfo.Reference = this.Reference;
        colInfo.Alignment = this.Alignment;
        colInfo.IsDistinct = this.IsDistinct;
        colInfo.IsNamedRow = this.IsNamedRow;
        colInfo.child = this.child;
        colInfo.Levelno = this.Levelno;
        colInfo.Seqno = this.Seqno;
        colInfo.Parentno = this.Parentno;
        colInfo.Fieldno = this.Fieldno;
        colInfo.autoIncrement = this.autoIncrement;
        colInfo.colMode = this.colMode;
        colInfo.ArgumentName = this.ArgumentName;
        colInfo.ArgumentFlags = this.ArgumentFlags;
    }

    public void dumpInfo(Trace trace, int indent) {
        if (TraceFlag.isTraceEnabled()) {
            String pretty = stringUtil.fixLength("", indent, ' ');
            trace.writeTrace(logger, 2, "  ");
            trace.writeTrace(logger, 2, pretty + "Levelno       : " + this.Levelno);
            trace.writeTrace(logger, 2, pretty + "ColName       : " + this.ColName);
            trace.writeTrace(logger, 2, pretty + "SQLtype       : " + this.SQLtype + "  " + IfxTypes.IfxTypeToName(this.SQLtype));
            trace.writeTrace(logger, 2, pretty + "ColLength     : " + this.ColLength);
            trace.writeTrace(logger, 2, pretty + "ExtendedId    : " + this.ExtendedId);
            trace.writeTrace(logger, 2, pretty + "ExtendedName  : " + this.ExtendedName);
            trace.writeTrace(logger, 2, pretty + "ExtendedOwner : " + this.ExtendedOwner);
            trace.writeTrace(logger, 2, pretty + "Alignment     : " + this.Alignment);
            trace.writeTrace(logger, 2, pretty + "SourceType    : " + this.SourceType);
            trace.writeTrace(logger, 2, pretty + "Nullable      : " + this.Nullable);
            trace.writeTrace(logger, 2, pretty + "isDistinct    : " + this.IsDistinct);
            trace.writeTrace(logger, 2, pretty + "isNamedRow    : " + this.IsNamedRow);
            if (this.child == null) {
                trace.writeTrace(logger, 2, pretty + "child     : is null");
            } else {
                trace.writeTrace(logger, 2, pretty + "child     : is not null");
            }
            trace.writeTrace(logger, 2, pretty + "colMode\t: " + this.colMode);
            trace.writeTrace(logger, 2, pretty + "ArgumentName  : " + this.ArgumentName);
            trace.writeTrace(logger, 2, pretty + "ArgumentFlags : " + this.ArgumentFlags);
        }
    }

    protected int getAdjustedColumnLength() {
        if (this.adjustedColumnLength == -1) {
            this.adjustedColumnLength = this.ColLength != -1 && (this.SQLtype == 10 || this.SQLtype == 14 || this.SQLtype == 5 || this.SQLtype == 8) ? ((this.ColLength >> 8 & 0xFF) + (this.ColLength & 0xFF & 1) + 3) / 2 : this.ColLength;
        }
        return this.adjustedColumnLength;
    }

    protected boolean isVariableLengthType(IfxSqliConnect conn) {
        if (this.variableLengthTypeCheck == -1) {
            boolean isBigIntType = false;
            if (this.SQLtype == 52 || this.SQLtype == 53) {
                isBigIntType = true;
            }
            if (this.SQLtype > 18 && !isBigIntType) {
                this.variableLengthType = true;
            } else if (conn.isVarcharVarLenSupported() && (this.SQLtype == 13 || this.SQLtype == 16)) {
                this.variableLengthType = true;
            }
            this.variableLengthTypeCheck = 0;
        }
        return this.variableLengthType;
    }

    protected boolean isSigned() {
        if (this.isSignedCheck == -1) {
            switch (this.SQLtype) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 14: 
                case 17: 
                case 52: {
                    this.isSigned = true;
                    break;
                }
                default: {
                    this.isSigned = false;
                }
            }
            this.isSignedCheck = 0;
        }
        return this.isSigned;
    }

    protected boolean isSearchable() {
        if (this.isSearchableCheck == -1) {
            switch (this.SQLtype) {
                case 11: 
                case 12: 
                case 40: 
                case 41: {
                    this.isSearchable = false;
                    break;
                }
                default: {
                    this.isSearchable = true;
                }
            }
        }
        return this.isSearchable;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Column ");
        sb.append("Type: " + IfxTypes.FromIfxTypeToJava(this.SQLtype));
        return sb.toString();
    }
}

