/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxBaseType;
import com.informix.util.IfxErrMsg;
import com.informix.util.TraceFlag;
import java.math.BigDecimal;
import java.sql.SQLException;

class IfxBoolean
extends IfxBaseType {
    boolean value;
    public static final byte IFX_BOOL_NULL = -1;

    IfxBoolean() throws SQLException {
        this.setIfxType(45);
        this.setExtendedId(5);
    }

    IfxBoolean(boolean b) throws SQLException {
        this.setIfxType(45);
        this.setExtendedId(5);
        this.unnullify();
        this.value = b;
    }

    IfxBoolean(Boolean B) throws SQLException {
        this.setIfxType(45);
        this.setExtendedId(5);
        this.unnullify();
        this.value = B;
    }

    @Override
    public void fromIfx(byte[] x) throws SQLException {
        this.fromIfx(x, 0, x.length);
    }

    @Override
    public void fromIfx(byte[] x, int offset, int size) throws SQLException {
        super.fromIfx(x, offset, size);
        if (!this.isNull()) {
            byte b = this.inputStream.readByte();
            if (b == 1) {
                this.value = true;
            } else if (b == 0) {
                this.value = false;
            } else if (b == -1) {
                this.nullify();
            }
        }
    }

    @Override
    public byte[] toIfx() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxBoolean: enter method");
        }
        this.outputStream.reset();
        if (!this.isNull()) {
            byte b = this.value ? (byte)1 : 0;
            this.outputStream.writeByte(b);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(2, "IfxBoolean: calling super.toIfx()");
        }
        return super.toIfx();
    }

    @Override
    public byte[] toIfxTuple() throws SQLException {
        byte[] b;
        if (this.isNull()) {
            b = new byte[5];
            b[0] = 1;
        } else {
            b = new byte[6];
            b[0] = 0;
            byte[] x = this.toIfx();
            System.arraycopy(x, 0, b, 1, x.length);
        }
        return b;
    }

    @Override
    public boolean equals(Object other) {
        if (this.isNull() || other == null || !(other instanceof IfxBoolean)) {
            return false;
        }
        IfxBoolean otherBoolean = (IfxBoolean)other;
        if (otherBoolean.isNull()) {
            return false;
        }
        return this.value == otherBoolean.value;
    }

    @Override
    public Object toObject() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return new Boolean(this.value);
    }

    @Override
    public short toShort() throws SQLException {
        if (this.isNull() || !this.value) {
            return 0;
        }
        return 1;
    }

    @Override
    public void fromShort(short val) throws SQLException {
        this.value = val == 1;
        this.unnullify();
    }

    @Override
    public void fromShort(Short val) throws SQLException {
        if (val == null) {
            this.nullify();
        } else {
            this.fromShort((short)val);
        }
    }

    @Override
    public double toDouble() throws SQLException {
        if (this.isNull()) {
            return 0.0;
        }
        return this.toInt();
    }

    @Override
    public void fromDouble(double val) throws SQLException {
        this.value = val == 1.0;
        this.unnullify();
    }

    @Override
    public void fromDouble(Double val) throws SQLException {
        if (val == null) {
            this.nullify();
        } else {
            this.fromDouble((double)val);
        }
    }

    @Override
    public float toFloat() throws SQLException {
        if (this.isNull()) {
            return 0.0f;
        }
        return this.toInt();
    }

    @Override
    public void fromFloat(float val) throws SQLException {
        this.value = (double)val == 1.0;
        this.unnullify();
    }

    @Override
    public void fromFloat(Float val) throws SQLException {
        if (val == null) {
            this.nullify();
        } else {
            this.fromFloat(val.floatValue());
        }
    }

    @Override
    public int toInt() throws SQLException {
        if (this.isNull() || !this.value) {
            return 0;
        }
        return 1;
    }

    @Override
    public void fromInt(int i) throws SQLException {
        this.value = i == 1;
        this.unnullify();
    }

    @Override
    public void fromInt(Integer I) throws SQLException {
        if (I == null) {
            this.nullify();
        } else {
            this.fromInt((int)I);
            this.unnullify();
        }
    }

    @Override
    public long toLong() throws SQLException {
        if (this.isNull() || !this.value) {
            return 0L;
        }
        return 1L;
    }

    @Override
    public void fromLong(long l) throws SQLException {
        this.value = l == 1L;
        this.unnullify();
    }

    @Override
    public void fromLong(Long L) throws SQLException {
        if (L == null) {
            this.nullify();
        } else {
            this.fromLong((long)L);
            this.unnullify();
        }
    }

    @Override
    public void fromByte(byte b) throws SQLException {
        if (b == 255) {
            this.nullify();
        } else {
            this.value = b == 1;
            this.unnullify();
        }
    }

    @Override
    public void fromByte(Byte B) throws SQLException {
        this.fromByte((byte)B);
    }

    @Override
    public boolean toBoolean() throws SQLException {
        if (this.isNull()) {
            return false;
        }
        return this.value;
    }

    @Override
    public void fromBoolean(boolean b) throws SQLException {
        this.value = b;
        this.unnullify();
    }

    @Override
    public void fromBoolean(Boolean B) throws SQLException {
        if (B == null) {
            this.nullify();
        } else {
            this.fromBoolean((boolean)B);
        }
    }

    @Override
    public void fromDecimal(BigDecimal bD) {
        if (bD != null) {
            this.value = bD.compareTo(new BigDecimal("1")) == 0;
            this.unnullify();
        } else {
            this.nullify();
        }
    }

    @Override
    public BigDecimal toDecimal() {
        if (this.isNull()) {
            return null;
        }
        if (this.value) {
            return new BigDecimal(1);
        }
        return new BigDecimal(0);
    }

    @Override
    public String toString() {
        if (this.isNull()) {
            return null;
        }
        if (this.value) {
            return "t";
        }
        return "f";
    }

    @Override
    public void fromString(String S) throws SQLException {
        if (S == null) {
            this.nullify();
        } else {
            String str = S.trim();
            if (str.equalsIgnoreCase("t") || str.equalsIgnoreCase("true")) {
                this.value = true;
            } else if (str.equalsIgnoreCase("f") || str.equalsIgnoreCase("false")) {
                this.value = false;
            } else {
                throw IfxErrMsg.getSQLException(-79771, this.conn);
            }
            this.unnullify();
        }
    }
}

