/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxUDT;
import com.informix.jdbc.IfxUDTInput;
import com.informix.jdbc.IfxUDTOutput;
import com.informix.jdbc.IfxValueCodecProvider;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.SQLOutput;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bson.BSONObject;
import org.bson.BsonBinaryWriter;
import org.bson.BsonWriter;
import org.bson.ByteBuf;
import org.bson.Document;
import org.bson.RawBsonDocument;
import org.bson.codecs.BsonValueCodecProvider;
import org.bson.codecs.DocumentCodec;
import org.bson.codecs.DocumentCodecProvider;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.ValueCodecProvider;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.io.BasicOutputBuffer;

public class IfxBSONObject
extends IfxUDT
implements SQLData,
Map<String, Object>,
BSONObject {
    protected DocumentCodec codec = null;
    protected RawBsonDocument rawDocument = null;
    protected Document bsonObject = null;

    public IfxBSONObject() {
        this.setExtendedId(26);
        this.bsonObject = new Document();
    }

    public IfxBSONObject(String key, Object value) {
        this(new Document(key, value));
    }

    public IfxBSONObject(byte[] bytes) {
        this(bytes, false);
    }

    public IfxBSONObject(byte[] bytes, boolean copyBytes) {
        this.setExtendedId(26);
        if (copyBytes) {
            byte[] newBytes = new byte[bytes.length];
            System.arraycopy(bytes, 0, newBytes, 0, bytes.length);
            this.rawDocument = new RawBsonDocument(newBytes);
        } else {
            this.rawDocument = new RawBsonDocument(bytes);
        }
    }

    public IfxBSONObject(Document bsonObject) {
        this.setExtendedId(26);
        this.bsonObject = bsonObject;
    }

    @Override
    public String getSQLTypeName() throws SQLException {
        return "bson";
    }

    @Override
    public void readSQL(SQLInput stream, String typeName) throws SQLException {
        IfxUDTInput input = (IfxUDTInput)stream;
        this.setBytes(input.readBytes(input.length()));
    }

    @Override
    public void writeSQL(SQLOutput stream) throws SQLException {
        this.ensureRawDocument();
        IfxUDTOutput outStream = (IfxUDTOutput)stream;
        ByteBuf buffer = this.rawDocument.getByteBuffer();
        outStream.write(buffer.array(), buffer.limit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ensureRawDocument() {
        if (this.rawDocument == null) {
            if (this.bsonObject == null) {
                this.bsonObject = new Document();
            }
            BasicOutputBuffer buffer = new BasicOutputBuffer();
            try (BsonBinaryWriter writer = new BsonBinaryWriter(buffer);){
                if (this.codec == null) {
                    CodecRegistry registry = CodecRegistries.fromProviders(Arrays.asList(new ValueCodecProvider(), new IfxValueCodecProvider(), new BsonValueCodecProvider(), new DocumentCodecProvider()));
                    this.codec = new DocumentCodec(registry);
                }
                this.codec.encode((BsonWriter)writer, this.bsonObject, EncoderContext.builder().build());
                this.rawDocument = new RawBsonDocument(buffer.getInternalBuffer(), 0, buffer.getPosition());
            }
        }
        this.bsonObject = null;
    }

    protected void ensureBsonObject() {
        if (this.bsonObject == null) {
            if (this.rawDocument != null) {
                this.bsonObject = Document.parse(this.rawDocument.asDocument().toJson());
            } else {
                this.setDocument(new Document());
            }
        }
        this.rawDocument = null;
    }

    public byte[] getBytes() {
        this.ensureRawDocument();
        byte[] toReturn = new byte[this.rawDocument.getByteBuffer().limit()];
        this.rawDocument.getByteBuffer().get(toReturn);
        return toReturn;
    }

    public void setBytes(byte[] bytes) {
        this.rawDocument = new RawBsonDocument(bytes);
        this.bsonObject = null;
    }

    public void setRawDocument(RawBsonDocument doc) {
        this.rawDocument = doc;
        this.bsonObject = null;
    }

    public void setDocument(Document bsonObject) {
        if (bsonObject == null) {
            throw new NullPointerException("The bsonObject must not be null");
        }
        this.bsonObject = bsonObject;
        this.rawDocument = null;
    }

    public void setBSONObject(BSONObject bsonObject) {
        if (bsonObject == null) {
            throw new NullPointerException("The bsonObject must not be null");
        }
        this.bsonObject = new Document(bsonObject.toMap());
        this.rawDocument = null;
    }

    public static IfxBSONObject ensureIfxBSONObject(Object o) {
        if (o == null) {
            throw new NullPointerException("The object must not be null");
        }
        if (o instanceof IfxBSONObject) {
            return (IfxBSONObject)o;
        }
        if (o instanceof Document) {
            return new IfxBSONObject((Document)o);
        }
        throw new IllegalArgumentException(MessageFormat.format("The specified object is not of type {0} and does not implement the interface {1}", IfxBSONObject.class.getSimpleName(), Document.class.getSimpleName()));
    }

    @Override
    public String toString() {
        if (this.bsonObject != null) {
            return this.bsonObject.toJson();
        }
        return this.rawDocument.toString();
    }

    @Override
    public Object put(String key, Object v) {
        this.ensureBsonObject();
        return this.bsonObject.put(key, v);
    }

    @Override
    public Map<String, Object> toMap() {
        this.ensureBsonObject();
        for (Map.Entry<String, Object> entry : this.bsonObject.entrySet()) {
            if (entry.getValue() instanceof Document) {
                entry.setValue(new IfxBSONObject((Document)entry.getValue()));
            }
            if (!(entry.getValue() instanceof List)) continue;
            this.convertListToIfxBSONObject((List)entry.getValue());
        }
        return this.bsonObject;
    }

    @Override
    public boolean containsKey(String s) {
        if (this.rawDocument != null) {
            return this.rawDocument.containsKey(s);
        }
        return this.bsonObject.containsKey(s);
    }

    @Override
    public boolean containsField(String s) {
        return this.containsKey(s);
    }

    @Override
    public Set<String> keySet() {
        if (this.rawDocument != null) {
            return this.rawDocument.keySet();
        }
        return this.bsonObject.keySet();
    }

    @Override
    public int hashCode() {
        if (this.bsonObject != null) {
            return this.bsonObject.hashCode();
        }
        return this.rawDocument.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof IfxBSONObject) {
            if (this.rawDocument != null) {
                return this.rawDocument.equals(((IfxBSONObject)o).rawDocument);
            }
            return this.bsonObject.equals(((IfxBSONObject)o).bsonObject);
        }
        return false;
    }

    @Override
    public int size() {
        if (this.rawDocument != null) {
            return this.rawDocument.size();
        }
        return this.bsonObject.size();
    }

    @Override
    public boolean isEmpty() {
        if (this.rawDocument != null) {
            return this.rawDocument.isEmpty();
        }
        return this.bsonObject.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        if (this.rawDocument != null) {
            return this.rawDocument.containsKey(key);
        }
        return this.bsonObject.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        this.ensureBsonObject();
        return this.bsonObject.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        return this.getObject(key);
    }

    @Override
    public Object get(String key) {
        return this.getObject(key);
    }

    private Object getObject(Object key) {
        this.ensureBsonObject();
        Object o = this.bsonObject.get(key);
        if (o instanceof Document) {
            return new IfxBSONObject((Document)o);
        }
        if (o instanceof List) {
            this.convertListToIfxBSONObject((List)o);
        }
        return o;
    }

    private void convertListToIfxBSONObject(List<Object> list) {
        for (int i = 0; i < list.size(); ++i) {
            if (!(list.get(i) instanceof Document)) continue;
            list.set(i, new IfxBSONObject((Document)list.get(i)));
        }
    }

    @Override
    public Object remove(Object key) {
        this.ensureBsonObject();
        return this.bsonObject.remove(key);
    }

    @Override
    public Collection<Object> values() {
        this.ensureBsonObject();
        return this.bsonObject.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        this.ensureBsonObject();
        return this.bsonObject.entrySet();
    }

    @Override
    public void putAll(Map m) {
        this.ensureBsonObject();
        this.bsonObject.putAll(m);
    }

    public Document getDocument() {
        this.ensureBsonObject();
        return this.bsonObject;
    }

    public RawBsonDocument getRawDocument() {
        this.ensureRawDocument();
        return this.rawDocument;
    }

    public IfxBSONObject append(String key, Object value) {
        this.put(key, value);
        return this;
    }

    public int getInt(String key) {
        if (this.rawDocument != null) {
            return this.rawDocument.getInt32(key).getValue();
        }
        return this.bsonObject.getInteger(key);
    }

    public long getLong(String key) {
        if (this.rawDocument != null) {
            return this.rawDocument.getInt64(key).getValue();
        }
        return this.bsonObject.getLong(key);
    }

    public double getDouble(String key) {
        if (this.rawDocument != null) {
            return this.rawDocument.getDouble(key).getValue();
        }
        return this.bsonObject.getDouble(key);
    }

    public String getString(String key) {
        if (this.rawDocument != null) {
            return this.rawDocument.getString(key).getValue();
        }
        return this.bsonObject.getString(key);
    }

    public boolean getBoolean(String key) {
        if (this.rawDocument != null) {
            return this.rawDocument.getBoolean(key).getValue();
        }
        return this.bsonObject.getBoolean(key);
    }

    public boolean isRawDocument() {
        return this.rawDocument != null;
    }

    public String getFirstKey() {
        if (this.rawDocument != null) {
            return this.rawDocument.getFirstKey();
        }
        return this.bsonObject.keySet().iterator().next();
    }

    @Override
    public void putAll(BSONObject o) {
        this.putAll(o.toMap());
    }

    @Override
    public Object removeField(String key) {
        return this.remove(key);
    }
}

