/*
 * Decompiled with CFR 0.152.
 */
package com.informix.asf;

import com.informix.asf.IfxASFException;
import com.informix.jns.IfxJNSException;
import com.informix.jns.ServerGroup;
import com.informix.jns.ServerInfo;
import com.informix.jns.Sqlhosts;
import com.informix.util.IfxErrMsg;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Properties;
import java.util.Random;
import java.util.StringTokenizer;

public class JnsObject {
    static final int MAX_BUFF_SIZE = 32768;
    static final int MIN_BUFF_SIZE = 140;
    static int STREAM_BUF_SIZE = 4096;
    private String ClientLocale = null;
    private String ipAddr = null;
    private String portNo = null;
    private int PortNumber = 0;
    private int groupCount = 0;
    private String gServerName = null;
    ServerGroup myGroup = null;
    private boolean isOptionC_One = false;

    public boolean getIfOptionC_One() {
        return this.isOptionC_One;
    }

    public void JnsLookup(String servername, Properties optProps) throws IfxASFException {
        String Option = null;
        try {
            int BufferSize;
            Sqlhosts mySqlhosts = new Sqlhosts(optProps);
            ServerInfo myServerInfo = mySqlhosts.getServer(servername);
            if (myServerInfo.isGroupEntry()) {
                this.myGroup = mySqlhosts.getServerGroup(servername);
                Option = myServerInfo.getOption("c");
                this.groupCount = this.myGroup.size();
                if (Option != null && Option.equals("1") && this.groupCount > 1) {
                    this.isOptionC_One = true;
                    Random generator = new Random();
                    int rand = generator.nextInt();
                    int randomNo = rand % this.groupCount;
                    if (randomNo < 0) {
                        randomNo = -randomNo;
                    }
                    this.gServerName = (String)this.myGroup.elementAt(randomNo);
                } else {
                    this.gServerName = (String)this.myGroup.nextElement();
                }
                myServerInfo = mySqlhosts.getServer(this.gServerName);
            }
            if ((Option = myServerInfo.getOption("b")) != null && (BufferSize = Integer.parseInt(Option)) > 140 && BufferSize < 32768) {
                STREAM_BUF_SIZE = BufferSize;
            }
            this.ipAddr = myServerInfo.getHostname().replaceFirst("^\\*", "");
            this.portNo = myServerInfo.getService();
        }
        catch (IfxJNSException JNSe) {
            throw IfxErrMsg.getLocIfxASFException(-25563, this.ClientLocale);
        }
        try {
            this.PortNumber = Integer.parseInt(this.portNo);
        }
        catch (NumberFormatException nfe) {
            int poNo = -1;
            poNo = JnsObject.getServiceByName(this.portNo);
            if (poNo == -1) {
                String msg = IfxErrMsg.getMessage(-931, this.ClientLocale, this.portNo);
                throw new IfxASFException(-931, msg);
            }
            this.PortNumber = poNo;
        }
    }

    public ServerGroup getServerGroup() {
        return this.myGroup;
    }

    public int getGroupCount() {
        return this.groupCount;
    }

    public String getServerName() {
        return this.gServerName;
    }

    public String getIPAddr() {
        return this.ipAddr;
    }

    public String getPortNo() {
        return this.portNo;
    }

    public int getPortNumber() {
        return this.PortNumber;
    }

    public void setClientLocale(String locale) {
        this.ClientLocale = locale;
    }

    public String getClientLocale() {
        return this.ClientLocale;
    }

    public static int getServiceByName(String serviceName) {
        int port = -1;
        String servicesFilename = JnsObject.getServicesFileName();
        if (servicesFilename == null) {
            return -1;
        }
        try {
            String servLine;
            BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(servicesFilename)));
            while ((servLine = br.readLine()) != null && port == -1) {
                if (servLine.length() == 0 || servLine.charAt(0) == '#') continue;
                port = JnsObject.parseServicesLine(servLine, serviceName);
            }
            br.close();
            return port;
        }
        catch (IOException ioe) {
            return -1;
        }
    }

    private static String getServicesFileName() {
        boolean isWin = false;
        Process proc = null;
        String servFileName = null;
        Runtime r = Runtime.getRuntime();
        String OS = System.getProperty("os.name").toLowerCase();
        if (OS.indexOf("windows 9") > -1) {
            isWin = true;
            try {
                proc = r.exec("command.com /c set");
            }
            catch (IOException e) {
                return null;
            }
        }
        if (OS.indexOf("windows") > -1) {
            isWin = true;
            try {
                proc = r.exec("cmd.exe /c set");
            }
            catch (IOException e) {
                return null;
            }
        }
        if (isWin) {
            BufferedReader br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            try {
                String line;
                while ((line = br.readLine()) != null) {
                    int idx = line.indexOf(61);
                    String key = line.substring(0, idx);
                    String value = line.substring(idx + 1);
                    if (!key.toLowerCase().equals("systemroot")) continue;
                    servFileName = value + "\\system32\\drivers\\etc\\services";
                }
            }
            catch (IOException e) {
                return null;
            }
        } else {
            servFileName = "//etc//services";
        }
        return servFileName;
    }

    private static int parseServicesLine(String line, String serviceName) {
        StringTokenizer st = new StringTokenizer(line, " \t/");
        if (!st.hasMoreTokens()) {
            return -1;
        }
        String name = st.nextToken().trim();
        if (!st.hasMoreTokens()) {
            return -1;
        }
        String portNum = st.nextToken().trim();
        if (!st.hasMoreTokens()) {
            return -1;
        }
        String portType = st.nextToken().trim();
        if (name.equals(serviceName) && portType.toLowerCase().equals("tcp")) {
            try {
                return Integer.parseInt(portNum);
            }
            catch (NumberFormatException nfe) {
                return -1;
            }
        }
        return -1;
    }
}

