/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal.repository.manager;

import com.ibm.db2.cmx.runtime.exception.DataRuntimeException;
import com.ibm.db2.cmx.runtime.internal.repository.MetadataException;
import com.ibm.db2.cmx.runtime.internal.repository.api.RepositoryVersion;
import com.ibm.db2.cmx.runtime.internal.repository.api.exception.RepositoryConnectionClosedException;
import com.ibm.db2.cmx.runtime.internal.repository.manager.ConnectionManager;
import com.ibm.db2.cmx.runtime.internal.repository.manager.RepositoryDataFactory;
import com.ibm.db2.cmx.runtime.internal.repository.manager.RepositoryVersionImpl;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.loader.RepositorySetupException;
import com.ibm.db2.cmx.runtime.internal.repository.sql.pkg.pk2.AccessMetaDataAppl;
import com.ibm.db2.cmx.runtime.internal.trace.Log;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RepositoryUtility {
    private static final String PQ_SCHEMA_ID_BASE = "com.ibm.pureQuery";
    public static final String PQ_SCHEMA_ID = "com.ibm.pureQuery";
    public static final String PQ_SCHEMA_ID_LITE = "com.ibm.pureQuery.lite";
    private static int[] setupVersion = null;

    public static int[] getSetupVersion() throws IOException, RepositorySetupException {
        if (setupVersion == null) {
            setupVersion = new int[3];
            RepositoryUtility.setupVersion[0] = RepositoryVersion.currentVersion.getVersion();
            RepositoryUtility.setupVersion[1] = RepositoryVersion.currentVersion.getRelease();
            RepositoryUtility.setupVersion[2] = RepositoryVersion.currentVersion.getMod();
        }
        return setupVersion;
    }

    public static void resetSetupVersion() {
        setupVersion = null;
    }

    public static RepositoryVersionImpl getPQRepositoryVersion(Connection connection, String string) throws MetadataException {
        ConnectionManager.ConnectionInfo connectionInfo = ConnectionManager.getConnectionInfo(connection);
        if (connectionInfo == null) {
            connectionInfo = new ConnectionManager.ConnectionInfo();
            connectionInfo.currentSchemaName = string;
        }
        return RepositoryUtility.getPQRepositoryVersion(connection, connectionInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RepositoryVersionImpl getPQRepositoryVersion(Connection connection, ConnectionManager.ConnectionInfo connectionInfo) throws MetadataException {
        Object object;
        int n2;
        Object object2;
        List<Map<String, Object>> list = null;
        try {
            object2 = RepositoryDataFactory.getData(AccessMetaDataAppl.class, connection, connectionInfo);
            list = object2.getRU();
        }
        catch (DataRuntimeException dataRuntimeException) {
            list = null;
            Logger logger = Log.getLogger();
            int n3 = n2 = logger != null && logger.isLoggable(Level.FINE) ? 1 : 0;
            if (n2 != 0) {
                object = "Error when reading repository version";
                logger.logp(Level.FINE, "RepositoryVersionImpl", "getPQRepositoryVersion", (String)object, dataRuntimeException);
            }
            try {
                if (connection.isClosed()) {
                    object = null;
                    while (dataRuntimeException.getCause() != null && object == null) {
                        Throwable throwable = dataRuntimeException.getCause();
                        if (!(throwable instanceof SQLException)) continue;
                        object = (SQLException)throwable;
                    }
                    throw new RepositoryConnectionClosedException(null, (Throwable)object);
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (list == null) {
            return null;
        }
        object2 = null;
        try {
            int n4 = list.size();
            for (n2 = 0; n2 < n4; ++n2) {
                object = list.get(n2);
                Number number = (Number)object.get("version");
                Number number2 = (Number)object.get("release");
                Number number3 = (Number)object.get("mod");
                object2 = new RepositoryVersionImpl((String)object.get("component"), number != null ? number.intValue() : -1, number2 != null ? number2.intValue() : -1, number3 != null ? number3.intValue() : -1);
            }
        }
        catch (Throwable throwable) {
        }
        return object2;
    }

    public static int isRepositoryVersion(Connection connection, String string, String string2, int n2, int n3, int n4) throws MetadataException {
        RepositoryVersionImpl repositoryVersionImpl = new RepositoryVersionImpl(string2, n2, n3, n4);
        RepositoryVersionImpl repositoryVersionImpl2 = RepositoryUtility.getPQRepositoryVersion(connection, string);
        int n5 = -1;
        if (repositoryVersionImpl2 != null) {
            n5 = repositoryVersionImpl2.compareTo(repositoryVersionImpl);
        }
        return n5;
    }
}

