/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.db.dao.jdbc;

import com.ibatis.db.dao.DaoException;
import com.ibatis.db.dao.DaoTransaction;
import com.ibatis.db.dao.DaoTransactionPool;
import com.ibatis.db.dao.jdbc.JdbcDaoTransaction;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import javax.sql.DataSource;

public class SimpleDaoTransactionPool
implements DaoTransactionPool {
    private DataSource dataSource = null;
    static /* synthetic */ Class class$java$util$Map;

    public void configure(Map map) throws DaoException {
        try {
            this.dataSource = (DataSource)Class.forName("com.ibatis.common.jdbc.SimpleDataSource").getConstructor(class$java$util$Map == null ? (class$java$util$Map = SimpleDaoTransactionPool.class$("java.util.Map")) : class$java$util$Map).newInstance(map);
        }
        catch (Exception exception) {
            try {
                this.dataSource = (DataSource)Class.forName("com.ibatis.db.jdbc.SimpleDataSource").getConstructor(class$java$util$Map == null ? (class$java$util$Map = SimpleDaoTransactionPool.class$("java.util.Map")) : class$java$util$Map).newInstance(map);
            }
            catch (Exception exception2) {
                throw new RuntimeException("Error configuring SimpleDaoTransactionPool.  Cause: " + exception);
            }
        }
    }

    public void releaseTransaction(DaoTransaction daoTransaction) throws DaoException {
        if (this.dataSource == null) {
            throw new DaoException("DataSource is null in JdbcDaoTransactionPool (check the data source configuration).");
        }
        try {
            ((JdbcDaoTransaction)daoTransaction).getConnection().close();
        }
        catch (SQLException sQLException) {
            throw new DaoException("Error releasing transaction.  Cause: " + sQLException, sQLException);
        }
    }

    public DaoTransaction getTransaction() throws DaoException {
        if (this.dataSource == null) {
            throw new DaoException("DataSource is null in JdbcDaoTransactionPool (check the data source configuration).");
        }
        try {
            Connection connection = this.dataSource.getConnection();
            if (connection.getAutoCommit()) {
                connection.setAutoCommit(false);
            }
            return new JdbcDaoTransaction(this, connection);
        }
        catch (SQLException sQLException) {
            throw new DaoException("Error getting transaction.  Cause: " + sQLException, sQLException);
        }
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

