/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.db.dao.jdbc;

import com.ibatis.db.dao.DaoException;
import com.ibatis.db.dao.DaoTransaction;
import com.ibatis.db.dao.DaoTransactionPool;
import java.sql.Connection;
import java.sql.SQLException;

public class JdbcDaoTransaction
implements DaoTransaction {
    private DaoTransactionPool pool;
    private Connection connection;

    public JdbcDaoTransaction(DaoTransactionPool daoTransactionPool, Connection connection) {
        this.pool = daoTransactionPool;
        this.connection = connection;
    }

    public Connection getConnection() throws DaoException {
        if (this.connection == null) {
            throw new DaoException("Connection was null in JdbcDaoTransaction.");
        }
        return this.connection;
    }

    public void commit() throws DaoException {
        try {
            if (this.connection == null) {
                throw new DaoException("Connection was null in JdbcDaoTransaction.");
            }
            this.connection.commit();
        }
        catch (SQLException sQLException) {
            throw new DaoException(sQLException);
        }
    }

    public void rollback() throws DaoException {
        try {
            if (this.connection == null) {
                throw new DaoException("Connection was null in JdbcDaoTransaction.");
            }
            this.connection.rollback();
        }
        catch (SQLException sQLException) {
            throw new DaoException(sQLException);
        }
    }

    public void release() throws DaoException {
        this.pool.releaseTransaction(this);
    }
}

