/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.db.dao;

import com.ibatis.common.resources.Resources;
import com.ibatis.db.dao.DaoException;
import com.ibatis.db.dao.DaoJarEntityResolver;
import com.ibatis.db.dao.DaoManager;
import com.ibatis.db.dao.DaoTransactionPool;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlDaoManagerBuilder {
    private static final String DAO_CONFIG_ELEMENT = "dao-config";
    private static final String CONTEXT_ELEMENT = "context";
    private static final String TRANS_POOL_ELEMENT = "transaction-pool";
    private static final String DAO_FACTORY_ELEMENT = "dao-factory";
    private static final String PROPERTIES_ELEMENT = "properties";
    private static final String PROPERTY_ELEMENT = "property";
    private static final String EXTRA_PROPS_ELEMENT = "extra-properties";
    private static final String DAO_ELEMENT = "dao";
    private static Properties properties = null;
    private static boolean validationEnabled = true;

    public static synchronized DaoManager[] buildDaoManagers(Reader reader, Properties properties) throws DaoException {
        XmlDaoManagerBuilder.properties = properties;
        return XmlDaoManagerBuilder.buildDaoManagers(reader);
    }

    public static synchronized DaoManager[] buildDaoManagers(Reader reader) throws DaoException {
        ArrayList<DaoManager> arrayList = new ArrayList<DaoManager>();
        try {
            Document document = XmlDaoManagerBuilder.getDoc(reader);
            Element element = (Element)document.getLastChild();
            String string = element.getNodeName();
            if (!DAO_CONFIG_ELEMENT.equals(string)) {
                throw new IOException("Error while configuring DaoManager.  The root tag of the DAO configuration XML document must be 'dao-config'.");
            }
            NodeList nodeList = element.getChildNodes();
            int n = 0;
            while (n < nodeList.getLength()) {
                Node node = nodeList.item(n);
                if (node.getNodeType() == 1) {
                    Object object;
                    if (CONTEXT_ELEMENT.equals(node.getNodeName())) {
                        object = XmlDaoManagerBuilder.parseContext((Element)node);
                        ((DaoManager)object).initializeDaoObjects();
                        arrayList.add((DaoManager)object);
                    } else if (PROPERTIES_ELEMENT.equals(node.getNodeName()) && properties == null) {
                        object = XmlDaoManagerBuilder.parseAttributes(node);
                        String string2 = ((Properties)object).getProperty("resource");
                        properties = Resources.getResourceAsProperties((String)string2);
                    }
                }
                ++n;
            }
        }
        catch (Exception exception) {
            throw new DaoException("Error while configuring DaoManager.  Cause: " + exception.toString(), exception);
        }
        return arrayList.toArray(new DaoManager[arrayList.size()]);
    }

    public static boolean isValidationEnabled() {
        return validationEnabled;
    }

    public static void setValidationEnabled(boolean bl) {
        validationEnabled = bl;
    }

    private static DaoManager parseContext(Element element) throws DaoException {
        DaoManager daoManager = DaoManager.newInstance();
        Properties properties = XmlDaoManagerBuilder.parseAttributes(element);
        daoManager.setName(properties.getProperty("name"));
        daoManager.setDefault("true".equals(properties.getProperty("default")));
        Element element2 = null;
        Element element3 = null;
        Element element4 = null;
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Element element5 = (Element)nodeList.item(n);
            if (element5.getNodeType() == 1) {
                if (TRANS_POOL_ELEMENT.equals(element5.getNodeName())) {
                    element2 = element5;
                } else if (DAO_FACTORY_ELEMENT.equals(element5.getNodeName())) {
                    element3 = element5;
                } else if (EXTRA_PROPS_ELEMENT.equals(element5.getNodeName())) {
                    element4 = element5;
                }
            }
            ++n;
        }
        if (element4 != null) {
            XmlDaoManagerBuilder.parseExtraPropertyElements(daoManager, element4);
        }
        if (element2 != null) {
            XmlDaoManagerBuilder.parseTransactionPool(daoManager, element2);
        }
        if (element3 != null) {
            XmlDaoManagerBuilder.parseDaoFactory(daoManager, element3);
        }
        return daoManager;
    }

    private static DaoTransactionPool parseTransactionPool(DaoManager daoManager, Element element) throws DaoException {
        DaoTransactionPool daoTransactionPool = null;
        Properties properties = XmlDaoManagerBuilder.parseAttributes(element);
        String string = properties.getProperty("implementation");
        try {
            daoTransactionPool = (DaoTransactionPool)Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            throw new DaoException("Error while configuring DaoManager.  Cause: " + exception.toString(), exception);
        }
        Properties properties2 = XmlDaoManagerBuilder.parsePropertyElements(element);
        daoTransactionPool.configure(properties2);
        if (daoTransactionPool == null) {
            throw new DaoException("Error while configuring DaoManager.  Some unknown condition caused the DaoTransactionPool to be null after configuration.");
        }
        daoManager.setTransactionPool(daoTransactionPool);
        return daoTransactionPool;
    }

    private static void parseDaoFactory(DaoManager daoManager, Element element) {
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Element element2 = (Element)nodeList.item(n);
            if (element2.getNodeType() == 1 && DAO_ELEMENT.equals(element2.getNodeName())) {
                Properties properties = XmlDaoManagerBuilder.parseAttributes(element2);
                String string = properties.getProperty("name");
                String string2 = properties.getProperty("implementation");
                daoManager.addDaoClass(string, string2);
            }
            ++n;
        }
    }

    private static void parseExtraPropertyElements(DaoManager daoManager, Element element) {
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Element element2 = (Element)nodeList.item(n);
            if (PROPERTY_ELEMENT.equals(element2.getNodeName())) {
                Properties properties = XmlDaoManagerBuilder.parseAttributes(element2);
                String string = properties.getProperty("name");
                String string2 = properties.getProperty("value");
                daoManager.setExtraProperty(string, string2);
            }
            ++n;
        }
    }

    private static Properties parsePropertyElements(Element element) {
        Properties properties = new Properties();
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node.getNodeType() == 1 && PROPERTY_ELEMENT.equals(node.getNodeName())) {
                Properties properties2 = XmlDaoManagerBuilder.parseAttributes(node);
                String string = properties2.getProperty("name");
                String string2 = properties2.getProperty("value");
                properties.setProperty(string, string2);
            }
            ++n;
        }
        return properties;
    }

    private static Properties parseAttributes(Node node) {
        Properties properties = new Properties();
        NamedNodeMap namedNodeMap = node.getAttributes();
        int n = 0;
        while (n < namedNodeMap.getLength()) {
            Node node2 = namedNodeMap.item(n);
            String string = XmlDaoManagerBuilder.parsePropertyTokens(node2.getNodeValue());
            ((Hashtable)properties).put(node2.getNodeName(), string);
            ++n;
        }
        return properties;
    }

    private static String parsePropertyTokens(String string) {
        String string2 = string;
        if (string2 != null && properties != null) {
            int n = string2.indexOf("${");
            int n2 = string2.indexOf("}");
            while (n > -1 && n2 > n) {
                String string3 = string2.substring(0, n);
                String string4 = string2.substring(n2 + "}".length());
                String string5 = string2.substring(n + "${".length(), n2);
                String string6 = properties.getProperty(string5);
                string2 = string6 == null ? string3 + string4 : string3 + string6 + string4;
                n = string2.indexOf("${");
                n2 = string2.indexOf("}");
            }
        }
        return string2;
    }

    private static Document getDoc(Reader reader) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(false);
            documentBuilderFactory.setValidating(true);
            documentBuilderFactory.setIgnoringComments(true);
            documentBuilderFactory.setIgnoringElementContentWhitespace(true);
            documentBuilderFactory.setCoalescing(false);
            documentBuilderFactory.setExpandEntityReferences(false);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(System.err);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setErrorHandler(new SimpleErrorHandler(new PrintWriter((Writer)outputStreamWriter, true)));
            documentBuilder.setEntityResolver(new DaoJarEntityResolver());
            Document document = documentBuilder.parse(new ReaderInputStream(reader));
            return document;
        }
        catch (Exception exception) {
            throw new RuntimeException("XML Parser Error.  Cause: " + exception);
        }
    }

    private static class ReaderInputStream
    extends InputStream {
        protected Reader reader;
        protected ByteArrayOutputStream byteArrayOut;
        protected Writer writer;
        protected char[] chars;
        protected byte[] buffer;
        protected int index;
        protected int length;

        public ReaderInputStream(Reader reader) {
            this.reader = reader;
            this.byteArrayOut = new ByteArrayOutputStream();
            this.writer = new OutputStreamWriter(this.byteArrayOut);
            this.chars = new char[1024];
        }

        public ReaderInputStream(Reader reader, String string) throws UnsupportedEncodingException {
            this.reader = reader;
            this.byteArrayOut = new ByteArrayOutputStream();
            this.writer = new OutputStreamWriter((OutputStream)this.byteArrayOut, string);
            this.chars = new char[1024];
        }

        public int read() throws IOException {
            if (this.index >= this.length) {
                this.fillBuffer();
            }
            if (this.index >= this.length) {
                return -1;
            }
            return 0xFF & this.buffer[this.index++];
        }

        protected void fillBuffer() throws IOException {
            if (this.length < 0) {
                return;
            }
            int n = this.reader.read(this.chars);
            if (n < 0) {
                this.length = -1;
            } else {
                this.byteArrayOut.reset();
                this.writer.write(this.chars, 0, n);
                this.writer.flush();
                this.buffer = this.byteArrayOut.toByteArray();
                this.length = this.buffer.length;
                this.index = 0;
            }
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (this.index >= this.length) {
                this.fillBuffer();
            }
            if (this.index >= this.length) {
                return -1;
            }
            int n3 = Math.min(n2, this.length - this.index);
            System.arraycopy(this.buffer, this.index, byArray, n, n3);
            this.index += n3;
            return n3;
        }

        public int available() throws IOException {
            return this.index < this.length ? this.length - this.index : (this.length >= 0 && this.reader.ready() ? 1 : 0);
        }

        public void close() throws IOException {
            this.reader.close();
        }
    }

    private static class SimpleErrorHandler
    implements ErrorHandler {
        private PrintWriter out;

        SimpleErrorHandler(PrintWriter printWriter) {
            this.out = printWriter;
        }

        private String getParseExceptionInfo(SAXParseException sAXParseException) {
            String string = sAXParseException.getSystemId();
            if (string == null) {
                string = "null";
            }
            String string2 = "URI=" + string + " Line=" + sAXParseException.getLineNumber() + ": " + sAXParseException.getMessage();
            return string2;
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            this.out.println("Warning: " + this.getParseExceptionInfo(sAXParseException));
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            String string = "Error: " + this.getParseExceptionInfo(sAXParseException);
            throw new SAXException(string);
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            String string = "Fatal Error: " + this.getParseExceptionInfo(sAXParseException);
            throw new SAXException(string);
        }
    }
}

