/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.db.dao;

import com.ibatis.db.dao.Dao;
import com.ibatis.db.dao.DaoException;
import com.ibatis.db.dao.DaoTransaction;
import com.ibatis.db.dao.DaoTransactionPool;
import com.ibatis.db.dao.XmlDaoManagerBuilder;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;

public class DaoManager {
    protected static final String DEFAULT_CONTEXT_NAME = "__DEFAULT__CONTEXT__NAME";
    protected static final Map daoManagerReverseLookup = new HashMap();
    protected static final Map daoContextMap = new HashMap();
    protected String name = null;
    protected boolean isDefaultContext = false;
    protected DaoTransactionPool transactionPool = null;
    protected Properties extraProperties = new Properties();
    protected ThreadLocal localTransaction = new ThreadLocal();
    protected Map daoClassMap = new HashMap();
    protected Map daoMap = new HashMap();

    protected DaoManager() {
    }

    public static void configure(InputStream inputStream) throws DaoException {
        DaoManager.configure(new InputStreamReader(inputStream));
    }

    public static void configure(Reader reader) throws DaoException {
        DaoManager.configure(reader, null);
    }

    public static void configure(Reader reader, Properties properties) throws DaoException {
        daoContextMap.clear();
        daoManagerReverseLookup.clear();
        DaoManager[] daoManagerArray = XmlDaoManagerBuilder.buildDaoManagers(reader, properties);
        int n = 0;
        while (n < daoManagerArray.length) {
            DaoManager daoManager = daoManagerArray[n];
            DaoManager.registerDaoManager(daoManager.getName(), daoManager);
            if (daoManager.isDefault()) {
                if (DaoManager.getInstance() == null) {
                    DaoManager.registerDaoManager(DEFAULT_CONTEXT_NAME, daoManager);
                } else {
                    throw new DaoException("Error while configuring DaoManager.  There can be only one default DAO context.");
                }
            }
            ++n;
        }
    }

    public static DaoManager newInstance() {
        return new DaoManager();
    }

    public static Iterator getInstanceNames() {
        TreeSet<String> treeSet = new TreeSet<String>();
        Iterator iterator = daoContextMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string.equals(DEFAULT_CONTEXT_NAME)) continue;
            treeSet.add(string);
        }
        return treeSet.iterator();
    }

    public static DaoManager getInstance() {
        return (DaoManager)daoContextMap.get(DEFAULT_CONTEXT_NAME);
    }

    public static DaoManager getInstance(String string) {
        return (DaoManager)daoContextMap.get(string);
    }

    public static DaoManager getInstance(Dao dao) {
        return (DaoManager)daoManagerReverseLookup.get(dao);
    }

    public Dao getDao(String string) {
        return (Dao)this.daoMap.get(string);
    }

    public void addDaoClass(String string, String string2) {
        this.daoClassMap.put(string, string2);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public boolean isDefault() {
        return this.isDefaultContext;
    }

    public void setDefault(boolean bl) {
        this.isDefaultContext = bl;
    }

    public String getExtraProperty(String string) {
        return this.extraProperties.getProperty(string);
    }

    public void setExtraProperty(String string, String string2) {
        this.extraProperties.setProperty(string, string2);
    }

    public DaoTransactionPool getTransactionPool() {
        return this.transactionPool;
    }

    public void setTransactionPool(DaoTransactionPool daoTransactionPool) {
        this.transactionPool = daoTransactionPool;
    }

    public DaoTransaction getTransaction() throws DaoException {
        if (this.transactionPool == null) {
            throw new DaoException("DaoManager could not get DaoTransaction.  DaoTransactionPool was null (possibly not configured).");
        }
        return this.transactionPool.getTransaction();
    }

    public void releaseTransaction(DaoTransaction daoTransaction) throws DaoException {
        if (this.transactionPool == null) {
            throw new DaoException("DaoManager could not release DaoTransaction.  DaoTransactionPool was null (possibly not configured).");
        }
        this.transactionPool.releaseTransaction(daoTransaction);
    }

    public boolean isTransactionStarted() throws DaoException {
        return this.localTransaction.get() != null;
    }

    public void startTransaction() throws DaoException {
        if (this.transactionPool == null) {
            throw new DaoException("DaoManager could not start DaoTransaction.  DaoTransactionPool was null (possibly not configured).");
        }
        if (this.localTransaction.get() != null) {
            throw new DaoException("DaoManager could not invoke startTransaction(). A transaction is already started. Call commitTransaction() or rollbackTransaction first.");
        }
        this.localTransaction.set(this.transactionPool.getTransaction());
    }

    public DaoTransaction getLocalTransaction() throws DaoException {
        if (this.localTransaction.get() == null) {
            throw new DaoException("DaoManager could not invoke getLocalTransaction(). No transaction was started. Call startTransaction() first.");
        }
        return (DaoTransaction)this.localTransaction.get();
    }

    public void commitTransaction() throws DaoException {
        if (this.localTransaction.get() == null) {
            throw new DaoException("DaoManager could not invoke commitTransaction(). No transaction was started. Call startTransaction() first.");
        }
        try {
            DaoTransaction daoTransaction = null;
            try {
                daoTransaction = (DaoTransaction)this.localTransaction.get();
                daoTransaction.commit();
                Object var3_2 = null;
                if (daoTransaction != null) {
                    daoTransaction.release();
                }
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                if (daoTransaction != null) {
                    daoTransaction.release();
                }
                throw throwable;
            }
            Object var5_5 = null;
            this.localTransaction.set(null);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.localTransaction.set(null);
            throw throwable;
        }
    }

    public void rollbackTransaction() throws DaoException {
        try {
            DaoTransaction daoTransaction = null;
            try {
                daoTransaction = (DaoTransaction)this.localTransaction.get();
                if (daoTransaction != null) {
                    daoTransaction.rollback();
                }
                Object var3_2 = null;
                if (daoTransaction != null) {
                    daoTransaction.release();
                }
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                if (daoTransaction != null) {
                    daoTransaction.release();
                }
                throw throwable;
            }
            Object var5_5 = null;
            this.localTransaction.set(null);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.localTransaction.set(null);
            throw throwable;
        }
    }

    protected void initializeDaoObjects() throws DaoException {
        Iterator iterator = this.daoClassMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)this.daoClassMap.get(string);
            try {
                Class<?> clazz = Class.forName(string2);
                Object obj = clazz.newInstance();
                this.registerDao(string, (Dao)obj);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new DaoException("DaoManager could not configure DaoFactory.  The DAO named '" + string + "' failed. Cause: " + classNotFoundException, classNotFoundException);
            }
            catch (InstantiationException instantiationException) {
                throw new DaoException("DaoManager could not configure DaoFactory.  The DAO named '" + string + "' failed. Cause: " + instantiationException, instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new DaoException("DaoManager could not configure DaoFactory.  The DAO named '" + string + "' failed. Cause: " + illegalAccessException, illegalAccessException);
            }
            catch (Throwable throwable) {
                throw new DaoException("DaoManager could not configure DaoFactory.  The DAO named '" + string + "' failed. Cause: " + throwable, throwable);
            }
        }
    }

    protected void registerDao(String string, Dao dao) {
        this.daoMap.put(string, dao);
        daoManagerReverseLookup.put(dao, this);
    }

    protected static void registerDaoManager(Object object, DaoManager daoManager) {
        daoContextMap.put(object, daoManager);
    }
}

