/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.interceptors.http;

import com.google.common.base.Stopwatch;
import com.hubspot.horizon.HttpRequest;
import com.hubspot.horizon.HttpResponse;
import com.hubspot.slack.client.interceptors.http.HttpFormatter;
import com.hubspot.slack.client.interceptors.http.ResponseDebugger;
import com.hubspot.slack.client.methods.SlackMethod;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHttpResponseDebugger
implements ResponseDebugger {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultHttpResponseDebugger.class);

    @Override
    public void debugTransportException(long requestId, SlackMethod method, HttpRequest request, Throwable exception) {
        LOG.error("REQ<{}> [{}]: Failed because {}", new Object[]{requestId, method, exception.getCause().getMessage(), exception});
    }

    @Override
    public void debug(long requestId, SlackMethod method, Stopwatch timer, HttpRequest request, HttpResponse response) {
        LOG.debug("REQ<{}> [{}, completion in {}ms]: Received \n\n{}", new Object[]{requestId, method, timer.elapsed(TimeUnit.MILLISECONDS), HttpFormatter.formatResponse(response)});
    }

    @Override
    public void debugSlackApiError(long requestId, SlackMethod method, HttpRequest request, HttpResponse failure) {
        LOG.error("REQ<{}> [{}]: Failed interaction\n{}\n{}", new Object[]{requestId, method, HttpFormatter.formatRequest(request), HttpFormatter.formatResponse(failure)});
    }

    @Override
    public void debugProcessingFailure(long requestId, SlackMethod method, HttpRequest request, HttpResponse response, Throwable ex) {
        LOG.error("REQ<{}> [{}]: Failed interaction\n{}\n{}", new Object[]{requestId, method, HttpFormatter.formatRequest(request), HttpFormatter.formatResponse(response), ex});
    }

    @Override
    public void debugProactiveRateLimit(long requestId, SlackMethod method, HttpRequest request) {
        LOG.debug("REQ<{}> [{}]: Proactively rate limited request\n{}", new Object[]{requestId, method, HttpFormatter.formatRequest(request)});
    }
}

